/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging.spi.v2;

import com.google.api.MonitoredResource;
import com.google.api.gax.grpc.ChannelAndExecutor;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.cloud.logging.spi.v2.LoggingServiceV2Settings;
import com.google.cloud.logging.spi.v2.PagedResponseWrappers;
import com.google.logging.v2.DeleteLogRequest;
import com.google.logging.v2.ListLogEntriesRequest;
import com.google.logging.v2.ListLogEntriesResponse;
import com.google.logging.v2.ListLogsRequest;
import com.google.logging.v2.ListLogsResponse;
import com.google.logging.v2.ListMonitoredResourceDescriptorsRequest;
import com.google.logging.v2.ListMonitoredResourceDescriptorsResponse;
import com.google.logging.v2.LogEntry;
import com.google.logging.v2.LogNameOneof;
import com.google.logging.v2.ParentNameOneof;
import com.google.logging.v2.WriteLogEntriesRequest;
import com.google.logging.v2.WriteLogEntriesResponse;
import com.google.protobuf.Empty;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;

public class LoggingServiceV2Client
implements AutoCloseable {
    private final LoggingServiceV2Settings settings;
    private final ScheduledExecutorService executor;
    private final ManagedChannel channel;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private final UnaryCallable<DeleteLogRequest, Empty> deleteLogCallable;
    private final UnaryCallable<WriteLogEntriesRequest, WriteLogEntriesResponse> writeLogEntriesCallable;
    private final UnaryCallable<ListLogEntriesRequest, ListLogEntriesResponse> listLogEntriesCallable;
    private final UnaryCallable<ListLogEntriesRequest, PagedResponseWrappers.ListLogEntriesPagedResponse> listLogEntriesPagedCallable;
    private final UnaryCallable<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse> listMonitoredResourceDescriptorsCallable;
    private final UnaryCallable<ListMonitoredResourceDescriptorsRequest, PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse> listMonitoredResourceDescriptorsPagedCallable;
    private final UnaryCallable<ListLogsRequest, ListLogsResponse> listLogsCallable;
    private final UnaryCallable<ListLogsRequest, PagedResponseWrappers.ListLogsPagedResponse> listLogsPagedCallable;

    public static final LoggingServiceV2Client create() throws IOException {
        return LoggingServiceV2Client.create(LoggingServiceV2Settings.defaultBuilder().build());
    }

    public static final LoggingServiceV2Client create(LoggingServiceV2Settings settings) throws IOException {
        return new LoggingServiceV2Client(settings);
    }

    protected LoggingServiceV2Client(LoggingServiceV2Settings settings) throws IOException {
        this.settings = settings;
        ChannelAndExecutor channelAndExecutor = settings.getChannelAndExecutor();
        this.executor = channelAndExecutor.getExecutor();
        this.channel = channelAndExecutor.getChannel();
        this.deleteLogCallable = UnaryCallable.create(settings.deleteLogSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.writeLogEntriesCallable = UnaryCallable.create(settings.writeLogEntriesSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.listLogEntriesCallable = UnaryCallable.create(settings.listLogEntriesSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.listLogEntriesPagedCallable = UnaryCallable.createPagedVariant(settings.listLogEntriesSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.listMonitoredResourceDescriptorsCallable = UnaryCallable.create(settings.listMonitoredResourceDescriptorsSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.listMonitoredResourceDescriptorsPagedCallable = UnaryCallable.createPagedVariant(settings.listMonitoredResourceDescriptorsSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.listLogsCallable = UnaryCallable.create(settings.listLogsSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.listLogsPagedCallable = UnaryCallable.createPagedVariant(settings.listLogsSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        if (settings.getChannelProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    LoggingServiceV2Client.this.channel.shutdown();
                }
            });
        }
        if (settings.getExecutorProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    LoggingServiceV2Client.this.executor.shutdown();
                }
            });
        }
    }

    public final LoggingServiceV2Settings getSettings() {
        return this.settings;
    }

    public final void deleteLog(LogNameOneof logName) {
        DeleteLogRequest request = DeleteLogRequest.newBuilder().setLogNameWithLogNameOneof(logName).build();
        this.deleteLog(request);
    }

    private final void deleteLog(DeleteLogRequest request) {
        this.deleteLogCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteLogRequest, Empty> deleteLogCallable() {
        return this.deleteLogCallable;
    }

    public final WriteLogEntriesResponse writeLogEntries(LogNameOneof logName, MonitoredResource resource, Map<String, String> labels, List<LogEntry> entries) {
        WriteLogEntriesRequest request = WriteLogEntriesRequest.newBuilder().setLogNameWithLogNameOneof(logName).setResource(resource).putAllLabels(labels).addAllEntries(entries).build();
        return this.writeLogEntries(request);
    }

    public final WriteLogEntriesResponse writeLogEntries(WriteLogEntriesRequest request) {
        return (WriteLogEntriesResponse)this.writeLogEntriesCallable().call((Object)request);
    }

    public final UnaryCallable<WriteLogEntriesRequest, WriteLogEntriesResponse> writeLogEntriesCallable() {
        return this.writeLogEntriesCallable;
    }

    public final PagedResponseWrappers.ListLogEntriesPagedResponse listLogEntries(List<String> resourceNames, String filter, String orderBy) {
        ListLogEntriesRequest request = ListLogEntriesRequest.newBuilder().addAllResourceNames(resourceNames).setFilter(filter).setOrderBy(orderBy).build();
        return this.listLogEntries(request);
    }

    public final PagedResponseWrappers.ListLogEntriesPagedResponse listLogEntries(ListLogEntriesRequest request) {
        return (PagedResponseWrappers.ListLogEntriesPagedResponse)((Object)this.listLogEntriesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLogEntriesRequest, PagedResponseWrappers.ListLogEntriesPagedResponse> listLogEntriesPagedCallable() {
        return this.listLogEntriesPagedCallable;
    }

    public final UnaryCallable<ListLogEntriesRequest, ListLogEntriesResponse> listLogEntriesCallable() {
        return this.listLogEntriesCallable;
    }

    public final PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse listMonitoredResourceDescriptors(ListMonitoredResourceDescriptorsRequest request) {
        return (PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse)((Object)this.listMonitoredResourceDescriptorsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListMonitoredResourceDescriptorsRequest, PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse> listMonitoredResourceDescriptorsPagedCallable() {
        return this.listMonitoredResourceDescriptorsPagedCallable;
    }

    public final UnaryCallable<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse> listMonitoredResourceDescriptorsCallable() {
        return this.listMonitoredResourceDescriptorsCallable;
    }

    public final PagedResponseWrappers.ListLogsPagedResponse listLogs(ParentNameOneof parent) {
        ListLogsRequest request = ListLogsRequest.newBuilder().setParentWithParentNameOneof(parent).build();
        return this.listLogs(request);
    }

    public final PagedResponseWrappers.ListLogsPagedResponse listLogs(ListLogsRequest request) {
        return (PagedResponseWrappers.ListLogsPagedResponse)((Object)this.listLogsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLogsRequest, PagedResponseWrappers.ListLogsPagedResponse> listLogsPagedCallable() {
        return this.listLogsPagedCallable;
    }

    public final UnaryCallable<ListLogsRequest, ListLogsResponse> listLogsCallable() {
        return this.listLogsCallable;
    }

    @Override
    public final void close() throws Exception {
        for (AutoCloseable closeable : this.closeables) {
            closeable.close();
        }
    }
}

