/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging;

import com.google.cloud.MonitoredResource;
import com.google.cloud.logging.LogEntry;
import com.google.cloud.logging.LoggingHandler;
import java.util.logging.LogRecord;

public class GaeFlexLoggingEnhancer
implements LoggingHandler.Enhancer {
    private static final ThreadLocal<String> traceId = new ThreadLocal();
    private final String gaeInstanceId = System.getenv("GAE_INSTANCE");

    public static void setCurrentTraceId(String id) {
        traceId.set(id);
    }

    public static String getCurrentTraceId() {
        return traceId.get();
    }

    @Override
    public void enhanceMonitoredResource(MonitoredResource.Builder builder) {
        if (this.gaeInstanceId != null) {
            if (System.getenv("GAE_SERVICE") != null) {
                builder.addLabel("module_id", System.getenv("GAE_SERVICE"));
            }
            if (System.getenv("GAE_VERSION") != null) {
                builder.addLabel("version_id", System.getenv("GAE_VERSION"));
            }
        }
    }

    @Override
    public void enhanceLogEntry(LogEntry.Builder builder, LogRecord record) {
        String traceId;
        if (this.gaeInstanceId != null) {
            builder.addLabel("appengine.googleapis.com/instance_name", this.gaeInstanceId);
        }
        if ((traceId = GaeFlexLoggingEnhancer.getCurrentTraceId()) != null) {
            builder.addLabel("appengine.googleapis.com/trace_id", traceId);
        }
    }
}

