/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging;

import com.google.common.base.MoreObjects;
import com.google.logging.type.HttpRequest;
import java.io.Serializable;
import java.util.Objects;

public final class HttpRequest
implements Serializable {
    private static final long serialVersionUID = -274998005454709817L;
    private final RequestMethod requestMethod;
    private final String requestUrl;
    private final Long requestSize;
    private final Integer status;
    private final Long responseSize;
    private final String userAgent;
    private final String remoteIp;
    private final String serverIp;
    private final String referer;
    private final boolean cacheLookup;
    private final boolean cacheHit;
    private final boolean cacheValidatedWithOriginServer;
    private final Long cacheFillBytes;

    HttpRequest(Builder builder) {
        this.requestMethod = builder.requestMethod;
        this.requestUrl = builder.requestUrl;
        this.requestSize = builder.requestSize;
        this.status = builder.status;
        this.responseSize = builder.responseSize;
        this.userAgent = builder.userAgent;
        this.remoteIp = builder.remoteIp;
        this.serverIp = builder.serverIp;
        this.referer = builder.referer;
        this.cacheLookup = builder.cacheLookup;
        this.cacheHit = builder.cacheHit;
        this.cacheValidatedWithOriginServer = builder.cacheValidatedWithOriginServer;
        this.cacheFillBytes = builder.cacheFillBytes;
    }

    @Deprecated
    public RequestMethod requestMethod() {
        return this.getRequestMethod();
    }

    public RequestMethod getRequestMethod() {
        return this.requestMethod;
    }

    @Deprecated
    public String requestUrl() {
        return this.getRequestUrl();
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    @Deprecated
    public Long requestSize() {
        return this.getRequestSize();
    }

    public Long getRequestSize() {
        return this.requestSize;
    }

    @Deprecated
    public Integer status() {
        return this.getStatus();
    }

    public Integer getStatus() {
        return this.status;
    }

    @Deprecated
    public Long responseSize() {
        return this.getResponseSize();
    }

    public Long getResponseSize() {
        return this.responseSize;
    }

    @Deprecated
    public String userAgent() {
        return this.getUserAgent();
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    @Deprecated
    public String remoteIp() {
        return this.getRemoteIp();
    }

    public String getRemoteIp() {
        return this.remoteIp;
    }

    @Deprecated
    public String serverIp() {
        return this.getServerIp();
    }

    public String getServerIp() {
        return this.serverIp;
    }

    @Deprecated
    public String referer() {
        return this.getReferer();
    }

    public String getReferer() {
        return this.referer;
    }

    public boolean cacheLookup() {
        return this.cacheLookup;
    }

    public boolean cacheHit() {
        return this.cacheHit;
    }

    public boolean cacheValidatedWithOriginServer() {
        return this.cacheValidatedWithOriginServer;
    }

    @Deprecated
    public Long cacheFillBytes() {
        return this.getCacheFillBytes();
    }

    public Long getCacheFillBytes() {
        return this.cacheFillBytes;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.requestMethod, this.requestUrl, this.requestSize, this.status, this.responseSize, this.userAgent, this.serverIp, this.cacheLookup, this.cacheFillBytes, this.remoteIp, this.referer, this.cacheHit, this.cacheValidatedWithOriginServer});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("requestMethod", (Object)this.requestMethod).add("requestUrl", (Object)this.requestUrl).add("requestSize", (Object)this.requestSize).add("status", (Object)this.status).add("responseSize", (Object)this.responseSize).add("userAgent", (Object)this.userAgent).add("remoteIp", (Object)this.remoteIp).add("serverIp", (Object)this.serverIp).add("referer", (Object)this.referer).add("cacheLookup", this.cacheLookup).add("cacheHit", this.cacheHit).add("cacheValidatedWithOriginServer", this.cacheValidatedWithOriginServer).add("cacheFillBytes", (Object)this.cacheFillBytes).toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HttpRequest)) {
            return false;
        }
        HttpRequest other = (HttpRequest)obj;
        return Objects.equals((Object)this.requestMethod, (Object)other.requestMethod) && Objects.equals(this.requestUrl, other.requestUrl) && Objects.equals(this.requestSize, other.requestSize) && Objects.equals(this.status, other.status) && Objects.equals(this.responseSize, other.responseSize) && Objects.equals(this.userAgent, other.userAgent) && Objects.equals(this.remoteIp, other.remoteIp) && Objects.equals(this.serverIp, other.serverIp) && Objects.equals(this.referer, other.referer) && this.cacheLookup == other.cacheLookup && this.cacheHit == other.cacheHit && this.cacheValidatedWithOriginServer == other.cacheValidatedWithOriginServer && Objects.equals(this.cacheFillBytes, other.cacheFillBytes);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    com.google.logging.type.HttpRequest toPb() {
        HttpRequest.Builder builder = com.google.logging.type.HttpRequest.newBuilder();
        if (this.requestMethod != null) {
            builder.setRequestMethod(this.requestMethod.name());
        }
        if (this.requestUrl != null) {
            builder.setRequestUrl(this.requestUrl);
        }
        if (this.requestSize != null) {
            builder.setRequestSize(this.requestSize.longValue());
        }
        if (this.status != null) {
            builder.setStatus(this.status.intValue());
        }
        if (this.responseSize != null) {
            builder.setResponseSize(this.responseSize.longValue());
        }
        if (this.userAgent != null) {
            builder.setUserAgent(this.userAgent);
        }
        if (this.remoteIp != null) {
            builder.setRemoteIp(this.remoteIp);
        }
        if (this.serverIp != null) {
            builder.setServerIp(this.serverIp);
        }
        if (this.referer != null) {
            builder.setReferer(this.referer);
        }
        builder.setCacheLookup(this.cacheLookup);
        builder.setCacheHit(this.cacheHit);
        builder.setCacheValidatedWithOriginServer(this.cacheValidatedWithOriginServer);
        if (this.cacheFillBytes != null) {
            builder.setCacheFillBytes(this.cacheFillBytes.longValue());
        }
        return builder.build();
    }

    @Deprecated
    public static Builder builder() {
        return HttpRequest.newBuilder();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static HttpRequest fromPb(com.google.logging.type.HttpRequest requestPb) {
        Builder builder = HttpRequest.newBuilder();
        if (requestPb.getRequestMethod() != null && !requestPb.getRequestMethod().equals("")) {
            builder.setRequestMethod(RequestMethod.valueOf(requestPb.getRequestMethod()));
        }
        if (requestPb.getRequestUrl() != null && !requestPb.getRequestUrl().equals("")) {
            builder.setRequestUrl(requestPb.getRequestUrl());
        }
        if (requestPb.getRequestSize() != 0L) {
            builder.setRequestSize(requestPb.getRequestSize());
        }
        if ((long)requestPb.getStatus() != 0L) {
            builder.setStatus(requestPb.getStatus());
        }
        if (requestPb.getResponseSize() != 0L) {
            builder.setResponseSize(requestPb.getResponseSize());
        }
        if (requestPb.getUserAgent() != null && !requestPb.getRequestUrl().equals("")) {
            builder.setUserAgent(requestPb.getUserAgent());
        }
        if (requestPb.getServerIp() != null && !requestPb.getServerIp().equals("")) {
            builder.setServerIp(requestPb.getServerIp());
        }
        if (requestPb.getRemoteIp() != null && !requestPb.getRemoteIp().equals("")) {
            builder.setRemoteIp(requestPb.getRemoteIp());
        }
        if (requestPb.getReferer() != null && !requestPb.getReferer().equals("")) {
            builder.setReferer(requestPb.getReferer());
        }
        builder.setCacheLookup(requestPb.getCacheLookup());
        builder.setCacheHit(requestPb.getCacheHit());
        builder.setCacheValidatedWithOriginServer(requestPb.getCacheValidatedWithOriginServer());
        if (requestPb.getCacheFillBytes() != 0L) {
            builder.setCacheFillBytes(requestPb.getCacheFillBytes());
        }
        return builder.build();
    }

    public static final class Builder {
        private RequestMethod requestMethod;
        private String requestUrl;
        private Long requestSize;
        private Integer status;
        private Long responseSize;
        private String userAgent;
        private String remoteIp;
        private String serverIp;
        private String referer;
        private boolean cacheLookup;
        private boolean cacheHit;
        private boolean cacheValidatedWithOriginServer;
        private Long cacheFillBytes;

        Builder() {
        }

        Builder(HttpRequest request) {
            this.requestMethod = request.requestMethod;
            this.requestUrl = request.requestUrl;
            this.requestSize = request.requestSize;
            this.status = request.status;
            this.responseSize = request.responseSize;
            this.userAgent = request.userAgent;
            this.remoteIp = request.remoteIp;
            this.serverIp = request.serverIp;
            this.referer = request.referer;
            this.cacheLookup = request.cacheLookup;
            this.cacheHit = request.cacheHit;
            this.cacheValidatedWithOriginServer = request.cacheValidatedWithOriginServer;
            this.cacheFillBytes = request.cacheFillBytes;
        }

        @Deprecated
        public Builder requestMethod(RequestMethod requestMethod) {
            return this.setRequestMethod(requestMethod);
        }

        public Builder setRequestMethod(RequestMethod requestMethod) {
            this.requestMethod = requestMethod;
            return this;
        }

        @Deprecated
        public Builder requestUrl(String requestUrl) {
            return this.setRequestUrl(requestUrl);
        }

        public Builder setRequestUrl(String requestUrl) {
            this.requestUrl = requestUrl;
            return this;
        }

        @Deprecated
        public Builder requestSize(long requestSize) {
            return this.setRequestSize(requestSize);
        }

        public Builder setRequestSize(long requestSize) {
            this.requestSize = requestSize;
            return this;
        }

        @Deprecated
        public Builder status(int status) {
            return this.setStatus(status);
        }

        public Builder setStatus(int status) {
            this.status = status;
            return this;
        }

        @Deprecated
        public Builder responseSize(long responseSize) {
            return this.setResponseSize(responseSize);
        }

        public Builder setResponseSize(long responseSize) {
            this.responseSize = responseSize;
            return this;
        }

        @Deprecated
        public Builder userAgent(String userAgent) {
            return this.setUserAgent(userAgent);
        }

        public Builder setUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        @Deprecated
        public Builder remoteIp(String remoteIp) {
            return this.setRemoteIp(remoteIp);
        }

        public Builder setRemoteIp(String remoteIp) {
            this.remoteIp = remoteIp;
            return this;
        }

        @Deprecated
        public Builder serverIp(String serverIp) {
            return this.setServerIp(serverIp);
        }

        public Builder setServerIp(String serverIp) {
            this.serverIp = serverIp;
            return this;
        }

        @Deprecated
        public Builder referer(String referer) {
            return this.setReferer(referer);
        }

        public Builder setReferer(String referer) {
            this.referer = referer;
            return this;
        }

        @Deprecated
        public Builder cacheLookup(boolean cacheLookup) {
            return this.setCacheLookup(cacheLookup);
        }

        public Builder setCacheLookup(boolean cacheLookup) {
            this.cacheLookup = cacheLookup;
            return this;
        }

        @Deprecated
        public Builder cacheHit(boolean cacheHit) {
            return this.setCacheHit(cacheHit);
        }

        public Builder setCacheHit(boolean cacheHit) {
            this.cacheHit = cacheHit;
            return this;
        }

        @Deprecated
        public Builder cacheValidatedWithOriginServer(boolean cacheValidatedWithOriginServer) {
            return this.setCacheValidatedWithOriginServer(cacheValidatedWithOriginServer);
        }

        public Builder setCacheValidatedWithOriginServer(boolean cacheValidatedWithOriginServer) {
            this.cacheValidatedWithOriginServer = cacheValidatedWithOriginServer;
            return this;
        }

        @Deprecated
        public Builder cacheFillBytes(long cacheFillBytes) {
            return this.setCacheFillBytes(cacheFillBytes);
        }

        public Builder setCacheFillBytes(long cacheFillBytes) {
            this.cacheFillBytes = cacheFillBytes;
            return this;
        }

        public HttpRequest build() {
            return new HttpRequest(this);
        }
    }

    public static enum RequestMethod {
        GET,
        HEAD,
        PUT,
        POST;

    }
}

