/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging;

import com.google.cloud.GrpcServiceOptions;
import com.google.cloud.logging.Logging;
import com.google.cloud.logging.LoggingException;
import com.google.cloud.logging.LoggingFactory;
import com.google.cloud.logging.LoggingImpl;
import com.google.cloud.logging.spi.DefaultLoggingRpc;
import com.google.cloud.logging.spi.LoggingRpc;
import com.google.cloud.logging.spi.LoggingRpcFactory;
import com.google.cloud.logging.spi.v2.LoggingServiceV2Settings;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;

public class LoggingOptions
extends GrpcServiceOptions<Logging, LoggingRpc, LoggingOptions> {
    private static final long serialVersionUID = -5117984564582881668L;
    private static final String LOGGING_SCOPE = "https://www.googleapis.com/auth/logging.admin";
    private static final Set<String> SCOPES = ImmutableSet.of((Object)"https://www.googleapis.com/auth/logging.admin");
    private static final String DEFAULT_HOST = LoggingServiceV2Settings.getDefaultServiceAddress() + ':' + LoggingServiceV2Settings.getDefaultServicePort();

    @Deprecated
    public static LoggingOptions defaultInstance() {
        return LoggingOptions.getDefaultInstance();
    }

    public static LoggingOptions getDefaultInstance() {
        return LoggingOptions.newBuilder().build();
    }

    protected String getDefaultHost() {
        return DEFAULT_HOST;
    }

    protected LoggingOptions(Builder builder) {
        super(LoggingFactory.class, LoggingRpcFactory.class, (GrpcServiceOptions.Builder)builder);
    }

    protected GrpcServiceOptions.ExecutorFactory<ScheduledExecutorService> getExecutorFactory() {
        return super.getExecutorFactory();
    }

    protected LoggingFactory getDefaultServiceFactory() {
        return DefaultLoggingFactory.INSTANCE;
    }

    protected LoggingRpcFactory getDefaultRpcFactory() {
        return DefaultLoggingRpcFactory.INSTANCE;
    }

    protected Set<String> getScopes() {
        return SCOPES;
    }

    public boolean equals(Object obj) {
        return obj instanceof LoggingOptions && this.baseEquals((LoggingOptions)((Object)obj));
    }

    public int hashCode() {
        return this.baseHashCode();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    @Deprecated
    public static Builder builder() {
        return LoggingOptions.newBuilder();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends GrpcServiceOptions.Builder<Logging, LoggingRpc, LoggingOptions, Builder> {
        private Builder() {
        }

        private Builder(LoggingOptions options) {
            super((GrpcServiceOptions)options);
        }

        public LoggingOptions build() {
            return new LoggingOptions(this);
        }
    }

    public static class DefaultLoggingRpcFactory
    implements LoggingRpcFactory {
        private static final LoggingRpcFactory INSTANCE = new DefaultLoggingRpcFactory();

        public LoggingRpc create(LoggingOptions options) {
            try {
                return new DefaultLoggingRpc(options);
            }
            catch (IOException e) {
                throw new LoggingException(e, true);
            }
        }
    }

    public static class DefaultLoggingFactory
    implements LoggingFactory {
        private static final LoggingFactory INSTANCE = new DefaultLoggingFactory();

        public Logging create(LoggingOptions options) {
            return new LoggingImpl(options);
        }
    }
}

