/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging;

import com.google.cloud.MonitoredResource;
import com.google.cloud.logging.LogEntry;
import com.google.cloud.logging.Logging;
import com.google.cloud.logging.LoggingLevel;
import com.google.cloud.logging.LoggingOptions;
import com.google.cloud.logging.Payload;
import com.google.cloud.logging.Severity;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class LoggingHandler
extends Handler {
    private static final String HANDLERS_PROPERTY = "handlers";
    private static final String ROOT_LOGGER_NAME = "";
    private static final String[] NO_HANDLERS = new String[0];
    private static final ThreadLocal<Boolean> inPublishCall = new ThreadLocal();
    private final LoggingOptions options;
    private final Logging.WriteOption[] writeOptions;
    private List<LogEntry> buffer = new LinkedList<LogEntry>();
    private volatile Logging logging;
    private Level flushLevel;
    private long flushSize;
    private final List<Enhancer> enhancers;

    public LoggingHandler() {
        this(null, null, null);
    }

    public LoggingHandler(String log) {
        this(log, null, null);
    }

    public LoggingHandler(String log, LoggingOptions options) {
        this(log, options, null);
    }

    public LoggingHandler(String log, LoggingOptions options, MonitoredResource monitoredResource) {
        this(log, options, monitoredResource, null);
    }

    public LoggingHandler(String log, LoggingOptions options, MonitoredResource monitoredResource, List<Enhancer> enhancers) {
        try {
            LogConfigHelper helper = new LogConfigHelper();
            String className = this.getClass().getName();
            this.options = options != null ? options : LoggingOptions.getDefaultInstance();
            this.flushLevel = helper.getLevelProperty(className + ".flushLevel", LoggingLevel.ERROR);
            this.flushSize = helper.getLongProperty(className + ".flushSize", 1L);
            this.setLevel(helper.getLevelProperty(className + ".level", Level.INFO));
            this.setFilter(helper.getFilterProperty(className + ".filter", null));
            this.setFormatter(helper.getFormatterProperty(className + ".formatter", new SimpleFormatter()));
            String logName = (String)MoreObjects.firstNonNull((Object)log, (Object)helper.getProperty(className + ".log", "java.log"));
            this.enhancers = enhancers != null ? enhancers : helper.getEnhancerProperty(className + ".enhancers");
            String resourceType = helper.getProperty(className + ".resourceType", "global");
            MonitoredResource resource = monitoredResource != null ? monitoredResource : this.getDefaultResource(resourceType);
            this.writeOptions = new Logging.WriteOption[]{Logging.WriteOption.logName(logName), Logging.WriteOption.resource(resource)};
        }
        catch (Exception ex) {
            this.reportError(null, ex, 4);
            throw ex;
        }
    }

    private static List<LoggingHandler> getLoggingHandlers(Logger logger) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Handler handler : logger.getHandlers()) {
            if (!(handler instanceof LoggingHandler)) continue;
            builder.add((Object)((LoggingHandler)handler));
        }
        return builder.build();
    }

    private static boolean hasLoggingHandler(Logger logger) {
        String[] handlers;
        for (Handler handler : logger.getHandlers()) {
            if (!(handler instanceof LoggingHandler)) continue;
            return true;
        }
        String loggerName = logger.getName();
        String propertyName = loggerName.equals(ROOT_LOGGER_NAME) ? HANDLERS_PROPERTY : loggerName + "." + HANDLERS_PROPERTY;
        String handlersProperty = LogManager.getLogManager().getProperty(propertyName);
        for (String handlerName : handlers = handlersProperty != null ? handlersProperty.split(",") : NO_HANDLERS) {
            if (!handlerName.contains(LoggingHandler.class.getPackage().getName())) continue;
            return true;
        }
        return false;
    }

    private MonitoredResource getDefaultResource(String resourceType) {
        MonitoredResource.Builder builder = MonitoredResource.newBuilder((String)resourceType);
        builder.addLabel("project_id", this.options.getProjectId());
        for (Enhancer enhancer : this.enhancers) {
            enhancer.enhanceMonitoredResource(builder);
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Logging getLogging() {
        if (this.logging == null) {
            LoggingHandler loggingHandler = this;
            synchronized (loggingHandler) {
                if (this.logging == null) {
                    this.logging = (Logging)this.options.getService();
                }
            }
        }
        return this.logging;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        if ("io.netty.handler.codec.http2.Http2FrameLogger".equals(record.getSourceClassName())) {
            return;
        }
        if (inPublishCall.get() != null) {
            return;
        }
        inPublishCall.set(true);
        try {
            LogEntry entry = this.entryFor(record);
            List<LogEntry> flushBuffer = null;
            Logging.WriteOption[] flushWriteOptions = null;
            LoggingHandler loggingHandler = this;
            synchronized (loggingHandler) {
                if (entry != null) {
                    this.buffer.add(entry);
                }
                if ((long)this.buffer.size() >= this.flushSize || record.getLevel().intValue() >= this.flushLevel.intValue()) {
                    flushBuffer = this.buffer;
                    flushWriteOptions = this.writeOptions;
                    this.buffer = new LinkedList<LogEntry>();
                }
            }
            this.flush(flushBuffer, flushWriteOptions);
        }
        finally {
            inPublishCall.remove();
        }
    }

    private LogEntry entryFor(LogRecord record) {
        try {
            String payload = this.getFormatter().format(record);
            Level level = record.getLevel();
            LogEntry.Builder builder = LogEntry.newBuilder(Payload.StringPayload.of(payload)).addLabel("levelName", level.getName()).addLabel("levelValue", String.valueOf(level.intValue())).setTimestamp(record.getMillis()).setSeverity(LoggingHandler.severityFor(level));
            for (Enhancer enhancer : this.enhancers) {
                enhancer.enhanceLogEntry(builder, record);
            }
            this.enhanceLogEntry(builder, record);
            return builder.build();
        }
        catch (Exception ex) {
            this.reportError(null, ex, 5);
            return null;
        }
    }

    @Deprecated
    protected void enhanceLogEntry(LogEntry.Builder builder, LogRecord record) {
    }

    private static Severity severityFor(Level level) {
        if (level instanceof LoggingLevel) {
            return ((LoggingLevel)level).getSeverity();
        }
        switch (level.intValue()) {
            case 300: {
                return Severity.DEBUG;
            }
            case 400: {
                return Severity.DEBUG;
            }
            case 500: {
                return Severity.DEBUG;
            }
            case 700: {
                return Severity.INFO;
            }
            case 800: {
                return Severity.INFO;
            }
            case 900: {
                return Severity.WARNING;
            }
            case 1000: {
                return Severity.ERROR;
            }
        }
        return Severity.DEFAULT;
    }

    void write(List<LogEntry> entries, Logging.WriteOption ... options) {
        this.getLogging().writeAsync(entries, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Logging.WriteOption[] flushWriteOptions;
        List<LogEntry> flushBuffer;
        LoggingHandler loggingHandler = this;
        synchronized (loggingHandler) {
            if (this.buffer.isEmpty()) {
                return;
            }
            flushBuffer = this.buffer;
            flushWriteOptions = this.writeOptions;
            this.buffer = new LinkedList<LogEntry>();
        }
        this.flush(flushBuffer, flushWriteOptions);
    }

    private void flush(List<LogEntry> flushBuffer, Logging.WriteOption[] flushWriteOptions) {
        if (flushBuffer == null) {
            return;
        }
        try {
            this.write(flushBuffer, flushWriteOptions);
        }
        catch (Exception ex) {
            this.reportError(null, ex, 2);
        }
    }

    @Override
    public synchronized void close() throws SecurityException {
        if (this.logging != null) {
            try {
                this.logging.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.logging = null;
    }

    public synchronized Level setFlushLevel(Level flushLevel) {
        this.flushLevel = flushLevel;
        return flushLevel;
    }

    public synchronized long setFlushSize(long flushSize) {
        this.flushSize = flushSize;
        return flushSize;
    }

    public static void addHandler(Logger logger, LoggingHandler handler) {
        logger.addHandler(handler);
    }

    public static interface Enhancer {
        public void enhanceMonitoredResource(MonitoredResource.Builder var1);

        public void enhanceLogEntry(LogEntry.Builder var1, LogRecord var2);
    }

    private static class LogConfigHelper {
        private final LogManager manager = LogManager.getLogManager();

        private LogConfigHelper() {
        }

        String getProperty(String name, String defaultValue) {
            return (String)MoreObjects.firstNonNull((Object)this.manager.getProperty(name), (Object)defaultValue);
        }

        long getLongProperty(String name, long defaultValue) {
            try {
                return Long.parseLong(this.manager.getProperty(name));
            }
            catch (NumberFormatException numberFormatException) {
                return defaultValue;
            }
        }

        Level getLevelProperty(String name, Level defaultValue) {
            String stringLevel = this.manager.getProperty(name);
            if (stringLevel == null) {
                return defaultValue;
            }
            try {
                return Level.parse(stringLevel);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return defaultValue;
            }
        }

        Filter getFilterProperty(String name, Filter defaultValue) {
            String stringFilter = this.manager.getProperty(name);
            try {
                if (stringFilter != null) {
                    Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(stringFilter);
                    return (Filter)clz.newInstance();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return defaultValue;
        }

        Formatter getFormatterProperty(String name, Formatter defaultValue) {
            String stringFilter = this.manager.getProperty(name);
            try {
                if (stringFilter != null) {
                    Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(stringFilter);
                    return (Formatter)clz.newInstance();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return defaultValue;
        }

        List<Enhancer> getEnhancerProperty(String name) {
            String list = this.manager.getProperty(name);
            try {
                ArrayList<Enhancer> enhancers = new ArrayList<Enhancer>();
                if (list != null) {
                    String[] items;
                    for (String e_name : items = list.split(",")) {
                        Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(e_name);
                        enhancers.add((Enhancer)clz.newInstance());
                    }
                }
                return enhancers;
            }
            catch (Exception exception) {
                return Collections.emptyList();
            }
        }
    }
}

