/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging.spi.v2;

import com.google.api.gax.grpc.ChannelAndExecutor;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.cloud.logging.spi.v2.MetricsServiceV2Settings;
import com.google.cloud.logging.spi.v2.PagedResponseWrappers;
import com.google.logging.v2.CreateLogMetricRequest;
import com.google.logging.v2.DeleteLogMetricRequest;
import com.google.logging.v2.GetLogMetricRequest;
import com.google.logging.v2.ListLogMetricsRequest;
import com.google.logging.v2.ListLogMetricsResponse;
import com.google.logging.v2.LogMetric;
import com.google.logging.v2.MetricNameOneof;
import com.google.logging.v2.ParentNameOneof;
import com.google.logging.v2.UpdateLogMetricRequest;
import com.google.protobuf.Empty;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;

public class MetricsServiceV2Client
implements AutoCloseable {
    private final MetricsServiceV2Settings settings;
    private final ScheduledExecutorService executor;
    private final ManagedChannel channel;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private final UnaryCallable<ListLogMetricsRequest, ListLogMetricsResponse> listLogMetricsCallable;
    private final UnaryCallable<ListLogMetricsRequest, PagedResponseWrappers.ListLogMetricsPagedResponse> listLogMetricsPagedCallable;
    private final UnaryCallable<GetLogMetricRequest, LogMetric> getLogMetricCallable;
    private final UnaryCallable<CreateLogMetricRequest, LogMetric> createLogMetricCallable;
    private final UnaryCallable<UpdateLogMetricRequest, LogMetric> updateLogMetricCallable;
    private final UnaryCallable<DeleteLogMetricRequest, Empty> deleteLogMetricCallable;

    public static final MetricsServiceV2Client create() throws IOException {
        return MetricsServiceV2Client.create(MetricsServiceV2Settings.defaultBuilder().build());
    }

    public static final MetricsServiceV2Client create(MetricsServiceV2Settings settings) throws IOException {
        return new MetricsServiceV2Client(settings);
    }

    protected MetricsServiceV2Client(MetricsServiceV2Settings settings) throws IOException {
        this.settings = settings;
        ChannelAndExecutor channelAndExecutor = settings.getChannelAndExecutor();
        this.executor = channelAndExecutor.getExecutor();
        this.channel = channelAndExecutor.getChannel();
        this.listLogMetricsCallable = UnaryCallable.create(settings.listLogMetricsSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.listLogMetricsPagedCallable = UnaryCallable.createPagedVariant(settings.listLogMetricsSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.getLogMetricCallable = UnaryCallable.create(settings.getLogMetricSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.createLogMetricCallable = UnaryCallable.create(settings.createLogMetricSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.updateLogMetricCallable = UnaryCallable.create(settings.updateLogMetricSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.deleteLogMetricCallable = UnaryCallable.create(settings.deleteLogMetricSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        if (settings.getChannelProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    MetricsServiceV2Client.this.channel.shutdown();
                }
            });
        }
        if (settings.getExecutorProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    MetricsServiceV2Client.this.executor.shutdown();
                }
            });
        }
    }

    public final MetricsServiceV2Settings getSettings() {
        return this.settings;
    }

    public final PagedResponseWrappers.ListLogMetricsPagedResponse listLogMetrics(ParentNameOneof parent) {
        ListLogMetricsRequest request = ListLogMetricsRequest.newBuilder().setParentWithParentNameOneof(parent).build();
        return this.listLogMetrics(request);
    }

    public final PagedResponseWrappers.ListLogMetricsPagedResponse listLogMetrics(ListLogMetricsRequest request) {
        return (PagedResponseWrappers.ListLogMetricsPagedResponse)((Object)this.listLogMetricsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLogMetricsRequest, PagedResponseWrappers.ListLogMetricsPagedResponse> listLogMetricsPagedCallable() {
        return this.listLogMetricsPagedCallable;
    }

    public final UnaryCallable<ListLogMetricsRequest, ListLogMetricsResponse> listLogMetricsCallable() {
        return this.listLogMetricsCallable;
    }

    public final LogMetric getLogMetric(MetricNameOneof metricName) {
        GetLogMetricRequest request = GetLogMetricRequest.newBuilder().setMetricNameWithMetricNameOneof(metricName).build();
        return this.getLogMetric(request);
    }

    private final LogMetric getLogMetric(GetLogMetricRequest request) {
        return (LogMetric)this.getLogMetricCallable().call((Object)request);
    }

    public final UnaryCallable<GetLogMetricRequest, LogMetric> getLogMetricCallable() {
        return this.getLogMetricCallable;
    }

    public final LogMetric createLogMetric(ParentNameOneof parent, LogMetric metric) {
        CreateLogMetricRequest request = CreateLogMetricRequest.newBuilder().setParentWithParentNameOneof(parent).setMetric(metric).build();
        return this.createLogMetric(request);
    }

    public final LogMetric createLogMetric(CreateLogMetricRequest request) {
        return (LogMetric)this.createLogMetricCallable().call((Object)request);
    }

    public final UnaryCallable<CreateLogMetricRequest, LogMetric> createLogMetricCallable() {
        return this.createLogMetricCallable;
    }

    public final LogMetric updateLogMetric(MetricNameOneof metricName, LogMetric metric) {
        UpdateLogMetricRequest request = UpdateLogMetricRequest.newBuilder().setMetricNameWithMetricNameOneof(metricName).setMetric(metric).build();
        return this.updateLogMetric(request);
    }

    public final LogMetric updateLogMetric(UpdateLogMetricRequest request) {
        return (LogMetric)this.updateLogMetricCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateLogMetricRequest, LogMetric> updateLogMetricCallable() {
        return this.updateLogMetricCallable;
    }

    public final void deleteLogMetric(MetricNameOneof metricName) {
        DeleteLogMetricRequest request = DeleteLogMetricRequest.newBuilder().setMetricNameWithMetricNameOneof(metricName).build();
        this.deleteLogMetric(request);
    }

    private final void deleteLogMetric(DeleteLogMetricRequest request) {
        this.deleteLogMetricCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteLogMetricRequest, Empty> deleteLogMetricCallable() {
        return this.deleteLogMetricCallable;
    }

    @Override
    public final void close() throws Exception {
        for (AutoCloseable closeable : this.closeables) {
            closeable.close();
        }
    }
}

