/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging.testing;

import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.RetryParams;
import com.google.cloud.logging.LoggingOptions;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RemoteLoggingHelper {
    private static final Logger log = Logger.getLogger(RemoteLoggingHelper.class.getName());
    private final LoggingOptions options;

    private RemoteLoggingHelper(LoggingOptions options) {
        this.options = options;
    }

    @Deprecated
    public LoggingOptions options() {
        return this.getOptions();
    }

    public LoggingOptions getOptions() {
        return this.options;
    }

    public static RemoteLoggingHelper create(String projectId, InputStream keyStream) throws LoggingHelperException {
        try {
            LoggingOptions storageOptions = ((LoggingOptions.Builder)((LoggingOptions.Builder)((LoggingOptions.Builder)((LoggingOptions.Builder)((LoggingOptions.Builder)((LoggingOptions.Builder)LoggingOptions.newBuilder().setCredentials((Credentials)ServiceAccountCredentials.fromStream((InputStream)keyStream))).setProjectId(projectId)).setRetryParams(RemoteLoggingHelper.retryParams())).setInitialTimeout(60000)).setMaxTimeout(120000)).setTimeoutMultiplier(1.5)).build();
            return new RemoteLoggingHelper(storageOptions);
        }
        catch (IOException ex) {
            if (log.isLoggable(Level.WARNING)) {
                log.log(Level.WARNING, ex.getMessage());
            }
            throw LoggingHelperException.translate(ex);
        }
    }

    public static RemoteLoggingHelper create() throws LoggingHelperException {
        LoggingOptions loggingOptions = ((LoggingOptions.Builder)((LoggingOptions.Builder)((LoggingOptions.Builder)((LoggingOptions.Builder)LoggingOptions.newBuilder().setRetryParams(RemoteLoggingHelper.retryParams())).setInitialTimeout(60000)).setMaxTimeout(240000)).setTimeoutMultiplier(1.5)).build();
        return new RemoteLoggingHelper(loggingOptions);
    }

    public static String formatForTest(String name) {
        return name + "-" + UUID.randomUUID().toString();
    }

    private static RetryParams retryParams() {
        return RetryParams.newBuilder().setMaxRetryDelayMillis(30000L).setTotalRetryPeriodMillis(120000L).setInitialRetryDelayMillis(250L).build();
    }

    public static class LoggingHelperException
    extends RuntimeException {
        private static final long serialVersionUID = 2617749404172557196L;

        public LoggingHelperException(String message, Throwable cause) {
            super(message, cause);
        }

        public static LoggingHelperException translate(Exception ex) {
            return new LoggingHelperException(ex.getMessage(), ex);
        }
    }
}

