/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging.spi.v2;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.RetrySettings;
import com.google.api.gax.grpc.CallContext;
import com.google.api.gax.grpc.ChannelProvider;
import com.google.api.gax.grpc.ClientSettings;
import com.google.api.gax.grpc.ExecutorProvider;
import com.google.api.gax.grpc.InstantiatingChannelProvider;
import com.google.api.gax.grpc.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.PagedCallSettings;
import com.google.api.gax.grpc.PagedListDescriptor;
import com.google.api.gax.grpc.PagedListResponseFactory;
import com.google.api.gax.grpc.SimpleCallSettings;
import com.google.api.gax.grpc.UnaryCallSettings;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.cloud.logging.spi.v2.PagedResponseWrappers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.logging.v2.CreateLogMetricRequest;
import com.google.logging.v2.DeleteLogMetricRequest;
import com.google.logging.v2.GetLogMetricRequest;
import com.google.logging.v2.ListLogMetricsRequest;
import com.google.logging.v2.ListLogMetricsResponse;
import com.google.logging.v2.LogMetric;
import com.google.logging.v2.MetricsServiceV2Grpc;
import com.google.logging.v2.UpdateLogMetricRequest;
import com.google.protobuf.Empty;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.io.IOException;
import java.util.Set;
import org.joda.time.Duration;

public class MetricsServiceV2Settings
extends ClientSettings {
    private static final String DEFAULT_SERVICE_ADDRESS = "logging.googleapis.com";
    private static final int DEFAULT_SERVICE_PORT = 443;
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/cloud-platform.read-only").add((Object)"https://www.googleapis.com/auth/logging.admin").add((Object)"https://www.googleapis.com/auth/logging.read").add((Object)"https://www.googleapis.com/auth/logging.write").build();
    private static final String DEFAULT_GAPIC_NAME = "gapic";
    private static final String DEFAULT_GAPIC_VERSION = "";
    private final PagedCallSettings<ListLogMetricsRequest, ListLogMetricsResponse, PagedResponseWrappers.ListLogMetricsPagedResponse> listLogMetricsSettings;
    private final SimpleCallSettings<GetLogMetricRequest, LogMetric> getLogMetricSettings;
    private final SimpleCallSettings<CreateLogMetricRequest, LogMetric> createLogMetricSettings;
    private final SimpleCallSettings<UpdateLogMetricRequest, LogMetric> updateLogMetricSettings;
    private final SimpleCallSettings<DeleteLogMetricRequest, Empty> deleteLogMetricSettings;
    private static final PagedListDescriptor<ListLogMetricsRequest, ListLogMetricsResponse, LogMetric> LIST_LOG_METRICS_PAGE_STR_DESC = new PagedListDescriptor<ListLogMetricsRequest, ListLogMetricsResponse, LogMetric>(){

        public Object emptyToken() {
            return MetricsServiceV2Settings.DEFAULT_GAPIC_VERSION;
        }

        public ListLogMetricsRequest injectToken(ListLogMetricsRequest payload, Object token) {
            return ListLogMetricsRequest.newBuilder((ListLogMetricsRequest)payload).setPageToken((String)token).build();
        }

        public ListLogMetricsRequest injectPageSize(ListLogMetricsRequest payload, int pageSize) {
            return ListLogMetricsRequest.newBuilder((ListLogMetricsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLogMetricsRequest payload) {
            return payload.getPageSize();
        }

        public Object extractNextToken(ListLogMetricsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<LogMetric> extractResources(ListLogMetricsResponse payload) {
            return payload.getMetricsList();
        }
    };
    private static final PagedListResponseFactory<ListLogMetricsRequest, ListLogMetricsResponse, PagedResponseWrappers.ListLogMetricsPagedResponse> LIST_LOG_METRICS_PAGE_STR_FACT = new PagedListResponseFactory<ListLogMetricsRequest, ListLogMetricsResponse, PagedResponseWrappers.ListLogMetricsPagedResponse>(){

        public PagedResponseWrappers.ListLogMetricsPagedResponse createPagedListResponse(UnaryCallable<ListLogMetricsRequest, ListLogMetricsResponse> callable, ListLogMetricsRequest request, CallContext context) {
            return new PagedResponseWrappers.ListLogMetricsPagedResponse(callable, (PagedListDescriptor<ListLogMetricsRequest, ListLogMetricsResponse, LogMetric>)LIST_LOG_METRICS_PAGE_STR_DESC, request, context);
        }
    };

    public PagedCallSettings<ListLogMetricsRequest, ListLogMetricsResponse, PagedResponseWrappers.ListLogMetricsPagedResponse> listLogMetricsSettings() {
        return this.listLogMetricsSettings;
    }

    public SimpleCallSettings<GetLogMetricRequest, LogMetric> getLogMetricSettings() {
        return this.getLogMetricSettings;
    }

    public SimpleCallSettings<CreateLogMetricRequest, LogMetric> createLogMetricSettings() {
        return this.createLogMetricSettings;
    }

    public SimpleCallSettings<UpdateLogMetricRequest, LogMetric> updateLogMetricSettings() {
        return this.updateLogMetricSettings;
    }

    public SimpleCallSettings<DeleteLogMetricRequest, Empty> deleteLogMetricSettings() {
        return this.deleteLogMetricSettings;
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultServiceAddress() {
        return DEFAULT_SERVICE_ADDRESS;
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static ImmutableList<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingChannelProvider.Builder defaultChannelProviderBuilder() {
        return InstantiatingChannelProvider.newBuilder().setServiceAddress(DEFAULT_SERVICE_ADDRESS).setPort(443).setGeneratorHeader(DEFAULT_GAPIC_NAME, MetricsServiceV2Settings.getGapicVersion()).setCredentialsProvider((CredentialsProvider)MetricsServiceV2Settings.defaultCredentialsProviderBuilder().build());
    }

    private static String getGapicVersion() {
        String packageVersion = MetricsServiceV2Settings.class.getPackage().getImplementationVersion();
        return packageVersion != null ? packageVersion : DEFAULT_GAPIC_VERSION;
    }

    public static Builder defaultBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private MetricsServiceV2Settings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder.getExecutorProvider(), settingsBuilder.getChannelProvider());
        this.listLogMetricsSettings = settingsBuilder.listLogMetricsSettings().build();
        this.getLogMetricSettings = settingsBuilder.getLogMetricSettings().build();
        this.createLogMetricSettings = settingsBuilder.createLogMetricSettings().build();
        this.updateLogMetricSettings = settingsBuilder.updateLogMetricSettings().build();
        this.deleteLogMetricSettings = settingsBuilder.deleteLogMetricSettings().build();
    }

    public static class Builder
    extends ClientSettings.Builder {
        private final ImmutableList<UnaryCallSettings.Builder> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListLogMetricsRequest, ListLogMetricsResponse, PagedResponseWrappers.ListLogMetricsPagedResponse> listLogMetricsSettings;
        private final SimpleCallSettings.Builder<GetLogMetricRequest, LogMetric> getLogMetricSettings;
        private final SimpleCallSettings.Builder<CreateLogMetricRequest, LogMetric> createLogMetricSettings;
        private final SimpleCallSettings.Builder<UpdateLogMetricRequest, LogMetric> updateLogMetricSettings;
        private final SimpleCallSettings.Builder<DeleteLogMetricRequest, Empty> deleteLogMetricSettings;
        private static final ImmutableMap<String, ImmutableSet<Status.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings.Builder> RETRY_PARAM_DEFINITIONS;

        private Builder() {
            super(MetricsServiceV2Settings.defaultChannelProviderBuilder().build());
            this.listLogMetricsSettings = PagedCallSettings.newBuilder((MethodDescriptor)MetricsServiceV2Grpc.METHOD_LIST_LOG_METRICS, (PagedListResponseFactory)LIST_LOG_METRICS_PAGE_STR_FACT);
            this.getLogMetricSettings = SimpleCallSettings.newBuilder((MethodDescriptor)MetricsServiceV2Grpc.METHOD_GET_LOG_METRIC);
            this.createLogMetricSettings = SimpleCallSettings.newBuilder((MethodDescriptor)MetricsServiceV2Grpc.METHOD_CREATE_LOG_METRIC);
            this.updateLogMetricSettings = SimpleCallSettings.newBuilder((MethodDescriptor)MetricsServiceV2Grpc.METHOD_UPDATE_LOG_METRIC);
            this.deleteLogMetricSettings = SimpleCallSettings.newBuilder((MethodDescriptor)MetricsServiceV2Grpc.METHOD_DELETE_LOG_METRIC);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listLogMetricsSettings, this.getLogMetricSettings, this.createLogMetricSettings, this.updateLogMetricSettings, this.deleteLogMetricSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder();
            builder.listLogMetricsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getLogMetricSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createLogMetricSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateLogMetricSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteLogMetricSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        private Builder(MetricsServiceV2Settings settings) {
            super((ClientSettings)settings);
            this.listLogMetricsSettings = settings.listLogMetricsSettings.toBuilder();
            this.getLogMetricSettings = settings.getLogMetricSettings.toBuilder();
            this.createLogMetricSettings = settings.createLogMetricSettings.toBuilder();
            this.updateLogMetricSettings = settings.updateLogMetricSettings.toBuilder();
            this.deleteLogMetricSettings = settings.deleteLogMetricSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listLogMetricsSettings, this.getLogMetricSettings, this.createLogMetricSettings, this.updateLogMetricSettings, this.deleteLogMetricSettings);
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            super.setExecutorProvider(executorProvider);
            return this;
        }

        public Builder setChannelProvider(ChannelProvider channelProvider) {
            super.setChannelProvider(channelProvider);
            return this;
        }

        public Builder applyToAllUnaryMethods(UnaryCallSettings.Builder unaryCallSettings) throws Exception {
            super.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, unaryCallSettings);
            return this;
        }

        public PagedCallSettings.Builder<ListLogMetricsRequest, ListLogMetricsResponse, PagedResponseWrappers.ListLogMetricsPagedResponse> listLogMetricsSettings() {
            return this.listLogMetricsSettings;
        }

        public SimpleCallSettings.Builder<GetLogMetricRequest, LogMetric> getLogMetricSettings() {
            return this.getLogMetricSettings;
        }

        public SimpleCallSettings.Builder<CreateLogMetricRequest, LogMetric> createLogMetricSettings() {
            return this.createLogMetricSettings;
        }

        public SimpleCallSettings.Builder<UpdateLogMetricRequest, LogMetric> updateLogMetricSettings() {
            return this.updateLogMetricSettings;
        }

        public SimpleCallSettings.Builder<DeleteLogMetricRequest, Empty> deleteLogMetricSettings() {
            return this.deleteLogMetricSettings;
        }

        public MetricsServiceV2Settings build() throws IOException {
            return new MetricsServiceV2Settings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList((Object[])new Status.Code[]{Status.Code.DEADLINE_EXCEEDED, Status.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList((Object[])new Status.Code[]{Status.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings.Builder settingsBuilder = null;
            settingsBuilder = RetrySettings.newBuilder().setInitialRetryDelay(Duration.millis((long)100L)).setRetryDelayMultiplier(1.2).setMaxRetryDelay(Duration.millis((long)1000L)).setInitialRpcTimeout(Duration.millis((long)2000L)).setRpcTimeoutMultiplier(1.5).setMaxRpcTimeout(Duration.millis((long)30000L)).setTotalTimeout(Duration.millis((long)45000L));
            definitions.put((Object)"default", (Object)settingsBuilder);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

