/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging.spi.v2;

import com.google.api.gax.grpc.ChannelAndExecutor;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.cloud.logging.spi.v2.ConfigSettings;
import com.google.cloud.logging.spi.v2.PagedResponseWrappers;
import com.google.logging.v2.CreateSinkRequest;
import com.google.logging.v2.DeleteSinkRequest;
import com.google.logging.v2.GetSinkRequest;
import com.google.logging.v2.ListSinksRequest;
import com.google.logging.v2.ListSinksResponse;
import com.google.logging.v2.LogSink;
import com.google.logging.v2.ParentNameOneof;
import com.google.logging.v2.SinkNameOneof;
import com.google.logging.v2.UpdateSinkRequest;
import com.google.protobuf.Empty;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;

public class ConfigClient
implements AutoCloseable {
    private final ConfigSettings settings;
    private final ScheduledExecutorService executor;
    private final ManagedChannel channel;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private final UnaryCallable<ListSinksRequest, ListSinksResponse> listSinksCallable;
    private final UnaryCallable<ListSinksRequest, PagedResponseWrappers.ListSinksPagedResponse> listSinksPagedCallable;
    private final UnaryCallable<GetSinkRequest, LogSink> getSinkCallable;
    private final UnaryCallable<CreateSinkRequest, LogSink> createSinkCallable;
    private final UnaryCallable<UpdateSinkRequest, LogSink> updateSinkCallable;
    private final UnaryCallable<DeleteSinkRequest, Empty> deleteSinkCallable;

    public static final ConfigClient create() throws IOException {
        return ConfigClient.create(ConfigSettings.defaultBuilder().build());
    }

    public static final ConfigClient create(ConfigSettings settings) throws IOException {
        return new ConfigClient(settings);
    }

    protected ConfigClient(ConfigSettings settings) throws IOException {
        this.settings = settings;
        ChannelAndExecutor channelAndExecutor = settings.getChannelAndExecutor();
        this.executor = channelAndExecutor.getExecutor();
        this.channel = channelAndExecutor.getChannel();
        this.listSinksCallable = UnaryCallable.create(settings.listSinksSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.listSinksPagedCallable = UnaryCallable.createPagedVariant(settings.listSinksSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.getSinkCallable = UnaryCallable.create(settings.getSinkSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.createSinkCallable = UnaryCallable.create(settings.createSinkSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.updateSinkCallable = UnaryCallable.create(settings.updateSinkSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        this.deleteSinkCallable = UnaryCallable.create(settings.deleteSinkSettings(), (Channel)this.channel, (ScheduledExecutorService)this.executor);
        if (settings.getChannelProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    ConfigClient.this.channel.shutdown();
                }
            });
        }
        if (settings.getExecutorProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    ConfigClient.this.executor.shutdown();
                }
            });
        }
    }

    public final ConfigSettings getSettings() {
        return this.settings;
    }

    public final PagedResponseWrappers.ListSinksPagedResponse listSinks(ParentNameOneof parent) {
        ListSinksRequest request = ListSinksRequest.newBuilder().setParentWithParentNameOneof(parent).build();
        return this.listSinks(request);
    }

    public final PagedResponseWrappers.ListSinksPagedResponse listSinks(ListSinksRequest request) {
        return (PagedResponseWrappers.ListSinksPagedResponse)((Object)this.listSinksPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSinksRequest, PagedResponseWrappers.ListSinksPagedResponse> listSinksPagedCallable() {
        return this.listSinksPagedCallable;
    }

    public final UnaryCallable<ListSinksRequest, ListSinksResponse> listSinksCallable() {
        return this.listSinksCallable;
    }

    public final LogSink getSink(SinkNameOneof sinkName) {
        GetSinkRequest request = GetSinkRequest.newBuilder().setSinkNameWithSinkNameOneof(sinkName).build();
        return this.getSink(request);
    }

    private final LogSink getSink(GetSinkRequest request) {
        return (LogSink)this.getSinkCallable().call((Object)request);
    }

    public final UnaryCallable<GetSinkRequest, LogSink> getSinkCallable() {
        return this.getSinkCallable;
    }

    public final LogSink createSink(ParentNameOneof parent, LogSink sink) {
        CreateSinkRequest request = CreateSinkRequest.newBuilder().setParentWithParentNameOneof(parent).setSink(sink).build();
        return this.createSink(request);
    }

    public final LogSink createSink(CreateSinkRequest request) {
        return (LogSink)this.createSinkCallable().call((Object)request);
    }

    public final UnaryCallable<CreateSinkRequest, LogSink> createSinkCallable() {
        return this.createSinkCallable;
    }

    public final LogSink updateSink(SinkNameOneof sinkName, LogSink sink) {
        UpdateSinkRequest request = UpdateSinkRequest.newBuilder().setSinkNameWithSinkNameOneof(sinkName).setSink(sink).build();
        return this.updateSink(request);
    }

    public final LogSink updateSink(UpdateSinkRequest request) {
        return (LogSink)this.updateSinkCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateSinkRequest, LogSink> updateSinkCallable() {
        return this.updateSinkCallable;
    }

    public final void deleteSink(SinkNameOneof sinkName) {
        DeleteSinkRequest request = DeleteSinkRequest.newBuilder().setSinkNameWithSinkNameOneof(sinkName).build();
        this.deleteSink(request);
    }

    private final void deleteSink(DeleteSinkRequest request) {
        this.deleteSinkCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteSinkRequest, Empty> deleteSinkCallable() {
        return this.deleteSinkCallable;
    }

    @Override
    public final void close() throws Exception {
        for (AutoCloseable closeable : this.closeables) {
            closeable.close();
        }
    }
}

