/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging;

import com.google.cloud.MetadataConfig;
import com.google.cloud.MonitoredResource;
import com.google.cloud.ServiceOptions;
import com.google.cloud.logging.LoggingEnhancer;
import com.google.cloud.logging.TraceLoggingEnhancer;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class MonitoredResourceUtil {
    private static Map<String, Label[]> resourceTypeWithLabels = new ImmutableMap.Builder().put((Object)Resource.GaeAppFlex.getKey(), (Object)new Label[]{Label.InstanceName, Label.ModuleId, Label.VersionId, Label.InstanceName, Label.Zone}).put((Object)Resource.GaeAppStandard.getKey(), (Object)new Label[]{Label.AppId, Label.ModuleId, Label.VersionId}).put((Object)Resource.Container.getKey(), (Object)new Label[]{Label.ClusterName, Label.Zone}).put((Object)Resource.GceInstance.getKey(), (Object)new Label[]{Label.InstanceId, Label.Zone}).build();

    private MonitoredResourceUtil() {
    }

    public static MonitoredResource getResource(String projectId, String resourceTypeParam) {
        String resourceType = resourceTypeParam;
        if (Strings.isNullOrEmpty((String)resourceType)) {
            Resource detectedResourceType = MonitoredResourceUtil.getAutoDetectedResourceType();
            resourceType = detectedResourceType.getKey();
        }
        String resourceName = resourceType.startsWith("gae_app") ? "gae_app" : resourceType;
        MonitoredResource.Builder builder = MonitoredResource.newBuilder((String)resourceName).addLabel(Label.ProjectId.getKey(), projectId);
        Label[] resourceLabels = resourceTypeWithLabels.get(resourceType);
        if (resourceLabels != null) {
            for (Label label : resourceLabels) {
                String value = MonitoredResourceUtil.getValue(label);
                if (value == null) continue;
                builder.addLabel(label.getKey(), value);
            }
        }
        return builder.build();
    }

    public static List<LoggingEnhancer> getResourceEnhancers() {
        Resource resourceType = MonitoredResourceUtil.getAutoDetectedResourceType();
        return MonitoredResourceUtil.getEnhancers(resourceType);
    }

    private static String getValue(Label label) {
        String value;
        switch (label) {
            case AppId: {
                value = ServiceOptions.getAppEngineAppId();
                break;
            }
            case ClusterName: {
                value = MetadataConfig.getClusterName();
                break;
            }
            case InstanceId: {
                value = MetadataConfig.getInstanceId();
                break;
            }
            case InstanceName: {
                value = MonitoredResourceUtil.getAppEngineInstanceName();
                break;
            }
            case ModuleId: {
                value = MonitoredResourceUtil.getAppEngineModuleId();
                break;
            }
            case VersionId: {
                value = MonitoredResourceUtil.getAppEngineVersionId();
                break;
            }
            case Zone: {
                value = MetadataConfig.getZone();
                break;
            }
            default: {
                value = null;
            }
        }
        return value;
    }

    private static Resource getAutoDetectedResourceType() {
        if (System.getenv("GAE_INSTANCE") != null) {
            return Resource.GaeAppFlex;
        }
        if (System.getenv("KUBERNETES_SERVICE_HOST") != null) {
            return Resource.Container;
        }
        if (ServiceOptions.getAppEngineAppId() != null) {
            return Resource.GaeAppStandard;
        }
        if (MetadataConfig.getInstanceId() != null) {
            return Resource.GceInstance;
        }
        return Resource.Global;
    }

    private static String getAppEngineModuleId() {
        return System.getenv("GAE_SERVICE");
    }

    private static String getAppEngineVersionId() {
        return System.getenv("GAE_VERSION");
    }

    private static String getAppEngineInstanceName() {
        return System.getenv("GAE_INSTANCE");
    }

    private static List<LoggingEnhancer> getEnhancers(Resource resourceType) {
        List<LoggingEnhancer> enhancers;
        switch (resourceType) {
            case GaeAppStandard: 
            case GaeAppFlex: {
                enhancers = new ArrayList();
                enhancers.add(new TraceLoggingEnhancer());
                break;
            }
            default: {
                enhancers = Collections.emptyList();
            }
        }
        return enhancers;
    }

    private static enum Resource {
        Container("container"),
        GaeAppFlex("gae_app_flex"),
        GaeAppStandard("gae_app_standard"),
        GceInstance("gce_instance"),
        Global("global");

        private final String key;

        private Resource(String key) {
            this.key = key;
        }

        String getKey() {
            return this.key;
        }
    }

    private static enum Label {
        AppId("app_id"),
        ClusterName("cluster_name"),
        InstanceId("instance_id"),
        InstanceName("instance_name"),
        ModuleId("module_id"),
        ProjectId("project_id"),
        VersionId("version_id"),
        Zone("zone");

        private final String key;

        private Label(String key) {
            this.key = key;
        }

        String getKey() {
            return this.key;
        }
    }
}

