/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging.v2;

import com.google.api.MonitoredResource;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.logging.v2.LoggingSettings;
import com.google.cloud.logging.v2.PagedResponseWrappers;
import com.google.cloud.logging.v2.stub.LoggingServiceV2Stub;
import com.google.logging.v2.DeleteLogRequest;
import com.google.logging.v2.ListLogEntriesRequest;
import com.google.logging.v2.ListLogEntriesResponse;
import com.google.logging.v2.ListLogsRequest;
import com.google.logging.v2.ListLogsResponse;
import com.google.logging.v2.ListMonitoredResourceDescriptorsRequest;
import com.google.logging.v2.ListMonitoredResourceDescriptorsResponse;
import com.google.logging.v2.LogEntry;
import com.google.logging.v2.LogNameOneof;
import com.google.logging.v2.ParentNameOneof;
import com.google.logging.v2.WriteLogEntriesRequest;
import com.google.logging.v2.WriteLogEntriesResponse;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi
public class LoggingClient
implements BackgroundResource {
    private final LoggingSettings settings;
    private final LoggingServiceV2Stub stub;

    public static final LoggingClient create() throws IOException {
        return LoggingClient.create(LoggingSettings.newBuilder().build());
    }

    public static final LoggingClient create(LoggingSettings settings) throws IOException {
        return new LoggingClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final LoggingClient create(LoggingServiceV2Stub stub) {
        return new LoggingClient(stub);
    }

    protected LoggingClient(LoggingSettings settings) throws IOException {
        this.settings = settings;
        this.stub = settings.createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected LoggingClient(LoggingServiceV2Stub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final LoggingSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public LoggingServiceV2Stub getStub() {
        return this.stub;
    }

    public final void deleteLog(LogNameOneof logName) {
        DeleteLogRequest request = DeleteLogRequest.newBuilder().setLogNameWithLogNameOneof(logName).build();
        this.deleteLog(request);
    }

    private final void deleteLog(DeleteLogRequest request) {
        this.deleteLogCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteLogRequest, Empty> deleteLogCallable() {
        return this.stub.deleteLogCallable();
    }

    public final WriteLogEntriesResponse writeLogEntries(LogNameOneof logName, MonitoredResource resource, Map<String, String> labels, List<LogEntry> entries) {
        WriteLogEntriesRequest request = WriteLogEntriesRequest.newBuilder().setLogNameWithLogNameOneof(logName).setResource(resource).putAllLabels(labels).addAllEntries(entries).build();
        return this.writeLogEntries(request);
    }

    public final WriteLogEntriesResponse writeLogEntries(WriteLogEntriesRequest request) {
        return (WriteLogEntriesResponse)this.writeLogEntriesCallable().call((Object)request);
    }

    public final UnaryCallable<WriteLogEntriesRequest, WriteLogEntriesResponse> writeLogEntriesCallable() {
        return this.stub.writeLogEntriesCallable();
    }

    public final PagedResponseWrappers.ListLogEntriesPagedResponse listLogEntries(List<String> resourceNames, String filter, String orderBy) {
        ListLogEntriesRequest request = ListLogEntriesRequest.newBuilder().addAllResourceNames(resourceNames).setFilter(filter).setOrderBy(orderBy).build();
        return this.listLogEntries(request);
    }

    public final PagedResponseWrappers.ListLogEntriesPagedResponse listLogEntries(ListLogEntriesRequest request) {
        return (PagedResponseWrappers.ListLogEntriesPagedResponse)((Object)this.listLogEntriesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLogEntriesRequest, PagedResponseWrappers.ListLogEntriesPagedResponse> listLogEntriesPagedCallable() {
        return this.stub.listLogEntriesPagedCallable();
    }

    public final UnaryCallable<ListLogEntriesRequest, ListLogEntriesResponse> listLogEntriesCallable() {
        return this.stub.listLogEntriesCallable();
    }

    public final PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse listMonitoredResourceDescriptors(ListMonitoredResourceDescriptorsRequest request) {
        return (PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse)((Object)this.listMonitoredResourceDescriptorsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListMonitoredResourceDescriptorsRequest, PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse> listMonitoredResourceDescriptorsPagedCallable() {
        return this.stub.listMonitoredResourceDescriptorsPagedCallable();
    }

    public final UnaryCallable<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse> listMonitoredResourceDescriptorsCallable() {
        return this.stub.listMonitoredResourceDescriptorsCallable();
    }

    public final PagedResponseWrappers.ListLogsPagedResponse listLogs(ParentNameOneof parent) {
        ListLogsRequest request = ListLogsRequest.newBuilder().setParentWithParentNameOneof(parent).build();
        return this.listLogs(request);
    }

    public final PagedResponseWrappers.ListLogsPagedResponse listLogs(ListLogsRequest request) {
        return (PagedResponseWrappers.ListLogsPagedResponse)((Object)this.listLogsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLogsRequest, PagedResponseWrappers.ListLogsPagedResponse> listLogsPagedCallable() {
        return this.stub.listLogsPagedCallable();
    }

    public final UnaryCallable<ListLogsRequest, ListLogsResponse> listLogsCallable() {
        return this.stub.listLogsCallable();
    }

    public final void close() throws Exception {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

