/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging.v2;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.core.PropertiesProvider;
import com.google.api.gax.grpc.GrpcExtraHeaderData;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ClientSettings;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.logging.v2.PagedResponseWrappers;
import com.google.cloud.logging.v2.stub.GrpcMetricsServiceV2Stub;
import com.google.cloud.logging.v2.stub.MetricsServiceV2Stub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.logging.v2.CreateLogMetricRequest;
import com.google.logging.v2.DeleteLogMetricRequest;
import com.google.logging.v2.GetLogMetricRequest;
import com.google.logging.v2.ListLogMetricsRequest;
import com.google.logging.v2.ListLogMetricsResponse;
import com.google.logging.v2.LogMetric;
import com.google.logging.v2.UpdateLogMetricRequest;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class MetricsSettings
extends ClientSettings<MetricsSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/cloud-platform.read-only").add((Object)"https://www.googleapis.com/auth/logging.admin").add((Object)"https://www.googleapis.com/auth/logging.read").add((Object)"https://www.googleapis.com/auth/logging.write").build();
    private static final String DEFAULT_GAPIC_NAME = "gapic";
    private static final String DEFAULT_GAPIC_VERSION = "";
    private static final String PROPERTIES_FILE = "/com/google/cloud/logging/project.properties";
    private static final String META_VERSION_KEY = "artifact.version";
    private static String gapicVersion;
    private final PagedCallSettings<ListLogMetricsRequest, ListLogMetricsResponse, PagedResponseWrappers.ListLogMetricsPagedResponse> listLogMetricsSettings;
    private final UnaryCallSettings<GetLogMetricRequest, LogMetric> getLogMetricSettings;
    private final UnaryCallSettings<CreateLogMetricRequest, LogMetric> createLogMetricSettings;
    private final UnaryCallSettings<UpdateLogMetricRequest, LogMetric> updateLogMetricSettings;
    private final UnaryCallSettings<DeleteLogMetricRequest, Empty> deleteLogMetricSettings;
    private static final PagedListDescriptor<ListLogMetricsRequest, ListLogMetricsResponse, LogMetric> LIST_LOG_METRICS_PAGE_STR_DESC;
    private static final PagedListResponseFactory<ListLogMetricsRequest, ListLogMetricsResponse, PagedResponseWrappers.ListLogMetricsPagedResponse> LIST_LOG_METRICS_PAGE_STR_FACT;

    public PagedCallSettings<ListLogMetricsRequest, ListLogMetricsResponse, PagedResponseWrappers.ListLogMetricsPagedResponse> listLogMetricsSettings() {
        return this.listLogMetricsSettings;
    }

    public UnaryCallSettings<GetLogMetricRequest, LogMetric> getLogMetricSettings() {
        return this.getLogMetricSettings;
    }

    public UnaryCallSettings<CreateLogMetricRequest, LogMetric> createLogMetricSettings() {
        return this.createLogMetricSettings;
    }

    public UnaryCallSettings<UpdateLogMetricRequest, LogMetric> updateLogMetricSettings() {
        return this.updateLogMetricSettings;
    }

    public UnaryCallSettings<DeleteLogMetricRequest, Empty> deleteLogMetricSettings() {
        return this.deleteLogMetricSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public MetricsServiceV2Stub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcMetricsServiceV2Stub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "logging.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return MetricsSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratorHeader(DEFAULT_GAPIC_NAME, MetricsSettings.getGapicVersion()).setApiClientHeaderLineKey("x-goog-api-client").addApiClientHeaderLineData(GrpcExtraHeaderData.getXGoogApiClientData());
    }

    private static String getGapicVersion() {
        if (gapicVersion == null) {
            gapicVersion = PropertiesProvider.loadProperty(MetricsSettings.class, (String)PROPERTIES_FILE, (String)META_VERSION_KEY);
            gapicVersion = gapicVersion == null ? DEFAULT_GAPIC_VERSION : gapicVersion;
        }
        return gapicVersion;
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private MetricsSettings(Builder settingsBuilder) throws IOException {
        super((ClientSettings.Builder)settingsBuilder);
        this.listLogMetricsSettings = settingsBuilder.listLogMetricsSettings().build();
        this.getLogMetricSettings = settingsBuilder.getLogMetricSettings().build();
        this.createLogMetricSettings = settingsBuilder.createLogMetricSettings().build();
        this.updateLogMetricSettings = settingsBuilder.updateLogMetricSettings().build();
        this.deleteLogMetricSettings = settingsBuilder.deleteLogMetricSettings().build();
    }

    static {
        LIST_LOG_METRICS_PAGE_STR_DESC = new PagedListDescriptor<ListLogMetricsRequest, ListLogMetricsResponse, LogMetric>(){

            public String emptyToken() {
                return MetricsSettings.DEFAULT_GAPIC_VERSION;
            }

            public ListLogMetricsRequest injectToken(ListLogMetricsRequest payload, String token) {
                return ListLogMetricsRequest.newBuilder((ListLogMetricsRequest)payload).setPageToken(token).build();
            }

            public ListLogMetricsRequest injectPageSize(ListLogMetricsRequest payload, int pageSize) {
                return ListLogMetricsRequest.newBuilder((ListLogMetricsRequest)payload).setPageSize(pageSize).build();
            }

            public Integer extractPageSize(ListLogMetricsRequest payload) {
                return payload.getPageSize();
            }

            public String extractNextToken(ListLogMetricsResponse payload) {
                return payload.getNextPageToken();
            }

            public Iterable<LogMetric> extractResources(ListLogMetricsResponse payload) {
                return payload.getMetricsList();
            }
        };
        LIST_LOG_METRICS_PAGE_STR_FACT = new PagedListResponseFactory<ListLogMetricsRequest, ListLogMetricsResponse, PagedResponseWrappers.ListLogMetricsPagedResponse>(){

            public ApiFuture<PagedResponseWrappers.ListLogMetricsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLogMetricsRequest, ListLogMetricsResponse> callable, ListLogMetricsRequest request, ApiCallContext context, ApiFuture<ListLogMetricsResponse> futureResponse) {
                PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOG_METRICS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
                return PagedResponseWrappers.ListLogMetricsPagedResponse.createAsync((PageContext<ListLogMetricsRequest, ListLogMetricsResponse, LogMetric>)pageContext, futureResponse);
            }
        };
    }

    public static class Builder
    extends ClientSettings.Builder<MetricsSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListLogMetricsRequest, ListLogMetricsResponse, PagedResponseWrappers.ListLogMetricsPagedResponse> listLogMetricsSettings;
        private final UnaryCallSettings.Builder<GetLogMetricRequest, LogMetric> getLogMetricSettings;
        private final UnaryCallSettings.Builder<CreateLogMetricRequest, LogMetric> createLogMetricSettings;
        private final UnaryCallSettings.Builder<UpdateLogMetricRequest, LogMetric> updateLogMetricSettings;
        private final UnaryCallSettings.Builder<DeleteLogMetricRequest, Empty> deleteLogMetricSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        private Builder() {
            this((ClientContext)null);
        }

        private Builder(ClientContext clientContext) {
            super(clientContext);
            this.listLogMetricsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOG_METRICS_PAGE_STR_FACT);
            this.getLogMetricSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createLogMetricSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateLogMetricSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteLogMetricSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listLogMetricsSettings, this.getLogMetricSettings, this.createLogMetricSettings, this.updateLogMetricSettings, this.deleteLogMetricSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(MetricsSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)MetricsSettings.defaultCredentialsProviderBuilder().build());
            builder.setHeaderProvider((HeaderProvider)MetricsSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(MetricsSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listLogMetricsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getLogMetricSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createLogMetricSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateLogMetricSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteLogMetricSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        private Builder(MetricsSettings settings) {
            super((ClientSettings)settings);
            this.listLogMetricsSettings = settings.listLogMetricsSettings.toBuilder();
            this.getLogMetricSettings = settings.getLogMetricSettings.toBuilder();
            this.createLogMetricSettings = settings.createLogMetricSettings.toBuilder();
            this.updateLogMetricSettings = settings.updateLogMetricSettings.toBuilder();
            this.deleteLogMetricSettings = settings.deleteLogMetricSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listLogMetricsSettings, this.getLogMetricSettings, this.createLogMetricSettings, this.updateLogMetricSettings, this.deleteLogMetricSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            ClientSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public PagedCallSettings.Builder<ListLogMetricsRequest, ListLogMetricsResponse, PagedResponseWrappers.ListLogMetricsPagedResponse> listLogMetricsSettings() {
            return this.listLogMetricsSettings;
        }

        public UnaryCallSettings.Builder<GetLogMetricRequest, LogMetric> getLogMetricSettings() {
            return this.getLogMetricSettings;
        }

        public UnaryCallSettings.Builder<CreateLogMetricRequest, LogMetric> createLogMetricSettings() {
            return this.createLogMetricSettings;
        }

        public UnaryCallSettings.Builder<UpdateLogMetricRequest, LogMetric> updateLogMetricSettings() {
            return this.updateLogMetricSettings;
        }

        public UnaryCallSettings.Builder<DeleteLogMetricRequest, Empty> deleteLogMetricSettings() {
            return this.deleteLogMetricSettings;
        }

        public MetricsSettings build() throws IOException {
            return new MetricsSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.INTERNAL, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.2).setMaxRetryDelay(Duration.ofMillis((long)1000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.5).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)90000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

