/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging.v2;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.logging.v2.ConfigSettings;
import com.google.cloud.logging.v2.PagedResponseWrappers;
import com.google.cloud.logging.v2.stub.ConfigServiceV2Stub;
import com.google.logging.v2.CreateExclusionRequest;
import com.google.logging.v2.CreateSinkRequest;
import com.google.logging.v2.DeleteExclusionRequest;
import com.google.logging.v2.DeleteSinkRequest;
import com.google.logging.v2.ExclusionNameOneof;
import com.google.logging.v2.GetExclusionRequest;
import com.google.logging.v2.GetSinkRequest;
import com.google.logging.v2.ListExclusionsRequest;
import com.google.logging.v2.ListExclusionsResponse;
import com.google.logging.v2.ListSinksRequest;
import com.google.logging.v2.ListSinksResponse;
import com.google.logging.v2.LogExclusion;
import com.google.logging.v2.LogSink;
import com.google.logging.v2.ParentNameOneof;
import com.google.logging.v2.SinkNameOneof;
import com.google.logging.v2.UpdateExclusionRequest;
import com.google.logging.v2.UpdateSinkRequest;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ConfigClient
implements BackgroundResource {
    private final ConfigSettings settings;
    private final ConfigServiceV2Stub stub;

    public static final ConfigClient create() throws IOException {
        return ConfigClient.create(ConfigSettings.newBuilder().build());
    }

    public static final ConfigClient create(ConfigSettings settings) throws IOException {
        return new ConfigClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ConfigClient create(ConfigServiceV2Stub stub) {
        return new ConfigClient(stub);
    }

    protected ConfigClient(ConfigSettings settings) throws IOException {
        this.settings = settings;
        this.stub = settings.createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ConfigClient(ConfigServiceV2Stub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ConfigSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ConfigServiceV2Stub getStub() {
        return this.stub;
    }

    public final PagedResponseWrappers.ListSinksPagedResponse listSinks(ParentNameOneof parent) {
        ListSinksRequest request = ListSinksRequest.newBuilder().setParent(parent.toString()).build();
        return this.listSinks(request);
    }

    public final PagedResponseWrappers.ListSinksPagedResponse listSinks(ListSinksRequest request) {
        return (PagedResponseWrappers.ListSinksPagedResponse)((Object)this.listSinksPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSinksRequest, PagedResponseWrappers.ListSinksPagedResponse> listSinksPagedCallable() {
        return this.stub.listSinksPagedCallable();
    }

    public final UnaryCallable<ListSinksRequest, ListSinksResponse> listSinksCallable() {
        return this.stub.listSinksCallable();
    }

    public final LogSink getSink(SinkNameOneof sinkName) {
        GetSinkRequest request = GetSinkRequest.newBuilder().setSinkName(sinkName.toString()).build();
        return this.getSink(request);
    }

    private final LogSink getSink(GetSinkRequest request) {
        return (LogSink)this.getSinkCallable().call((Object)request);
    }

    public final UnaryCallable<GetSinkRequest, LogSink> getSinkCallable() {
        return this.stub.getSinkCallable();
    }

    public final LogSink createSink(ParentNameOneof parent, LogSink sink) {
        CreateSinkRequest request = CreateSinkRequest.newBuilder().setParent(parent.toString()).setSink(sink).build();
        return this.createSink(request);
    }

    public final LogSink createSink(CreateSinkRequest request) {
        return (LogSink)this.createSinkCallable().call((Object)request);
    }

    public final UnaryCallable<CreateSinkRequest, LogSink> createSinkCallable() {
        return this.stub.createSinkCallable();
    }

    public final LogSink updateSink(SinkNameOneof sinkName, LogSink sink) {
        UpdateSinkRequest request = UpdateSinkRequest.newBuilder().setSinkName(sinkName.toString()).setSink(sink).build();
        return this.updateSink(request);
    }

    public final LogSink updateSink(UpdateSinkRequest request) {
        return (LogSink)this.updateSinkCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateSinkRequest, LogSink> updateSinkCallable() {
        return this.stub.updateSinkCallable();
    }

    public final void deleteSink(SinkNameOneof sinkName) {
        DeleteSinkRequest request = DeleteSinkRequest.newBuilder().setSinkName(sinkName.toString()).build();
        this.deleteSink(request);
    }

    private final void deleteSink(DeleteSinkRequest request) {
        this.deleteSinkCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteSinkRequest, Empty> deleteSinkCallable() {
        return this.stub.deleteSinkCallable();
    }

    public final PagedResponseWrappers.ListExclusionsPagedResponse listExclusions(ParentNameOneof parent) {
        ListExclusionsRequest request = ListExclusionsRequest.newBuilder().setParent(parent.toString()).build();
        return this.listExclusions(request);
    }

    public final PagedResponseWrappers.ListExclusionsPagedResponse listExclusions(ListExclusionsRequest request) {
        return (PagedResponseWrappers.ListExclusionsPagedResponse)((Object)this.listExclusionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListExclusionsRequest, PagedResponseWrappers.ListExclusionsPagedResponse> listExclusionsPagedCallable() {
        return this.stub.listExclusionsPagedCallable();
    }

    public final UnaryCallable<ListExclusionsRequest, ListExclusionsResponse> listExclusionsCallable() {
        return this.stub.listExclusionsCallable();
    }

    public final LogExclusion getExclusion(ExclusionNameOneof name) {
        GetExclusionRequest request = GetExclusionRequest.newBuilder().setName(name.toString()).build();
        return this.getExclusion(request);
    }

    private final LogExclusion getExclusion(GetExclusionRequest request) {
        return (LogExclusion)this.getExclusionCallable().call((Object)request);
    }

    public final UnaryCallable<GetExclusionRequest, LogExclusion> getExclusionCallable() {
        return this.stub.getExclusionCallable();
    }

    public final LogExclusion createExclusion(ParentNameOneof parent, LogExclusion exclusion) {
        CreateExclusionRequest request = CreateExclusionRequest.newBuilder().setParent(parent.toString()).setExclusion(exclusion).build();
        return this.createExclusion(request);
    }

    public final LogExclusion createExclusion(CreateExclusionRequest request) {
        return (LogExclusion)this.createExclusionCallable().call((Object)request);
    }

    public final UnaryCallable<CreateExclusionRequest, LogExclusion> createExclusionCallable() {
        return this.stub.createExclusionCallable();
    }

    public final LogExclusion updateExclusion(ExclusionNameOneof name, LogExclusion exclusion, FieldMask updateMask) {
        UpdateExclusionRequest request = UpdateExclusionRequest.newBuilder().setName(name.toString()).setExclusion(exclusion).setUpdateMask(updateMask).build();
        return this.updateExclusion(request);
    }

    public final LogExclusion updateExclusion(UpdateExclusionRequest request) {
        return (LogExclusion)this.updateExclusionCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateExclusionRequest, LogExclusion> updateExclusionCallable() {
        return this.stub.updateExclusionCallable();
    }

    public final void deleteExclusion(ExclusionNameOneof name) {
        DeleteExclusionRequest request = DeleteExclusionRequest.newBuilder().setName(name.toString()).build();
        this.deleteExclusion(request);
    }

    private final void deleteExclusion(DeleteExclusionRequest request) {
        this.deleteExclusionCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteExclusionRequest, Empty> deleteExclusionCallable() {
        return this.stub.deleteExclusionCallable();
    }

    public final void close() throws Exception {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

