/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging.v2;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ClientSettings;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.logging.v2.PagedResponseWrappers;
import com.google.cloud.logging.v2.stub.ConfigServiceV2Stub;
import com.google.cloud.logging.v2.stub.GrpcConfigServiceV2Stub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.logging.v2.CreateExclusionRequest;
import com.google.logging.v2.CreateSinkRequest;
import com.google.logging.v2.DeleteExclusionRequest;
import com.google.logging.v2.DeleteSinkRequest;
import com.google.logging.v2.GetExclusionRequest;
import com.google.logging.v2.GetSinkRequest;
import com.google.logging.v2.ListExclusionsRequest;
import com.google.logging.v2.ListExclusionsResponse;
import com.google.logging.v2.ListSinksRequest;
import com.google.logging.v2.ListSinksResponse;
import com.google.logging.v2.LogExclusion;
import com.google.logging.v2.LogSink;
import com.google.logging.v2.UpdateExclusionRequest;
import com.google.logging.v2.UpdateSinkRequest;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class ConfigSettings
extends ClientSettings<ConfigSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/cloud-platform.read-only").add((Object)"https://www.googleapis.com/auth/logging.admin").add((Object)"https://www.googleapis.com/auth/logging.read").add((Object)"https://www.googleapis.com/auth/logging.write").build();
    private final PagedCallSettings<ListSinksRequest, ListSinksResponse, PagedResponseWrappers.ListSinksPagedResponse> listSinksSettings;
    private final UnaryCallSettings<GetSinkRequest, LogSink> getSinkSettings;
    private final UnaryCallSettings<CreateSinkRequest, LogSink> createSinkSettings;
    private final UnaryCallSettings<UpdateSinkRequest, LogSink> updateSinkSettings;
    private final UnaryCallSettings<DeleteSinkRequest, Empty> deleteSinkSettings;
    private final PagedCallSettings<ListExclusionsRequest, ListExclusionsResponse, PagedResponseWrappers.ListExclusionsPagedResponse> listExclusionsSettings;
    private final UnaryCallSettings<GetExclusionRequest, LogExclusion> getExclusionSettings;
    private final UnaryCallSettings<CreateExclusionRequest, LogExclusion> createExclusionSettings;
    private final UnaryCallSettings<UpdateExclusionRequest, LogExclusion> updateExclusionSettings;
    private final UnaryCallSettings<DeleteExclusionRequest, Empty> deleteExclusionSettings;
    private static final PagedListDescriptor<ListSinksRequest, ListSinksResponse, LogSink> LIST_SINKS_PAGE_STR_DESC = new PagedListDescriptor<ListSinksRequest, ListSinksResponse, LogSink>(){

        public String emptyToken() {
            return "";
        }

        public ListSinksRequest injectToken(ListSinksRequest payload, String token) {
            return ListSinksRequest.newBuilder((ListSinksRequest)payload).setPageToken(token).build();
        }

        public ListSinksRequest injectPageSize(ListSinksRequest payload, int pageSize) {
            return ListSinksRequest.newBuilder((ListSinksRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSinksRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSinksResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<LogSink> extractResources(ListSinksResponse payload) {
            return payload.getSinksList();
        }
    };
    private static final PagedListDescriptor<ListExclusionsRequest, ListExclusionsResponse, LogExclusion> LIST_EXCLUSIONS_PAGE_STR_DESC = new PagedListDescriptor<ListExclusionsRequest, ListExclusionsResponse, LogExclusion>(){

        public String emptyToken() {
            return "";
        }

        public ListExclusionsRequest injectToken(ListExclusionsRequest payload, String token) {
            return ListExclusionsRequest.newBuilder((ListExclusionsRequest)payload).setPageToken(token).build();
        }

        public ListExclusionsRequest injectPageSize(ListExclusionsRequest payload, int pageSize) {
            return ListExclusionsRequest.newBuilder((ListExclusionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListExclusionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListExclusionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<LogExclusion> extractResources(ListExclusionsResponse payload) {
            return payload.getExclusionsList();
        }
    };
    private static final PagedListResponseFactory<ListSinksRequest, ListSinksResponse, PagedResponseWrappers.ListSinksPagedResponse> LIST_SINKS_PAGE_STR_FACT = new PagedListResponseFactory<ListSinksRequest, ListSinksResponse, PagedResponseWrappers.ListSinksPagedResponse>(){

        public ApiFuture<PagedResponseWrappers.ListSinksPagedResponse> getFuturePagedResponse(UnaryCallable<ListSinksRequest, ListSinksResponse> callable, ListSinksRequest request, ApiCallContext context, ApiFuture<ListSinksResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SINKS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return PagedResponseWrappers.ListSinksPagedResponse.createAsync((PageContext<ListSinksRequest, ListSinksResponse, LogSink>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListExclusionsRequest, ListExclusionsResponse, PagedResponseWrappers.ListExclusionsPagedResponse> LIST_EXCLUSIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListExclusionsRequest, ListExclusionsResponse, PagedResponseWrappers.ListExclusionsPagedResponse>(){

        public ApiFuture<PagedResponseWrappers.ListExclusionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListExclusionsRequest, ListExclusionsResponse> callable, ListExclusionsRequest request, ApiCallContext context, ApiFuture<ListExclusionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_EXCLUSIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return PagedResponseWrappers.ListExclusionsPagedResponse.createAsync((PageContext<ListExclusionsRequest, ListExclusionsResponse, LogExclusion>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListSinksRequest, ListSinksResponse, PagedResponseWrappers.ListSinksPagedResponse> listSinksSettings() {
        return this.listSinksSettings;
    }

    public UnaryCallSettings<GetSinkRequest, LogSink> getSinkSettings() {
        return this.getSinkSettings;
    }

    public UnaryCallSettings<CreateSinkRequest, LogSink> createSinkSettings() {
        return this.createSinkSettings;
    }

    public UnaryCallSettings<UpdateSinkRequest, LogSink> updateSinkSettings() {
        return this.updateSinkSettings;
    }

    public UnaryCallSettings<DeleteSinkRequest, Empty> deleteSinkSettings() {
        return this.deleteSinkSettings;
    }

    public PagedCallSettings<ListExclusionsRequest, ListExclusionsResponse, PagedResponseWrappers.ListExclusionsPagedResponse> listExclusionsSettings() {
        return this.listExclusionsSettings;
    }

    public UnaryCallSettings<GetExclusionRequest, LogExclusion> getExclusionSettings() {
        return this.getExclusionSettings;
    }

    public UnaryCallSettings<CreateExclusionRequest, LogExclusion> createExclusionSettings() {
        return this.createExclusionSettings;
    }

    public UnaryCallSettings<UpdateExclusionRequest, LogExclusion> updateExclusionSettings() {
        return this.updateExclusionSettings;
    }

    public UnaryCallSettings<DeleteExclusionRequest, Empty> deleteExclusionSettings() {
        return this.deleteExclusionSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ConfigServiceV2Stub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcConfigServiceV2Stub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "logging.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ConfigSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ConfigSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ConfigSettings(Builder settingsBuilder) throws IOException {
        super((ClientSettings.Builder)settingsBuilder);
        this.listSinksSettings = settingsBuilder.listSinksSettings().build();
        this.getSinkSettings = settingsBuilder.getSinkSettings().build();
        this.createSinkSettings = settingsBuilder.createSinkSettings().build();
        this.updateSinkSettings = settingsBuilder.updateSinkSettings().build();
        this.deleteSinkSettings = settingsBuilder.deleteSinkSettings().build();
        this.listExclusionsSettings = settingsBuilder.listExclusionsSettings().build();
        this.getExclusionSettings = settingsBuilder.getExclusionSettings().build();
        this.createExclusionSettings = settingsBuilder.createExclusionSettings().build();
        this.updateExclusionSettings = settingsBuilder.updateExclusionSettings().build();
        this.deleteExclusionSettings = settingsBuilder.deleteExclusionSettings().build();
    }

    public static class Builder
    extends ClientSettings.Builder<ConfigSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListSinksRequest, ListSinksResponse, PagedResponseWrappers.ListSinksPagedResponse> listSinksSettings;
        private final UnaryCallSettings.Builder<GetSinkRequest, LogSink> getSinkSettings;
        private final UnaryCallSettings.Builder<CreateSinkRequest, LogSink> createSinkSettings;
        private final UnaryCallSettings.Builder<UpdateSinkRequest, LogSink> updateSinkSettings;
        private final UnaryCallSettings.Builder<DeleteSinkRequest, Empty> deleteSinkSettings;
        private final PagedCallSettings.Builder<ListExclusionsRequest, ListExclusionsResponse, PagedResponseWrappers.ListExclusionsPagedResponse> listExclusionsSettings;
        private final UnaryCallSettings.Builder<GetExclusionRequest, LogExclusion> getExclusionSettings;
        private final UnaryCallSettings.Builder<CreateExclusionRequest, LogExclusion> createExclusionSettings;
        private final UnaryCallSettings.Builder<UpdateExclusionRequest, LogExclusion> updateExclusionSettings;
        private final UnaryCallSettings.Builder<DeleteExclusionRequest, Empty> deleteExclusionSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listSinksSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SINKS_PAGE_STR_FACT);
            this.getSinkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createSinkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSinkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSinkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listExclusionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_EXCLUSIONS_PAGE_STR_FACT);
            this.getExclusionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createExclusionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateExclusionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteExclusionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listSinksSettings, this.getSinkSettings, this.createSinkSettings, this.updateSinkSettings, this.deleteSinkSettings, this.listExclusionsSettings, this.getExclusionSettings, this.createExclusionSettings, this.updateExclusionSettings, this.deleteExclusionSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ConfigSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ConfigSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ConfigSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ConfigSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listSinksSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getSinkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createSinkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateSinkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteSinkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listExclusionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getExclusionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createExclusionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateExclusionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteExclusionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(ConfigSettings settings) {
            super((ClientSettings)settings);
            this.listSinksSettings = settings.listSinksSettings.toBuilder();
            this.getSinkSettings = settings.getSinkSettings.toBuilder();
            this.createSinkSettings = settings.createSinkSettings.toBuilder();
            this.updateSinkSettings = settings.updateSinkSettings.toBuilder();
            this.deleteSinkSettings = settings.deleteSinkSettings.toBuilder();
            this.listExclusionsSettings = settings.listExclusionsSettings.toBuilder();
            this.getExclusionSettings = settings.getExclusionSettings.toBuilder();
            this.createExclusionSettings = settings.createExclusionSettings.toBuilder();
            this.updateExclusionSettings = settings.updateExclusionSettings.toBuilder();
            this.deleteExclusionSettings = settings.deleteExclusionSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listSinksSettings, this.getSinkSettings, this.createSinkSettings, this.updateSinkSettings, this.deleteSinkSettings, this.listExclusionsSettings, this.getExclusionSettings, this.createExclusionSettings, this.updateExclusionSettings, this.deleteExclusionSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            ClientSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public PagedCallSettings.Builder<ListSinksRequest, ListSinksResponse, PagedResponseWrappers.ListSinksPagedResponse> listSinksSettings() {
            return this.listSinksSettings;
        }

        public UnaryCallSettings.Builder<GetSinkRequest, LogSink> getSinkSettings() {
            return this.getSinkSettings;
        }

        public UnaryCallSettings.Builder<CreateSinkRequest, LogSink> createSinkSettings() {
            return this.createSinkSettings;
        }

        public UnaryCallSettings.Builder<UpdateSinkRequest, LogSink> updateSinkSettings() {
            return this.updateSinkSettings;
        }

        public UnaryCallSettings.Builder<DeleteSinkRequest, Empty> deleteSinkSettings() {
            return this.deleteSinkSettings;
        }

        public PagedCallSettings.Builder<ListExclusionsRequest, ListExclusionsResponse, PagedResponseWrappers.ListExclusionsPagedResponse> listExclusionsSettings() {
            return this.listExclusionsSettings;
        }

        public UnaryCallSettings.Builder<GetExclusionRequest, LogExclusion> getExclusionSettings() {
            return this.getExclusionSettings;
        }

        public UnaryCallSettings.Builder<CreateExclusionRequest, LogExclusion> createExclusionSettings() {
            return this.createExclusionSettings;
        }

        public UnaryCallSettings.Builder<UpdateExclusionRequest, LogExclusion> updateExclusionSettings() {
            return this.updateExclusionSettings;
        }

        public UnaryCallSettings.Builder<DeleteExclusionRequest, Empty> deleteExclusionSettings() {
            return this.deleteExclusionSettings;
        }

        public ConfigSettings build() throws IOException {
            return new ConfigSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.INTERNAL, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.2).setMaxRetryDelay(Duration.ofMillis((long)1000L)).setInitialRpcTimeout(Duration.ofMillis((long)30000L)).setRpcTimeoutMultiplier(1.5).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)90000L)).build();
            definitions.put((Object)"default", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.2).setMaxRetryDelay(Duration.ofMillis((long)1000L)).setInitialRpcTimeout(Duration.ofMillis((long)30000L)).setRpcTimeoutMultiplier(1.5).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)120000L)).build();
            definitions.put((Object)"write_sink", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

