/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging.v2;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.logging.v2.ConfigSettings;
import com.google.cloud.logging.v2.PagedResponseWrappers;
import com.google.cloud.logging.v2.stub.ConfigServiceV2Stub;
import com.google.logging.v2.CreateSinkRequest;
import com.google.logging.v2.DeleteSinkRequest;
import com.google.logging.v2.GetSinkRequest;
import com.google.logging.v2.ListSinksRequest;
import com.google.logging.v2.ListSinksResponse;
import com.google.logging.v2.LogSink;
import com.google.logging.v2.ParentNameOneof;
import com.google.logging.v2.SinkNameOneof;
import com.google.logging.v2.UpdateSinkRequest;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ConfigClient
implements BackgroundResource {
    private final ConfigSettings settings;
    private final ConfigServiceV2Stub stub;

    public static final ConfigClient create() throws IOException {
        return ConfigClient.create(ConfigSettings.defaultBuilder().build());
    }

    public static final ConfigClient create(ConfigSettings settings) throws IOException {
        return new ConfigClient(settings);
    }

    public static final ConfigClient create(ConfigServiceV2Stub stub) {
        return new ConfigClient(stub);
    }

    protected ConfigClient(ConfigSettings settings) throws IOException {
        this.settings = settings;
        this.stub = settings.createStub();
    }

    protected ConfigClient(ConfigServiceV2Stub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ConfigSettings getSettings() {
        return this.settings;
    }

    public ConfigServiceV2Stub getStub() {
        return this.stub;
    }

    public final PagedResponseWrappers.ListSinksPagedResponse listSinks(ParentNameOneof parent) {
        ListSinksRequest request = ListSinksRequest.newBuilder().setParentWithParentNameOneof(parent).build();
        return this.listSinks(request);
    }

    public final PagedResponseWrappers.ListSinksPagedResponse listSinks(ListSinksRequest request) {
        return (PagedResponseWrappers.ListSinksPagedResponse)((Object)this.listSinksPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSinksRequest, PagedResponseWrappers.ListSinksPagedResponse> listSinksPagedCallable() {
        return this.stub.listSinksPagedCallable();
    }

    public final UnaryCallable<ListSinksRequest, ListSinksResponse> listSinksCallable() {
        return this.stub.listSinksCallable();
    }

    public final LogSink getSink(SinkNameOneof sinkName) {
        GetSinkRequest request = GetSinkRequest.newBuilder().setSinkNameWithSinkNameOneof(sinkName).build();
        return this.getSink(request);
    }

    private final LogSink getSink(GetSinkRequest request) {
        return (LogSink)this.getSinkCallable().call((Object)request);
    }

    public final UnaryCallable<GetSinkRequest, LogSink> getSinkCallable() {
        return this.stub.getSinkCallable();
    }

    public final LogSink createSink(ParentNameOneof parent, LogSink sink) {
        CreateSinkRequest request = CreateSinkRequest.newBuilder().setParentWithParentNameOneof(parent).setSink(sink).build();
        return this.createSink(request);
    }

    public final LogSink createSink(CreateSinkRequest request) {
        return (LogSink)this.createSinkCallable().call((Object)request);
    }

    public final UnaryCallable<CreateSinkRequest, LogSink> createSinkCallable() {
        return this.stub.createSinkCallable();
    }

    public final LogSink updateSink(SinkNameOneof sinkName, LogSink sink) {
        UpdateSinkRequest request = UpdateSinkRequest.newBuilder().setSinkNameWithSinkNameOneof(sinkName).setSink(sink).build();
        return this.updateSink(request);
    }

    public final LogSink updateSink(UpdateSinkRequest request) {
        return (LogSink)this.updateSinkCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateSinkRequest, LogSink> updateSinkCallable() {
        return this.stub.updateSinkCallable();
    }

    public final void deleteSink(SinkNameOneof sinkName) {
        DeleteSinkRequest request = DeleteSinkRequest.newBuilder().setSinkNameWithSinkNameOneof(sinkName).build();
        this.deleteSink(request);
    }

    private final void deleteSink(DeleteSinkRequest request) {
        this.deleteSinkCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteSinkRequest, Empty> deleteSinkCallable() {
        return this.stub.deleteSinkCallable();
    }

    public final void close() throws Exception {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

