/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging.v2.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ClientSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.logging.v2.ConfigSettings;
import com.google.cloud.logging.v2.PagedResponseWrappers;
import com.google.cloud.logging.v2.stub.ConfigServiceV2Stub;
import com.google.logging.v2.CreateSinkRequest;
import com.google.logging.v2.DeleteSinkRequest;
import com.google.logging.v2.GetSinkRequest;
import com.google.logging.v2.ListSinksRequest;
import com.google.logging.v2.ListSinksResponse;
import com.google.logging.v2.LogSink;
import com.google.logging.v2.UpdateSinkRequest;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcConfigServiceV2Stub
extends ConfigServiceV2Stub {
    private static final UnaryCallable<ListSinksRequest, ListSinksResponse> directListSinksCallable = GrpcCallableFactory.createDirectCallable((MethodDescriptor)MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.logging.v2.ConfigServiceV2/ListSinks", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)ListSinksRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)ListSinksResponse.getDefaultInstance())));
    private static final UnaryCallable<GetSinkRequest, LogSink> directGetSinkCallable = GrpcCallableFactory.createDirectCallable((MethodDescriptor)MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.logging.v2.ConfigServiceV2/GetSink", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)GetSinkRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)LogSink.getDefaultInstance())));
    private static final UnaryCallable<CreateSinkRequest, LogSink> directCreateSinkCallable = GrpcCallableFactory.createDirectCallable((MethodDescriptor)MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.logging.v2.ConfigServiceV2/CreateSink", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)CreateSinkRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)LogSink.getDefaultInstance())));
    private static final UnaryCallable<UpdateSinkRequest, LogSink> directUpdateSinkCallable = GrpcCallableFactory.createDirectCallable((MethodDescriptor)MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.logging.v2.ConfigServiceV2/UpdateSink", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)UpdateSinkRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)LogSink.getDefaultInstance())));
    private static final UnaryCallable<DeleteSinkRequest, Empty> directDeleteSinkCallable = GrpcCallableFactory.createDirectCallable((MethodDescriptor)MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.logging.v2.ConfigServiceV2/DeleteSink", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)DeleteSinkRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Empty.getDefaultInstance())));
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<ListSinksRequest, ListSinksResponse> listSinksCallable;
    private final UnaryCallable<ListSinksRequest, PagedResponseWrappers.ListSinksPagedResponse> listSinksPagedCallable;
    private final UnaryCallable<GetSinkRequest, LogSink> getSinkCallable;
    private final UnaryCallable<CreateSinkRequest, LogSink> createSinkCallable;
    private final UnaryCallable<UpdateSinkRequest, LogSink> updateSinkCallable;
    private final UnaryCallable<DeleteSinkRequest, Empty> deleteSinkCallable;

    public static final GrpcConfigServiceV2Stub create(ConfigSettings settings) throws IOException {
        return new GrpcConfigServiceV2Stub(settings, ClientContext.create((ClientSettings)settings));
    }

    public static final GrpcConfigServiceV2Stub create(ClientContext clientContext) throws IOException {
        return new GrpcConfigServiceV2Stub(ConfigSettings.defaultBuilder().build(), clientContext);
    }

    protected GrpcConfigServiceV2Stub(ConfigSettings settings, ClientContext clientContext) throws IOException {
        this.listSinksCallable = GrpcCallableFactory.create(directListSinksCallable, settings.listSinksSettings(), (ClientContext)clientContext);
        this.listSinksPagedCallable = GrpcCallableFactory.createPagedVariant(directListSinksCallable, settings.listSinksSettings(), (ClientContext)clientContext);
        this.getSinkCallable = GrpcCallableFactory.create(directGetSinkCallable, settings.getSinkSettings(), (ClientContext)clientContext);
        this.createSinkCallable = GrpcCallableFactory.create(directCreateSinkCallable, settings.createSinkSettings(), (ClientContext)clientContext);
        this.updateSinkCallable = GrpcCallableFactory.create(directUpdateSinkCallable, settings.updateSinkSettings(), (ClientContext)clientContext);
        this.deleteSinkCallable = GrpcCallableFactory.create(directDeleteSinkCallable, settings.deleteSinkSettings(), (ClientContext)clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    public UnaryCallable<ListSinksRequest, PagedResponseWrappers.ListSinksPagedResponse> listSinksPagedCallable() {
        return this.listSinksPagedCallable;
    }

    @Override
    public UnaryCallable<ListSinksRequest, ListSinksResponse> listSinksCallable() {
        return this.listSinksCallable;
    }

    @Override
    public UnaryCallable<GetSinkRequest, LogSink> getSinkCallable() {
        return this.getSinkCallable;
    }

    @Override
    public UnaryCallable<CreateSinkRequest, LogSink> createSinkCallable() {
        return this.createSinkCallable;
    }

    @Override
    public UnaryCallable<UpdateSinkRequest, LogSink> updateSinkCallable() {
        return this.updateSinkCallable;
    }

    @Override
    public UnaryCallable<DeleteSinkRequest, Empty> deleteSinkCallable() {
        return this.deleteSinkCallable;
    }

    public final void close() throws Exception {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

