/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging.v2.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ClientSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.logging.v2.LoggingSettings;
import com.google.cloud.logging.v2.PagedResponseWrappers;
import com.google.cloud.logging.v2.stub.LoggingServiceV2Stub;
import com.google.logging.v2.DeleteLogRequest;
import com.google.logging.v2.ListLogEntriesRequest;
import com.google.logging.v2.ListLogEntriesResponse;
import com.google.logging.v2.ListLogsRequest;
import com.google.logging.v2.ListLogsResponse;
import com.google.logging.v2.ListMonitoredResourceDescriptorsRequest;
import com.google.logging.v2.ListMonitoredResourceDescriptorsResponse;
import com.google.logging.v2.WriteLogEntriesRequest;
import com.google.logging.v2.WriteLogEntriesResponse;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcLoggingServiceV2Stub
extends LoggingServiceV2Stub {
    private static final UnaryCallable<DeleteLogRequest, Empty> directDeleteLogCallable = GrpcCallableFactory.createDirectCallable((MethodDescriptor)MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.logging.v2.LoggingServiceV2/DeleteLog", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)DeleteLogRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Empty.getDefaultInstance())));
    private static final UnaryCallable<WriteLogEntriesRequest, WriteLogEntriesResponse> directWriteLogEntriesCallable = GrpcCallableFactory.createDirectCallable((MethodDescriptor)MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.logging.v2.LoggingServiceV2/WriteLogEntries", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)WriteLogEntriesRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)WriteLogEntriesResponse.getDefaultInstance())));
    private static final UnaryCallable<ListLogEntriesRequest, ListLogEntriesResponse> directListLogEntriesCallable = GrpcCallableFactory.createDirectCallable((MethodDescriptor)MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.logging.v2.LoggingServiceV2/ListLogEntries", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)ListLogEntriesRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)ListLogEntriesResponse.getDefaultInstance())));
    private static final UnaryCallable<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse> directListMonitoredResourceDescriptorsCallable = GrpcCallableFactory.createDirectCallable((MethodDescriptor)MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.logging.v2.LoggingServiceV2/ListMonitoredResourceDescriptors", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)ListMonitoredResourceDescriptorsRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)ListMonitoredResourceDescriptorsResponse.getDefaultInstance())));
    private static final UnaryCallable<ListLogsRequest, ListLogsResponse> directListLogsCallable = GrpcCallableFactory.createDirectCallable((MethodDescriptor)MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.logging.v2.LoggingServiceV2/ListLogs", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)ListLogsRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)ListLogsResponse.getDefaultInstance())));
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<DeleteLogRequest, Empty> deleteLogCallable;
    private final UnaryCallable<WriteLogEntriesRequest, WriteLogEntriesResponse> writeLogEntriesCallable;
    private final UnaryCallable<ListLogEntriesRequest, ListLogEntriesResponse> listLogEntriesCallable;
    private final UnaryCallable<ListLogEntriesRequest, PagedResponseWrappers.ListLogEntriesPagedResponse> listLogEntriesPagedCallable;
    private final UnaryCallable<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse> listMonitoredResourceDescriptorsCallable;
    private final UnaryCallable<ListMonitoredResourceDescriptorsRequest, PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse> listMonitoredResourceDescriptorsPagedCallable;
    private final UnaryCallable<ListLogsRequest, ListLogsResponse> listLogsCallable;
    private final UnaryCallable<ListLogsRequest, PagedResponseWrappers.ListLogsPagedResponse> listLogsPagedCallable;

    public static final GrpcLoggingServiceV2Stub create(LoggingSettings settings) throws IOException {
        return new GrpcLoggingServiceV2Stub(settings, ClientContext.create((ClientSettings)settings));
    }

    public static final GrpcLoggingServiceV2Stub create(ClientContext clientContext) throws IOException {
        return new GrpcLoggingServiceV2Stub(LoggingSettings.defaultBuilder().build(), clientContext);
    }

    protected GrpcLoggingServiceV2Stub(LoggingSettings settings, ClientContext clientContext) throws IOException {
        this.deleteLogCallable = GrpcCallableFactory.create(directDeleteLogCallable, settings.deleteLogSettings(), (ClientContext)clientContext);
        this.writeLogEntriesCallable = GrpcCallableFactory.create(directWriteLogEntriesCallable, settings.writeLogEntriesSettings(), (ClientContext)clientContext);
        this.listLogEntriesCallable = GrpcCallableFactory.create(directListLogEntriesCallable, settings.listLogEntriesSettings(), (ClientContext)clientContext);
        this.listLogEntriesPagedCallable = GrpcCallableFactory.createPagedVariant(directListLogEntriesCallable, settings.listLogEntriesSettings(), (ClientContext)clientContext);
        this.listMonitoredResourceDescriptorsCallable = GrpcCallableFactory.create(directListMonitoredResourceDescriptorsCallable, settings.listMonitoredResourceDescriptorsSettings(), (ClientContext)clientContext);
        this.listMonitoredResourceDescriptorsPagedCallable = GrpcCallableFactory.createPagedVariant(directListMonitoredResourceDescriptorsCallable, settings.listMonitoredResourceDescriptorsSettings(), (ClientContext)clientContext);
        this.listLogsCallable = GrpcCallableFactory.create(directListLogsCallable, settings.listLogsSettings(), (ClientContext)clientContext);
        this.listLogsPagedCallable = GrpcCallableFactory.createPagedVariant(directListLogsCallable, settings.listLogsSettings(), (ClientContext)clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    public UnaryCallable<DeleteLogRequest, Empty> deleteLogCallable() {
        return this.deleteLogCallable;
    }

    @Override
    public UnaryCallable<WriteLogEntriesRequest, WriteLogEntriesResponse> writeLogEntriesCallable() {
        return this.writeLogEntriesCallable;
    }

    @Override
    public UnaryCallable<ListLogEntriesRequest, PagedResponseWrappers.ListLogEntriesPagedResponse> listLogEntriesPagedCallable() {
        return this.listLogEntriesPagedCallable;
    }

    @Override
    public UnaryCallable<ListLogEntriesRequest, ListLogEntriesResponse> listLogEntriesCallable() {
        return this.listLogEntriesCallable;
    }

    @Override
    public UnaryCallable<ListMonitoredResourceDescriptorsRequest, PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse> listMonitoredResourceDescriptorsPagedCallable() {
        return this.listMonitoredResourceDescriptorsPagedCallable;
    }

    @Override
    public UnaryCallable<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse> listMonitoredResourceDescriptorsCallable() {
        return this.listMonitoredResourceDescriptorsCallable;
    }

    @Override
    public UnaryCallable<ListLogsRequest, PagedResponseWrappers.ListLogsPagedResponse> listLogsPagedCallable() {
        return this.listLogsPagedCallable;
    }

    @Override
    public UnaryCallable<ListLogsRequest, ListLogsResponse> listLogsCallable() {
        return this.listLogsCallable;
    }

    public final void close() throws Exception {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

