/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging.v2;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.logging.v2.MetricsSettings;
import com.google.cloud.logging.v2.PagedResponseWrappers;
import com.google.cloud.logging.v2.stub.MetricsServiceV2Stub;
import com.google.logging.v2.CreateLogMetricRequest;
import com.google.logging.v2.DeleteLogMetricRequest;
import com.google.logging.v2.GetLogMetricRequest;
import com.google.logging.v2.ListLogMetricsRequest;
import com.google.logging.v2.ListLogMetricsResponse;
import com.google.logging.v2.LogMetric;
import com.google.logging.v2.MetricNameOneof;
import com.google.logging.v2.ParentNameOneof;
import com.google.logging.v2.UpdateLogMetricRequest;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class MetricsClient
implements BackgroundResource {
    private final MetricsSettings settings;
    private final MetricsServiceV2Stub stub;

    public static final MetricsClient create() throws IOException {
        return MetricsClient.create(MetricsSettings.defaultBuilder().build());
    }

    public static final MetricsClient create(MetricsSettings settings) throws IOException {
        return new MetricsClient(settings);
    }

    public static final MetricsClient create(MetricsServiceV2Stub stub) {
        return new MetricsClient(stub);
    }

    protected MetricsClient(MetricsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = settings.createStub();
    }

    protected MetricsClient(MetricsServiceV2Stub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final MetricsSettings getSettings() {
        return this.settings;
    }

    public MetricsServiceV2Stub getStub() {
        return this.stub;
    }

    public final PagedResponseWrappers.ListLogMetricsPagedResponse listLogMetrics(ParentNameOneof parent) {
        ListLogMetricsRequest request = ListLogMetricsRequest.newBuilder().setParentWithParentNameOneof(parent).build();
        return this.listLogMetrics(request);
    }

    public final PagedResponseWrappers.ListLogMetricsPagedResponse listLogMetrics(ListLogMetricsRequest request) {
        return (PagedResponseWrappers.ListLogMetricsPagedResponse)((Object)this.listLogMetricsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLogMetricsRequest, PagedResponseWrappers.ListLogMetricsPagedResponse> listLogMetricsPagedCallable() {
        return this.stub.listLogMetricsPagedCallable();
    }

    public final UnaryCallable<ListLogMetricsRequest, ListLogMetricsResponse> listLogMetricsCallable() {
        return this.stub.listLogMetricsCallable();
    }

    public final LogMetric getLogMetric(MetricNameOneof metricName) {
        GetLogMetricRequest request = GetLogMetricRequest.newBuilder().setMetricNameWithMetricNameOneof(metricName).build();
        return this.getLogMetric(request);
    }

    private final LogMetric getLogMetric(GetLogMetricRequest request) {
        return (LogMetric)this.getLogMetricCallable().call((Object)request);
    }

    public final UnaryCallable<GetLogMetricRequest, LogMetric> getLogMetricCallable() {
        return this.stub.getLogMetricCallable();
    }

    public final LogMetric createLogMetric(ParentNameOneof parent, LogMetric metric) {
        CreateLogMetricRequest request = CreateLogMetricRequest.newBuilder().setParentWithParentNameOneof(parent).setMetric(metric).build();
        return this.createLogMetric(request);
    }

    public final LogMetric createLogMetric(CreateLogMetricRequest request) {
        return (LogMetric)this.createLogMetricCallable().call((Object)request);
    }

    public final UnaryCallable<CreateLogMetricRequest, LogMetric> createLogMetricCallable() {
        return this.stub.createLogMetricCallable();
    }

    public final LogMetric updateLogMetric(MetricNameOneof metricName, LogMetric metric) {
        UpdateLogMetricRequest request = UpdateLogMetricRequest.newBuilder().setMetricNameWithMetricNameOneof(metricName).setMetric(metric).build();
        return this.updateLogMetric(request);
    }

    public final LogMetric updateLogMetric(UpdateLogMetricRequest request) {
        return (LogMetric)this.updateLogMetricCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateLogMetricRequest, LogMetric> updateLogMetricCallable() {
        return this.stub.updateLogMetricCallable();
    }

    public final void deleteLogMetric(MetricNameOneof metricName) {
        DeleteLogMetricRequest request = DeleteLogMetricRequest.newBuilder().setMetricNameWithMetricNameOneof(metricName).build();
        this.deleteLogMetric(request);
    }

    private final void deleteLogMetric(DeleteLogMetricRequest request) {
        this.deleteLogMetricCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteLogMetricRequest, Empty> deleteLogMetricCallable() {
        return this.stub.deleteLogMetricCallable();
    }

    public final void close() throws Exception {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

