/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging.v2;

import com.google.api.MonitoredResourceDescriptor;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.batching.FlowController;
import com.google.api.gax.batching.PartitionKey;
import com.google.api.gax.batching.RequestBuilder;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.core.PropertiesProvider;
import com.google.api.gax.grpc.ChannelProvider;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.grpc.GrpcTransport;
import com.google.api.gax.grpc.GrpcTransportProvider;
import com.google.api.gax.grpc.InstantiatingChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.BatchedRequestIssuer;
import com.google.api.gax.rpc.BatchingCallSettings;
import com.google.api.gax.rpc.BatchingDescriptor;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ClientSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.SimpleCallSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.logging.v2.PagedResponseWrappers;
import com.google.cloud.logging.v2.stub.GrpcLoggingServiceV2Stub;
import com.google.cloud.logging.v2.stub.LoggingServiceV2Stub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.logging.v2.DeleteLogRequest;
import com.google.logging.v2.ListLogEntriesRequest;
import com.google.logging.v2.ListLogEntriesResponse;
import com.google.logging.v2.ListLogsRequest;
import com.google.logging.v2.ListLogsResponse;
import com.google.logging.v2.ListMonitoredResourceDescriptorsRequest;
import com.google.logging.v2.ListMonitoredResourceDescriptorsResponse;
import com.google.logging.v2.LogEntry;
import com.google.logging.v2.WriteLogEntriesRequest;
import com.google.logging.v2.WriteLogEntriesResponse;
import com.google.protobuf.Empty;
import io.grpc.Status;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class LoggingSettings
extends ClientSettings {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/cloud-platform.read-only").add((Object)"https://www.googleapis.com/auth/logging.admin").add((Object)"https://www.googleapis.com/auth/logging.read").add((Object)"https://www.googleapis.com/auth/logging.write").build();
    private static final String DEFAULT_GAPIC_NAME = "gapic";
    private static final String DEFAULT_GAPIC_VERSION = "";
    private static final String PROPERTIES_FILE = "/com/google/cloud/logging/project.properties";
    private static final String META_VERSION_KEY = "artifact.version";
    private static String gapicVersion;
    private final SimpleCallSettings<DeleteLogRequest, Empty> deleteLogSettings;
    private final BatchingCallSettings<WriteLogEntriesRequest, WriteLogEntriesResponse> writeLogEntriesSettings;
    private final PagedCallSettings<ListLogEntriesRequest, ListLogEntriesResponse, PagedResponseWrappers.ListLogEntriesPagedResponse> listLogEntriesSettings;
    private final PagedCallSettings<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse> listMonitoredResourceDescriptorsSettings;
    private final PagedCallSettings<ListLogsRequest, ListLogsResponse, PagedResponseWrappers.ListLogsPagedResponse> listLogsSettings;
    private static final PagedListDescriptor<ListLogEntriesRequest, ListLogEntriesResponse, LogEntry> LIST_LOG_ENTRIES_PAGE_STR_DESC;
    private static final PagedListDescriptor<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, MonitoredResourceDescriptor> LIST_MONITORED_RESOURCE_DESCRIPTORS_PAGE_STR_DESC;
    private static final PagedListDescriptor<ListLogsRequest, ListLogsResponse, String> LIST_LOGS_PAGE_STR_DESC;
    private static final PagedListResponseFactory<ListLogEntriesRequest, ListLogEntriesResponse, PagedResponseWrappers.ListLogEntriesPagedResponse> LIST_LOG_ENTRIES_PAGE_STR_FACT;
    private static final PagedListResponseFactory<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse> LIST_MONITORED_RESOURCE_DESCRIPTORS_PAGE_STR_FACT;
    private static final PagedListResponseFactory<ListLogsRequest, ListLogsResponse, PagedResponseWrappers.ListLogsPagedResponse> LIST_LOGS_PAGE_STR_FACT;
    private static final BatchingDescriptor<WriteLogEntriesRequest, WriteLogEntriesResponse> WRITE_LOG_ENTRIES_BATCHING_DESC;

    public SimpleCallSettings<DeleteLogRequest, Empty> deleteLogSettings() {
        return this.deleteLogSettings;
    }

    public BatchingCallSettings<WriteLogEntriesRequest, WriteLogEntriesResponse> writeLogEntriesSettings() {
        return this.writeLogEntriesSettings;
    }

    public PagedCallSettings<ListLogEntriesRequest, ListLogEntriesResponse, PagedResponseWrappers.ListLogEntriesPagedResponse> listLogEntriesSettings() {
        return this.listLogEntriesSettings;
    }

    public PagedCallSettings<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse> listMonitoredResourceDescriptorsSettings() {
        return this.listMonitoredResourceDescriptorsSettings;
    }

    public PagedCallSettings<ListLogsRequest, ListLogsResponse, PagedResponseWrappers.ListLogsPagedResponse> listLogsSettings() {
        return this.listLogsSettings;
    }

    public LoggingServiceV2Stub createStub() throws IOException {
        if (this.getTransportProvider().getTransportName().equals(GrpcTransport.getGrpcTransportName())) {
            return GrpcLoggingServiceV2Stub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "logging.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingChannelProvider.Builder defaultGrpcChannelProviderBuilder() {
        return InstantiatingChannelProvider.newBuilder().setEndpoint(LoggingSettings.getDefaultEndpoint()).setGeneratorHeader(DEFAULT_GAPIC_NAME, LoggingSettings.getGapicVersion());
    }

    public static GrpcTransportProvider.Builder defaultGrpcTransportProviderBuilder() {
        return GrpcTransportProvider.newBuilder().setChannelProvider((ChannelProvider)LoggingSettings.defaultGrpcChannelProviderBuilder().build());
    }

    public static TransportProvider defaultTransportProvider() {
        return LoggingSettings.defaultGrpcTransportProviderBuilder().build();
    }

    private static String getGapicVersion() {
        if (gapicVersion == null) {
            gapicVersion = PropertiesProvider.loadProperty(LoggingSettings.class, (String)PROPERTIES_FILE, (String)META_VERSION_KEY);
            gapicVersion = gapicVersion == null ? DEFAULT_GAPIC_VERSION : gapicVersion;
        }
        return gapicVersion;
    }

    public static Builder defaultBuilder() {
        return Builder.createDefault();
    }

    public static Builder defaultBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private LoggingSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder.getExecutorProvider(), settingsBuilder.getTransportProvider(), settingsBuilder.getCredentialsProvider(), settingsBuilder.getClock());
        this.deleteLogSettings = settingsBuilder.deleteLogSettings().build();
        this.writeLogEntriesSettings = settingsBuilder.writeLogEntriesSettings().build();
        this.listLogEntriesSettings = settingsBuilder.listLogEntriesSettings().build();
        this.listMonitoredResourceDescriptorsSettings = settingsBuilder.listMonitoredResourceDescriptorsSettings().build();
        this.listLogsSettings = settingsBuilder.listLogsSettings().build();
    }

    static {
        LIST_LOG_ENTRIES_PAGE_STR_DESC = new PagedListDescriptor<ListLogEntriesRequest, ListLogEntriesResponse, LogEntry>(){

            public String emptyToken() {
                return LoggingSettings.DEFAULT_GAPIC_VERSION;
            }

            public ListLogEntriesRequest injectToken(ListLogEntriesRequest payload, String token) {
                return ListLogEntriesRequest.newBuilder((ListLogEntriesRequest)payload).setPageToken(token).build();
            }

            public ListLogEntriesRequest injectPageSize(ListLogEntriesRequest payload, int pageSize) {
                return ListLogEntriesRequest.newBuilder((ListLogEntriesRequest)payload).setPageSize(pageSize).build();
            }

            public Integer extractPageSize(ListLogEntriesRequest payload) {
                return payload.getPageSize();
            }

            public String extractNextToken(ListLogEntriesResponse payload) {
                return payload.getNextPageToken();
            }

            public Iterable<LogEntry> extractResources(ListLogEntriesResponse payload) {
                return payload.getEntriesList();
            }
        };
        LIST_MONITORED_RESOURCE_DESCRIPTORS_PAGE_STR_DESC = new PagedListDescriptor<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, MonitoredResourceDescriptor>(){

            public String emptyToken() {
                return LoggingSettings.DEFAULT_GAPIC_VERSION;
            }

            public ListMonitoredResourceDescriptorsRequest injectToken(ListMonitoredResourceDescriptorsRequest payload, String token) {
                return ListMonitoredResourceDescriptorsRequest.newBuilder((ListMonitoredResourceDescriptorsRequest)payload).setPageToken(token).build();
            }

            public ListMonitoredResourceDescriptorsRequest injectPageSize(ListMonitoredResourceDescriptorsRequest payload, int pageSize) {
                return ListMonitoredResourceDescriptorsRequest.newBuilder((ListMonitoredResourceDescriptorsRequest)payload).setPageSize(pageSize).build();
            }

            public Integer extractPageSize(ListMonitoredResourceDescriptorsRequest payload) {
                return payload.getPageSize();
            }

            public String extractNextToken(ListMonitoredResourceDescriptorsResponse payload) {
                return payload.getNextPageToken();
            }

            public Iterable<MonitoredResourceDescriptor> extractResources(ListMonitoredResourceDescriptorsResponse payload) {
                return payload.getResourceDescriptorsList();
            }
        };
        LIST_LOGS_PAGE_STR_DESC = new PagedListDescriptor<ListLogsRequest, ListLogsResponse, String>(){

            public String emptyToken() {
                return LoggingSettings.DEFAULT_GAPIC_VERSION;
            }

            public ListLogsRequest injectToken(ListLogsRequest payload, String token) {
                return ListLogsRequest.newBuilder((ListLogsRequest)payload).setPageToken(token).build();
            }

            public ListLogsRequest injectPageSize(ListLogsRequest payload, int pageSize) {
                return ListLogsRequest.newBuilder((ListLogsRequest)payload).setPageSize(pageSize).build();
            }

            public Integer extractPageSize(ListLogsRequest payload) {
                return payload.getPageSize();
            }

            public String extractNextToken(ListLogsResponse payload) {
                return payload.getNextPageToken();
            }

            public Iterable<String> extractResources(ListLogsResponse payload) {
                return payload.getLogNamesList();
            }
        };
        LIST_LOG_ENTRIES_PAGE_STR_FACT = new PagedListResponseFactory<ListLogEntriesRequest, ListLogEntriesResponse, PagedResponseWrappers.ListLogEntriesPagedResponse>(){

            public ApiFuture<PagedResponseWrappers.ListLogEntriesPagedResponse> getFuturePagedResponse(UnaryCallable<ListLogEntriesRequest, ListLogEntriesResponse> callable, ListLogEntriesRequest request, ApiCallContext context, ApiFuture<ListLogEntriesResponse> futureResponse) {
                PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOG_ENTRIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
                return PagedResponseWrappers.ListLogEntriesPagedResponse.createAsync((PageContext<ListLogEntriesRequest, ListLogEntriesResponse, LogEntry>)pageContext, futureResponse);
            }
        };
        LIST_MONITORED_RESOURCE_DESCRIPTORS_PAGE_STR_FACT = new PagedListResponseFactory<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse>(){

            public ApiFuture<PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse> getFuturePagedResponse(UnaryCallable<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse> callable, ListMonitoredResourceDescriptorsRequest request, ApiCallContext context, ApiFuture<ListMonitoredResourceDescriptorsResponse> futureResponse) {
                PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_MONITORED_RESOURCE_DESCRIPTORS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
                return PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse.createAsync((PageContext<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, MonitoredResourceDescriptor>)pageContext, futureResponse);
            }
        };
        LIST_LOGS_PAGE_STR_FACT = new PagedListResponseFactory<ListLogsRequest, ListLogsResponse, PagedResponseWrappers.ListLogsPagedResponse>(){

            public ApiFuture<PagedResponseWrappers.ListLogsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLogsRequest, ListLogsResponse> callable, ListLogsRequest request, ApiCallContext context, ApiFuture<ListLogsResponse> futureResponse) {
                PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
                return PagedResponseWrappers.ListLogsPagedResponse.createAsync((PageContext<ListLogsRequest, ListLogsResponse, String>)pageContext, futureResponse);
            }
        };
        WRITE_LOG_ENTRIES_BATCHING_DESC = new BatchingDescriptor<WriteLogEntriesRequest, WriteLogEntriesResponse>(){

            public PartitionKey getBatchPartitionKey(WriteLogEntriesRequest request) {
                return new PartitionKey(new Object[]{request.getLogName(), request.getResource(), request.getLabelsMap()});
            }

            public RequestBuilder<WriteLogEntriesRequest> getRequestBuilder() {
                return new RequestBuilder<WriteLogEntriesRequest>(){
                    private WriteLogEntriesRequest.Builder builder;

                    public void appendRequest(WriteLogEntriesRequest request) {
                        if (this.builder == null) {
                            this.builder = request.toBuilder();
                        } else {
                            this.builder.addAllEntries((Iterable)request.getEntriesList());
                        }
                    }

                    public WriteLogEntriesRequest build() {
                        return this.builder.build();
                    }
                };
            }

            public void splitResponse(WriteLogEntriesResponse batchResponse, Collection<? extends BatchedRequestIssuer<WriteLogEntriesResponse>> batch) {
                boolean batchMessageIndex = false;
                for (BatchedRequestIssuer<WriteLogEntriesResponse> batchedRequestIssuer : batch) {
                    WriteLogEntriesResponse response = WriteLogEntriesResponse.newBuilder().build();
                    batchedRequestIssuer.setResponse((Object)response);
                }
            }

            public void splitException(Throwable throwable, Collection<? extends BatchedRequestIssuer<WriteLogEntriesResponse>> batch) {
                for (BatchedRequestIssuer<WriteLogEntriesResponse> batchedRequestIssuer : batch) {
                    batchedRequestIssuer.setException(throwable);
                }
            }

            public long countElements(WriteLogEntriesRequest request) {
                return request.getEntriesCount();
            }

            public long countBytes(WriteLogEntriesRequest request) {
                return request.getSerializedSize();
            }
        };
    }

    public static class Builder
    extends ClientSettings.Builder {
        private final ImmutableList<UnaryCallSettings.Builder> unaryMethodSettingsBuilders;
        private final SimpleCallSettings.Builder<DeleteLogRequest, Empty> deleteLogSettings;
        private final BatchingCallSettings.Builder<WriteLogEntriesRequest, WriteLogEntriesResponse> writeLogEntriesSettings;
        private final PagedCallSettings.Builder<ListLogEntriesRequest, ListLogEntriesResponse, PagedResponseWrappers.ListLogEntriesPagedResponse> listLogEntriesSettings;
        private final PagedCallSettings.Builder<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse> listMonitoredResourceDescriptorsSettings;
        private final PagedCallSettings.Builder<ListLogsRequest, ListLogsResponse, PagedResponseWrappers.ListLogsPagedResponse> listLogsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        private Builder() {
            this((ClientContext)null);
        }

        private Builder(ClientContext clientContext) {
            super(clientContext);
            this.deleteLogSettings = SimpleCallSettings.newBuilder();
            this.writeLogEntriesSettings = BatchingCallSettings.newBuilder((BatchingDescriptor)WRITE_LOG_ENTRIES_BATCHING_DESC).setBatchingSettings(BatchingSettings.newBuilder().build());
            this.listLogEntriesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOG_ENTRIES_PAGE_STR_FACT);
            this.listMonitoredResourceDescriptorsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_MONITORED_RESOURCE_DESCRIPTORS_PAGE_STR_FACT);
            this.listLogsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOGS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteLogSettings, this.writeLogEntriesSettings, this.listLogEntriesSettings, this.listMonitoredResourceDescriptorsSettings, this.listLogsSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportProvider(LoggingSettings.defaultTransportProvider());
            builder.setCredentialsProvider((CredentialsProvider)LoggingSettings.defaultCredentialsProviderBuilder().build());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.deleteLogSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.writeLogEntriesSettings().setBatchingSettings(BatchingSettings.newBuilder().setElementCountThreshold(Long.valueOf(1000L)).setRequestByteThreshold(Long.valueOf(0x100000L)).setDelayThreshold(Duration.ofMillis((long)50L)).setFlowControlSettings(FlowControlSettings.newBuilder().setMaxOutstandingElementCount(Integer.valueOf(100000)).setMaxOutstandingRequestBytes(Integer.valueOf(0xA00000)).setLimitExceededBehavior(FlowController.LimitExceededBehavior.ThrowException).build()).build());
            builder.writeLogEntriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listLogEntriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"list"));
            builder.listMonitoredResourceDescriptorsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listLogsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        private Builder(LoggingSettings settings) {
            super((ClientSettings)settings);
            this.deleteLogSettings = settings.deleteLogSettings.toBuilder();
            this.writeLogEntriesSettings = settings.writeLogEntriesSettings.toBuilder();
            this.listLogEntriesSettings = settings.listLogEntriesSettings.toBuilder();
            this.listMonitoredResourceDescriptorsSettings = settings.listMonitoredResourceDescriptorsSettings.toBuilder();
            this.listLogsSettings = settings.listLogsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteLogSettings, this.writeLogEntriesSettings, this.listLogEntriesSettings, this.listMonitoredResourceDescriptorsSettings, this.listLogsSettings);
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            super.setExecutorProvider(executorProvider);
            return this;
        }

        public Builder setTransportProvider(TransportProvider transportProvider) {
            super.setTransportProvider(transportProvider);
            return this;
        }

        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            super.setCredentialsProvider(credentialsProvider);
            return this;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder, Void> settingsUpdater) throws Exception {
            super.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public SimpleCallSettings.Builder<DeleteLogRequest, Empty> deleteLogSettings() {
            return this.deleteLogSettings;
        }

        public BatchingCallSettings.Builder<WriteLogEntriesRequest, WriteLogEntriesResponse> writeLogEntriesSettings() {
            return this.writeLogEntriesSettings;
        }

        public PagedCallSettings.Builder<ListLogEntriesRequest, ListLogEntriesResponse, PagedResponseWrappers.ListLogEntriesPagedResponse> listLogEntriesSettings() {
            return this.listLogEntriesSettings;
        }

        public PagedCallSettings.Builder<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse> listMonitoredResourceDescriptorsSettings() {
            return this.listMonitoredResourceDescriptorsSettings;
        }

        public PagedCallSettings.Builder<ListLogsRequest, ListLogsResponse, PagedResponseWrappers.ListLogsPagedResponse> listLogsSettings() {
            return this.listLogsSettings;
        }

        public LoggingSettings build() throws IOException {
            return new LoggingSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode[]{GrpcStatusCode.of((Status.Code)Status.Code.DEADLINE_EXCEEDED), GrpcStatusCode.of((Status.Code)Status.Code.INTERNAL), GrpcStatusCode.of((Status.Code)Status.Code.UNAVAILABLE)})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.2).setMaxRetryDelay(Duration.ofMillis((long)1000L)).setInitialRpcTimeout(Duration.ofMillis((long)2000L)).setRpcTimeoutMultiplier(1.5).setMaxRpcTimeout(Duration.ofMillis((long)30000L)).setTotalTimeout(Duration.ofMillis((long)45000L)).build();
            definitions.put((Object)"default", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.2).setMaxRetryDelay(Duration.ofMillis((long)1000L)).setInitialRpcTimeout(Duration.ofMillis((long)7000L)).setRpcTimeoutMultiplier(1.5).setMaxRpcTimeout(Duration.ofMillis((long)30000L)).setTotalTimeout(Duration.ofMillis((long)45000L)).build();
            definitions.put((Object)"list", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

