/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging;

import com.google.cloud.logging.LogEntry;
import com.google.cloud.logging.LoggingEnhancer;

public class TraceLoggingEnhancer
implements LoggingEnhancer {
    private static final String TRACE_ID = "trace_id";
    private final String traceIdLabel;
    private static final ThreadLocal<String> traceId = new ThreadLocal();

    public TraceLoggingEnhancer() {
        this.traceIdLabel = TRACE_ID;
    }

    public TraceLoggingEnhancer(String prefix) {
        String string;
        if (prefix != null) {
            String string2 = String.valueOf(prefix);
            String string3 = String.valueOf(TRACE_ID);
            string = string3.length() != 0 ? string2.concat(string3) : new String(string2);
        } else {
            string = TRACE_ID;
        }
        this.traceIdLabel = string;
    }

    public static void setCurrentTraceId(String id) {
        traceId.set(id);
    }

    public static String getCurrentTraceId() {
        return traceId.get();
    }

    @Override
    public void enhanceLogEntry(LogEntry.Builder builder) {
        String traceId = TraceLoggingEnhancer.getCurrentTraceId();
        if (traceId != null) {
            builder.addLabel(this.traceIdLabel, traceId);
        }
    }
}

