/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging.v2;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.core.PropertiesProvider;
import com.google.api.gax.grpc.ChannelProvider;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.grpc.GrpcTransport;
import com.google.api.gax.grpc.GrpcTransportProvider;
import com.google.api.gax.grpc.InstantiatingChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ClientSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.SimpleCallSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.logging.v2.PagedResponseWrappers;
import com.google.cloud.logging.v2.stub.GrpcMetricsServiceV2Stub;
import com.google.cloud.logging.v2.stub.MetricsServiceV2Stub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.logging.v2.CreateLogMetricRequest;
import com.google.logging.v2.DeleteLogMetricRequest;
import com.google.logging.v2.GetLogMetricRequest;
import com.google.logging.v2.ListLogMetricsRequest;
import com.google.logging.v2.ListLogMetricsResponse;
import com.google.logging.v2.LogMetric;
import com.google.logging.v2.UpdateLogMetricRequest;
import com.google.protobuf.Empty;
import io.grpc.Status;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class MetricsSettings
extends ClientSettings {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/cloud-platform.read-only").add((Object)"https://www.googleapis.com/auth/logging.admin").add((Object)"https://www.googleapis.com/auth/logging.read").add((Object)"https://www.googleapis.com/auth/logging.write").build();
    private static final String DEFAULT_GAPIC_NAME = "gapic";
    private static final String DEFAULT_GAPIC_VERSION = "";
    private static final String PROPERTIES_FILE = "/com/google/cloud/logging/project.properties";
    private static final String META_VERSION_KEY = "artifact.version";
    private static String gapicVersion;
    private final PagedCallSettings<ListLogMetricsRequest, ListLogMetricsResponse, PagedResponseWrappers.ListLogMetricsPagedResponse> listLogMetricsSettings;
    private final SimpleCallSettings<GetLogMetricRequest, LogMetric> getLogMetricSettings;
    private final SimpleCallSettings<CreateLogMetricRequest, LogMetric> createLogMetricSettings;
    private final SimpleCallSettings<UpdateLogMetricRequest, LogMetric> updateLogMetricSettings;
    private final SimpleCallSettings<DeleteLogMetricRequest, Empty> deleteLogMetricSettings;
    private static final PagedListDescriptor<ListLogMetricsRequest, ListLogMetricsResponse, LogMetric> LIST_LOG_METRICS_PAGE_STR_DESC;
    private static final PagedListResponseFactory<ListLogMetricsRequest, ListLogMetricsResponse, PagedResponseWrappers.ListLogMetricsPagedResponse> LIST_LOG_METRICS_PAGE_STR_FACT;

    public PagedCallSettings<ListLogMetricsRequest, ListLogMetricsResponse, PagedResponseWrappers.ListLogMetricsPagedResponse> listLogMetricsSettings() {
        return this.listLogMetricsSettings;
    }

    public SimpleCallSettings<GetLogMetricRequest, LogMetric> getLogMetricSettings() {
        return this.getLogMetricSettings;
    }

    public SimpleCallSettings<CreateLogMetricRequest, LogMetric> createLogMetricSettings() {
        return this.createLogMetricSettings;
    }

    public SimpleCallSettings<UpdateLogMetricRequest, LogMetric> updateLogMetricSettings() {
        return this.updateLogMetricSettings;
    }

    public SimpleCallSettings<DeleteLogMetricRequest, Empty> deleteLogMetricSettings() {
        return this.deleteLogMetricSettings;
    }

    public MetricsServiceV2Stub createStub() throws IOException {
        if (this.getTransportProvider().getTransportName().equals(GrpcTransport.getGrpcTransportName())) {
            return GrpcMetricsServiceV2Stub.create(this);
        }
        String string = String.valueOf(this.getTransportProvider().getTransportName());
        throw new UnsupportedOperationException(string.length() != 0 ? "Transport not supported: ".concat(string) : new String("Transport not supported: "));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "logging.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingChannelProvider.Builder defaultGrpcChannelProviderBuilder() {
        return InstantiatingChannelProvider.newBuilder().setEndpoint(MetricsSettings.getDefaultEndpoint()).setGeneratorHeader(DEFAULT_GAPIC_NAME, MetricsSettings.getGapicVersion());
    }

    public static GrpcTransportProvider.Builder defaultGrpcTransportProviderBuilder() {
        return GrpcTransportProvider.newBuilder().setChannelProvider((ChannelProvider)MetricsSettings.defaultGrpcChannelProviderBuilder().build());
    }

    public static TransportProvider defaultTransportProvider() {
        return MetricsSettings.defaultGrpcTransportProviderBuilder().build();
    }

    private static String getGapicVersion() {
        if (gapicVersion == null) {
            gapicVersion = PropertiesProvider.loadProperty(MetricsSettings.class, (String)PROPERTIES_FILE, (String)META_VERSION_KEY);
            gapicVersion = gapicVersion == null ? DEFAULT_GAPIC_VERSION : gapicVersion;
        }
        return gapicVersion;
    }

    public static Builder defaultBuilder() {
        return Builder.createDefault();
    }

    public static Builder defaultBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private MetricsSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder.getExecutorProvider(), settingsBuilder.getTransportProvider(), settingsBuilder.getCredentialsProvider(), settingsBuilder.getClock());
        this.listLogMetricsSettings = settingsBuilder.listLogMetricsSettings().build();
        this.getLogMetricSettings = settingsBuilder.getLogMetricSettings().build();
        this.createLogMetricSettings = settingsBuilder.createLogMetricSettings().build();
        this.updateLogMetricSettings = settingsBuilder.updateLogMetricSettings().build();
        this.deleteLogMetricSettings = settingsBuilder.deleteLogMetricSettings().build();
    }

    static {
        LIST_LOG_METRICS_PAGE_STR_DESC = new PagedListDescriptor<ListLogMetricsRequest, ListLogMetricsResponse, LogMetric>(){

            public String emptyToken() {
                return MetricsSettings.DEFAULT_GAPIC_VERSION;
            }

            public ListLogMetricsRequest injectToken(ListLogMetricsRequest payload, String token) {
                return ListLogMetricsRequest.newBuilder((ListLogMetricsRequest)payload).setPageToken(token).build();
            }

            public ListLogMetricsRequest injectPageSize(ListLogMetricsRequest payload, int pageSize) {
                return ListLogMetricsRequest.newBuilder((ListLogMetricsRequest)payload).setPageSize(pageSize).build();
            }

            public Integer extractPageSize(ListLogMetricsRequest payload) {
                return payload.getPageSize();
            }

            public String extractNextToken(ListLogMetricsResponse payload) {
                return payload.getNextPageToken();
            }

            public Iterable<LogMetric> extractResources(ListLogMetricsResponse payload) {
                return payload.getMetricsList();
            }
        };
        LIST_LOG_METRICS_PAGE_STR_FACT = new PagedListResponseFactory<ListLogMetricsRequest, ListLogMetricsResponse, PagedResponseWrappers.ListLogMetricsPagedResponse>(){

            public ApiFuture<PagedResponseWrappers.ListLogMetricsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLogMetricsRequest, ListLogMetricsResponse> callable, ListLogMetricsRequest request, ApiCallContext context, ApiFuture<ListLogMetricsResponse> futureResponse) {
                PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOG_METRICS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
                return PagedResponseWrappers.ListLogMetricsPagedResponse.createAsync((PageContext<ListLogMetricsRequest, ListLogMetricsResponse, LogMetric>)pageContext, futureResponse);
            }
        };
    }

    public static class Builder
    extends ClientSettings.Builder {
        private final ImmutableList<UnaryCallSettings.Builder> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListLogMetricsRequest, ListLogMetricsResponse, PagedResponseWrappers.ListLogMetricsPagedResponse> listLogMetricsSettings;
        private final SimpleCallSettings.Builder<GetLogMetricRequest, LogMetric> getLogMetricSettings;
        private final SimpleCallSettings.Builder<CreateLogMetricRequest, LogMetric> createLogMetricSettings;
        private final SimpleCallSettings.Builder<UpdateLogMetricRequest, LogMetric> updateLogMetricSettings;
        private final SimpleCallSettings.Builder<DeleteLogMetricRequest, Empty> deleteLogMetricSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        private Builder() {
            this((ClientContext)null);
        }

        private Builder(ClientContext clientContext) {
            super(clientContext);
            this.listLogMetricsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOG_METRICS_PAGE_STR_FACT);
            this.getLogMetricSettings = SimpleCallSettings.newBuilder();
            this.createLogMetricSettings = SimpleCallSettings.newBuilder();
            this.updateLogMetricSettings = SimpleCallSettings.newBuilder();
            this.deleteLogMetricSettings = SimpleCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listLogMetricsSettings, this.getLogMetricSettings, this.createLogMetricSettings, this.updateLogMetricSettings, this.deleteLogMetricSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportProvider(MetricsSettings.defaultTransportProvider());
            builder.setCredentialsProvider((CredentialsProvider)MetricsSettings.defaultCredentialsProviderBuilder().build());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listLogMetricsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getLogMetricSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createLogMetricSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateLogMetricSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteLogMetricSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        private Builder(MetricsSettings settings) {
            super((ClientSettings)settings);
            this.listLogMetricsSettings = settings.listLogMetricsSettings.toBuilder();
            this.getLogMetricSettings = settings.getLogMetricSettings.toBuilder();
            this.createLogMetricSettings = settings.createLogMetricSettings.toBuilder();
            this.updateLogMetricSettings = settings.updateLogMetricSettings.toBuilder();
            this.deleteLogMetricSettings = settings.deleteLogMetricSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listLogMetricsSettings, this.getLogMetricSettings, this.createLogMetricSettings, this.updateLogMetricSettings, this.deleteLogMetricSettings);
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            super.setExecutorProvider(executorProvider);
            return this;
        }

        public Builder setTransportProvider(TransportProvider transportProvider) {
            super.setTransportProvider(transportProvider);
            return this;
        }

        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            super.setCredentialsProvider(credentialsProvider);
            return this;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder, Void> settingsUpdater) throws Exception {
            super.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public PagedCallSettings.Builder<ListLogMetricsRequest, ListLogMetricsResponse, PagedResponseWrappers.ListLogMetricsPagedResponse> listLogMetricsSettings() {
            return this.listLogMetricsSettings;
        }

        public SimpleCallSettings.Builder<GetLogMetricRequest, LogMetric> getLogMetricSettings() {
            return this.getLogMetricSettings;
        }

        public SimpleCallSettings.Builder<CreateLogMetricRequest, LogMetric> createLogMetricSettings() {
            return this.createLogMetricSettings;
        }

        public SimpleCallSettings.Builder<UpdateLogMetricRequest, LogMetric> updateLogMetricSettings() {
            return this.updateLogMetricSettings;
        }

        public SimpleCallSettings.Builder<DeleteLogMetricRequest, Empty> deleteLogMetricSettings() {
            return this.deleteLogMetricSettings;
        }

        public MetricsSettings build() throws IOException {
            return new MetricsSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode[]{GrpcStatusCode.of((Status.Code)Status.Code.DEADLINE_EXCEEDED), GrpcStatusCode.of((Status.Code)Status.Code.INTERNAL), GrpcStatusCode.of((Status.Code)Status.Code.UNAVAILABLE)})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.2).setMaxRetryDelay(Duration.ofMillis((long)1000L)).setInitialRpcTimeout(Duration.ofMillis((long)2000L)).setRpcTimeoutMultiplier(1.5).setMaxRpcTimeout(Duration.ofMillis((long)30000L)).setTotalTimeout(Duration.ofMillis((long)45000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

