/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.logging.v2.ConfigClient;
import com.google.cloud.logging.v2.stub.ConfigServiceV2Stub;
import com.google.cloud.logging.v2.stub.GrpcConfigServiceV2Stub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.logging.v2.CmekSettings;
import com.google.logging.v2.CreateExclusionRequest;
import com.google.logging.v2.CreateSinkRequest;
import com.google.logging.v2.DeleteExclusionRequest;
import com.google.logging.v2.DeleteSinkRequest;
import com.google.logging.v2.GetBucketRequest;
import com.google.logging.v2.GetCmekSettingsRequest;
import com.google.logging.v2.GetExclusionRequest;
import com.google.logging.v2.GetSinkRequest;
import com.google.logging.v2.ListBucketsRequest;
import com.google.logging.v2.ListBucketsResponse;
import com.google.logging.v2.ListExclusionsRequest;
import com.google.logging.v2.ListExclusionsResponse;
import com.google.logging.v2.ListSinksRequest;
import com.google.logging.v2.ListSinksResponse;
import com.google.logging.v2.LogBucket;
import com.google.logging.v2.LogExclusion;
import com.google.logging.v2.LogSink;
import com.google.logging.v2.UpdateBucketRequest;
import com.google.logging.v2.UpdateCmekSettingsRequest;
import com.google.logging.v2.UpdateExclusionRequest;
import com.google.logging.v2.UpdateSinkRequest;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class ConfigServiceV2StubSettings
extends StubSettings<ConfigServiceV2StubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/cloud-platform.read-only").add((Object)"https://www.googleapis.com/auth/logging.admin").add((Object)"https://www.googleapis.com/auth/logging.read").add((Object)"https://www.googleapis.com/auth/logging.write").build();
    private final UnaryCallSettings<DeleteSinkRequest, Empty> deleteSinkSettings;
    private final UnaryCallSettings<UpdateSinkRequest, LogSink> updateSinkSettings;
    private final UnaryCallSettings<DeleteExclusionRequest, Empty> deleteExclusionSettings;
    private final PagedCallSettings<ListBucketsRequest, ListBucketsResponse, ConfigClient.ListBucketsPagedResponse> listBucketsSettings;
    private final UnaryCallSettings<GetBucketRequest, LogBucket> getBucketSettings;
    private final UnaryCallSettings<UpdateBucketRequest, LogBucket> updateBucketSettings;
    private final PagedCallSettings<ListSinksRequest, ListSinksResponse, ConfigClient.ListSinksPagedResponse> listSinksSettings;
    private final UnaryCallSettings<GetSinkRequest, LogSink> getSinkSettings;
    private final UnaryCallSettings<CreateSinkRequest, LogSink> createSinkSettings;
    private final PagedCallSettings<ListExclusionsRequest, ListExclusionsResponse, ConfigClient.ListExclusionsPagedResponse> listExclusionsSettings;
    private final UnaryCallSettings<GetExclusionRequest, LogExclusion> getExclusionSettings;
    private final UnaryCallSettings<CreateExclusionRequest, LogExclusion> createExclusionSettings;
    private final UnaryCallSettings<UpdateExclusionRequest, LogExclusion> updateExclusionSettings;
    private final UnaryCallSettings<GetCmekSettingsRequest, CmekSettings> getCmekSettingsSettings;
    private final UnaryCallSettings<UpdateCmekSettingsRequest, CmekSettings> updateCmekSettingsSettings;
    private static final PagedListDescriptor<ListBucketsRequest, ListBucketsResponse, LogBucket> LIST_BUCKETS_PAGE_STR_DESC = new PagedListDescriptor<ListBucketsRequest, ListBucketsResponse, LogBucket>(){

        public String emptyToken() {
            return "";
        }

        public ListBucketsRequest injectToken(ListBucketsRequest payload, String token) {
            return ListBucketsRequest.newBuilder((ListBucketsRequest)payload).setPageToken(token).build();
        }

        public ListBucketsRequest injectPageSize(ListBucketsRequest payload, int pageSize) {
            return ListBucketsRequest.newBuilder((ListBucketsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListBucketsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListBucketsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<LogBucket> extractResources(ListBucketsResponse payload) {
            return payload.getBucketsList() != null ? payload.getBucketsList() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListSinksRequest, ListSinksResponse, LogSink> LIST_SINKS_PAGE_STR_DESC = new PagedListDescriptor<ListSinksRequest, ListSinksResponse, LogSink>(){

        public String emptyToken() {
            return "";
        }

        public ListSinksRequest injectToken(ListSinksRequest payload, String token) {
            return ListSinksRequest.newBuilder((ListSinksRequest)payload).setPageToken(token).build();
        }

        public ListSinksRequest injectPageSize(ListSinksRequest payload, int pageSize) {
            return ListSinksRequest.newBuilder((ListSinksRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSinksRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSinksResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<LogSink> extractResources(ListSinksResponse payload) {
            return payload.getSinksList() != null ? payload.getSinksList() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListExclusionsRequest, ListExclusionsResponse, LogExclusion> LIST_EXCLUSIONS_PAGE_STR_DESC = new PagedListDescriptor<ListExclusionsRequest, ListExclusionsResponse, LogExclusion>(){

        public String emptyToken() {
            return "";
        }

        public ListExclusionsRequest injectToken(ListExclusionsRequest payload, String token) {
            return ListExclusionsRequest.newBuilder((ListExclusionsRequest)payload).setPageToken(token).build();
        }

        public ListExclusionsRequest injectPageSize(ListExclusionsRequest payload, int pageSize) {
            return ListExclusionsRequest.newBuilder((ListExclusionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListExclusionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListExclusionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<LogExclusion> extractResources(ListExclusionsResponse payload) {
            return payload.getExclusionsList() != null ? payload.getExclusionsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListBucketsRequest, ListBucketsResponse, ConfigClient.ListBucketsPagedResponse> LIST_BUCKETS_PAGE_STR_FACT = new PagedListResponseFactory<ListBucketsRequest, ListBucketsResponse, ConfigClient.ListBucketsPagedResponse>(){

        public ApiFuture<ConfigClient.ListBucketsPagedResponse> getFuturePagedResponse(UnaryCallable<ListBucketsRequest, ListBucketsResponse> callable, ListBucketsRequest request, ApiCallContext context, ApiFuture<ListBucketsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_BUCKETS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ConfigClient.ListBucketsPagedResponse.createAsync((PageContext<ListBucketsRequest, ListBucketsResponse, LogBucket>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListSinksRequest, ListSinksResponse, ConfigClient.ListSinksPagedResponse> LIST_SINKS_PAGE_STR_FACT = new PagedListResponseFactory<ListSinksRequest, ListSinksResponse, ConfigClient.ListSinksPagedResponse>(){

        public ApiFuture<ConfigClient.ListSinksPagedResponse> getFuturePagedResponse(UnaryCallable<ListSinksRequest, ListSinksResponse> callable, ListSinksRequest request, ApiCallContext context, ApiFuture<ListSinksResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SINKS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ConfigClient.ListSinksPagedResponse.createAsync((PageContext<ListSinksRequest, ListSinksResponse, LogSink>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListExclusionsRequest, ListExclusionsResponse, ConfigClient.ListExclusionsPagedResponse> LIST_EXCLUSIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListExclusionsRequest, ListExclusionsResponse, ConfigClient.ListExclusionsPagedResponse>(){

        public ApiFuture<ConfigClient.ListExclusionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListExclusionsRequest, ListExclusionsResponse> callable, ListExclusionsRequest request, ApiCallContext context, ApiFuture<ListExclusionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_EXCLUSIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ConfigClient.ListExclusionsPagedResponse.createAsync((PageContext<ListExclusionsRequest, ListExclusionsResponse, LogExclusion>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<DeleteSinkRequest, Empty> deleteSinkSettings() {
        return this.deleteSinkSettings;
    }

    public UnaryCallSettings<UpdateSinkRequest, LogSink> updateSinkSettings() {
        return this.updateSinkSettings;
    }

    public UnaryCallSettings<DeleteExclusionRequest, Empty> deleteExclusionSettings() {
        return this.deleteExclusionSettings;
    }

    public PagedCallSettings<ListBucketsRequest, ListBucketsResponse, ConfigClient.ListBucketsPagedResponse> listBucketsSettings() {
        return this.listBucketsSettings;
    }

    public UnaryCallSettings<GetBucketRequest, LogBucket> getBucketSettings() {
        return this.getBucketSettings;
    }

    public UnaryCallSettings<UpdateBucketRequest, LogBucket> updateBucketSettings() {
        return this.updateBucketSettings;
    }

    public PagedCallSettings<ListSinksRequest, ListSinksResponse, ConfigClient.ListSinksPagedResponse> listSinksSettings() {
        return this.listSinksSettings;
    }

    public UnaryCallSettings<GetSinkRequest, LogSink> getSinkSettings() {
        return this.getSinkSettings;
    }

    public UnaryCallSettings<CreateSinkRequest, LogSink> createSinkSettings() {
        return this.createSinkSettings;
    }

    public PagedCallSettings<ListExclusionsRequest, ListExclusionsResponse, ConfigClient.ListExclusionsPagedResponse> listExclusionsSettings() {
        return this.listExclusionsSettings;
    }

    public UnaryCallSettings<GetExclusionRequest, LogExclusion> getExclusionSettings() {
        return this.getExclusionSettings;
    }

    public UnaryCallSettings<CreateExclusionRequest, LogExclusion> createExclusionSettings() {
        return this.createExclusionSettings;
    }

    public UnaryCallSettings<UpdateExclusionRequest, LogExclusion> updateExclusionSettings() {
        return this.updateExclusionSettings;
    }

    public UnaryCallSettings<GetCmekSettingsRequest, CmekSettings> getCmekSettingsSettings() {
        return this.getCmekSettingsSettings;
    }

    public UnaryCallSettings<UpdateCmekSettingsRequest, CmekSettings> updateCmekSettingsSettings() {
        return this.updateCmekSettingsSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ConfigServiceV2Stub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcConfigServiceV2Stub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "logging.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ConfigServiceV2StubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ConfigServiceV2StubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ConfigServiceV2StubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.deleteSinkSettings = settingsBuilder.deleteSinkSettings().build();
        this.updateSinkSettings = settingsBuilder.updateSinkSettings().build();
        this.deleteExclusionSettings = settingsBuilder.deleteExclusionSettings().build();
        this.listBucketsSettings = settingsBuilder.listBucketsSettings().build();
        this.getBucketSettings = settingsBuilder.getBucketSettings().build();
        this.updateBucketSettings = settingsBuilder.updateBucketSettings().build();
        this.listSinksSettings = settingsBuilder.listSinksSettings().build();
        this.getSinkSettings = settingsBuilder.getSinkSettings().build();
        this.createSinkSettings = settingsBuilder.createSinkSettings().build();
        this.listExclusionsSettings = settingsBuilder.listExclusionsSettings().build();
        this.getExclusionSettings = settingsBuilder.getExclusionSettings().build();
        this.createExclusionSettings = settingsBuilder.createExclusionSettings().build();
        this.updateExclusionSettings = settingsBuilder.updateExclusionSettings().build();
        this.getCmekSettingsSettings = settingsBuilder.getCmekSettingsSettings().build();
        this.updateCmekSettingsSettings = settingsBuilder.updateCmekSettingsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ConfigServiceV2StubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<DeleteSinkRequest, Empty> deleteSinkSettings;
        private final UnaryCallSettings.Builder<UpdateSinkRequest, LogSink> updateSinkSettings;
        private final UnaryCallSettings.Builder<DeleteExclusionRequest, Empty> deleteExclusionSettings;
        private final PagedCallSettings.Builder<ListBucketsRequest, ListBucketsResponse, ConfigClient.ListBucketsPagedResponse> listBucketsSettings;
        private final UnaryCallSettings.Builder<GetBucketRequest, LogBucket> getBucketSettings;
        private final UnaryCallSettings.Builder<UpdateBucketRequest, LogBucket> updateBucketSettings;
        private final PagedCallSettings.Builder<ListSinksRequest, ListSinksResponse, ConfigClient.ListSinksPagedResponse> listSinksSettings;
        private final UnaryCallSettings.Builder<GetSinkRequest, LogSink> getSinkSettings;
        private final UnaryCallSettings.Builder<CreateSinkRequest, LogSink> createSinkSettings;
        private final PagedCallSettings.Builder<ListExclusionsRequest, ListExclusionsResponse, ConfigClient.ListExclusionsPagedResponse> listExclusionsSettings;
        private final UnaryCallSettings.Builder<GetExclusionRequest, LogExclusion> getExclusionSettings;
        private final UnaryCallSettings.Builder<CreateExclusionRequest, LogExclusion> createExclusionSettings;
        private final UnaryCallSettings.Builder<UpdateExclusionRequest, LogExclusion> updateExclusionSettings;
        private final UnaryCallSettings.Builder<GetCmekSettingsRequest, CmekSettings> getCmekSettingsSettings;
        private final UnaryCallSettings.Builder<UpdateCmekSettingsRequest, CmekSettings> updateCmekSettingsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.deleteSinkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSinkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteExclusionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listBucketsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_BUCKETS_PAGE_STR_FACT);
            this.getBucketSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateBucketSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSinksSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SINKS_PAGE_STR_FACT);
            this.getSinkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createSinkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listExclusionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_EXCLUSIONS_PAGE_STR_FACT);
            this.getExclusionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createExclusionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateExclusionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getCmekSettingsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateCmekSettingsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteSinkSettings, this.updateSinkSettings, this.deleteExclusionSettings, this.listBucketsSettings, this.getBucketSettings, this.updateBucketSettings, this.listSinksSettings, this.getSinkSettings, this.createSinkSettings, this.listExclusionsSettings, this.getExclusionSettings, this.createExclusionSettings, (Object[])new UnaryCallSettings.Builder[]{this.updateExclusionSettings, this.getCmekSettingsSettings, this.updateCmekSettingsSettings});
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ConfigServiceV2StubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ConfigServiceV2StubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ConfigServiceV2StubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ConfigServiceV2StubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.deleteSinkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_3_params"));
            builder.updateSinkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_3_params"));
            builder.deleteExclusionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_3_params"));
            builder.listBucketsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getBucketSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateBucketSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listSinksSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_3_params"));
            builder.getSinkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_3_params"));
            builder.createSinkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            builder.listExclusionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_3_params"));
            builder.getExclusionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_3_params"));
            builder.createExclusionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            builder.updateExclusionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            builder.getCmekSettingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateCmekSettingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        protected Builder(ConfigServiceV2StubSettings settings) {
            super((StubSettings)settings);
            this.deleteSinkSettings = settings.deleteSinkSettings.toBuilder();
            this.updateSinkSettings = settings.updateSinkSettings.toBuilder();
            this.deleteExclusionSettings = settings.deleteExclusionSettings.toBuilder();
            this.listBucketsSettings = settings.listBucketsSettings.toBuilder();
            this.getBucketSettings = settings.getBucketSettings.toBuilder();
            this.updateBucketSettings = settings.updateBucketSettings.toBuilder();
            this.listSinksSettings = settings.listSinksSettings.toBuilder();
            this.getSinkSettings = settings.getSinkSettings.toBuilder();
            this.createSinkSettings = settings.createSinkSettings.toBuilder();
            this.listExclusionsSettings = settings.listExclusionsSettings.toBuilder();
            this.getExclusionSettings = settings.getExclusionSettings.toBuilder();
            this.createExclusionSettings = settings.createExclusionSettings.toBuilder();
            this.updateExclusionSettings = settings.updateExclusionSettings.toBuilder();
            this.getCmekSettingsSettings = settings.getCmekSettingsSettings.toBuilder();
            this.updateCmekSettingsSettings = settings.updateCmekSettingsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteSinkSettings, this.updateSinkSettings, this.deleteExclusionSettings, this.listBucketsSettings, this.getBucketSettings, this.updateBucketSettings, this.listSinksSettings, this.getSinkSettings, this.createSinkSettings, this.listExclusionsSettings, this.getExclusionSettings, this.createExclusionSettings, (Object[])new UnaryCallSettings.Builder[]{this.updateExclusionSettings, this.getCmekSettingsSettings, this.updateCmekSettingsSettings});
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<DeleteSinkRequest, Empty> deleteSinkSettings() {
            return this.deleteSinkSettings;
        }

        public UnaryCallSettings.Builder<UpdateSinkRequest, LogSink> updateSinkSettings() {
            return this.updateSinkSettings;
        }

        public UnaryCallSettings.Builder<DeleteExclusionRequest, Empty> deleteExclusionSettings() {
            return this.deleteExclusionSettings;
        }

        public PagedCallSettings.Builder<ListBucketsRequest, ListBucketsResponse, ConfigClient.ListBucketsPagedResponse> listBucketsSettings() {
            return this.listBucketsSettings;
        }

        public UnaryCallSettings.Builder<GetBucketRequest, LogBucket> getBucketSettings() {
            return this.getBucketSettings;
        }

        public UnaryCallSettings.Builder<UpdateBucketRequest, LogBucket> updateBucketSettings() {
            return this.updateBucketSettings;
        }

        public PagedCallSettings.Builder<ListSinksRequest, ListSinksResponse, ConfigClient.ListSinksPagedResponse> listSinksSettings() {
            return this.listSinksSettings;
        }

        public UnaryCallSettings.Builder<GetSinkRequest, LogSink> getSinkSettings() {
            return this.getSinkSettings;
        }

        public UnaryCallSettings.Builder<CreateSinkRequest, LogSink> createSinkSettings() {
            return this.createSinkSettings;
        }

        public PagedCallSettings.Builder<ListExclusionsRequest, ListExclusionsResponse, ConfigClient.ListExclusionsPagedResponse> listExclusionsSettings() {
            return this.listExclusionsSettings;
        }

        public UnaryCallSettings.Builder<GetExclusionRequest, LogExclusion> getExclusionSettings() {
            return this.getExclusionSettings;
        }

        public UnaryCallSettings.Builder<CreateExclusionRequest, LogExclusion> createExclusionSettings() {
            return this.createExclusionSettings;
        }

        public UnaryCallSettings.Builder<UpdateExclusionRequest, LogExclusion> updateExclusionSettings() {
            return this.updateExclusionSettings;
        }

        public UnaryCallSettings.Builder<GetCmekSettingsRequest, CmekSettings> getCmekSettingsSettings() {
            return this.getCmekSettingsSettings;
        }

        public UnaryCallSettings.Builder<UpdateCmekSettingsRequest, CmekSettings> updateCmekSettingsSettings() {
            return this.updateCmekSettingsSettings;
        }

        public ConfigServiceV2StubSettings build() throws IOException {
            return new ConfigServiceV2StubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_2_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_3_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.INTERNAL, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_3_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)120000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)120000L)).setTotalTimeout(Duration.ofMillis((long)120000L)).build();
            definitions.put((Object)"no_retry_2_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

