/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging;

import com.google.cloud.MonitoredResource;
import com.google.cloud.logging.Instrumentation;
import com.google.cloud.logging.LogDestinationName;
import com.google.cloud.logging.LogEntry;
import com.google.cloud.logging.Logging;
import com.google.cloud.logging.LoggingConfig;
import com.google.cloud.logging.LoggingEnhancer;
import com.google.cloud.logging.LoggingLevel;
import com.google.cloud.logging.LoggingOptions;
import com.google.cloud.logging.MonitoredResourceUtil;
import com.google.cloud.logging.Payload;
import com.google.cloud.logging.Severity;
import com.google.cloud.logging.Synchronicity;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.jspecify.nullness.Nullable;

public class LoggingHandler
extends Handler {
    private static final String LEVEL_NAME_KEY = "levelName";
    private static final String LEVEL_VALUE_KEY = "levelValue";
    private final List<LoggingEnhancer> enhancers;
    private final LoggingOptions loggingOptions;
    private volatile Logging logging;
    private final Level baseLevel;
    private volatile Level flushLevel;
    private volatile Boolean autoPopulateMetadata;
    private volatile Boolean redirectToStdout;
    private Logging.WriteOption[] defaultWriteOptions;

    public LoggingHandler() {
        this(null, null, null);
    }

    public LoggingHandler(String log) {
        this(log, null, null);
    }

    public LoggingHandler(String log, LoggingOptions options) {
        this(log, options, null);
    }

    public LoggingHandler(String log, LoggingOptions options, MonitoredResource monitoredResource) {
        this(log, options, monitoredResource, null, null);
    }

    public LoggingHandler(String log, LoggingOptions options, MonitoredResource monitoredResource, List<LoggingEnhancer> enhancers) {
        this(log, options, monitoredResource, enhancers, null);
    }

    public LoggingHandler(String log, LoggingOptions options, MonitoredResource monitoredResource, List<LoggingEnhancer> enhancers, LogDestinationName destination) {
        try {
            this.loggingOptions = options != null ? options : LoggingOptions.getDefaultInstance();
            LoggingConfig config = new LoggingConfig(this.getClass().getName());
            this.setFilter(config.getFilter());
            this.setFormatter(config.getFormatter());
            Level level = config.getLogLevel();
            this.setLevel(level);
            this.baseLevel = level.equals(Level.ALL) ? Level.FINEST : level;
            this.flushLevel = config.getFlushLevel();
            Boolean f1 = this.loggingOptions.getAutoPopulateMetadata();
            Boolean f2 = config.getAutoPopulateMetadata();
            this.autoPopulateMetadata = LoggingHandler.isTrueOrNull(f1) && LoggingHandler.isTrueOrNull(f2);
            this.redirectToStdout = (Boolean)MoreObjects.firstNonNull((Object)config.getRedirectToStdout(), (Object)Boolean.FALSE);
            String logName = log != null ? log : config.getLogName();
            MonitoredResource resource = (MonitoredResource)MoreObjects.firstNonNull((Object)monitoredResource, (Object)config.getMonitoredResource(this.loggingOptions.getProjectId()));
            ArrayList<Logging.WriteOption> writeOptions = new ArrayList<Logging.WriteOption>();
            writeOptions.add(Logging.WriteOption.logName(logName));
            if (resource != null) {
                writeOptions.add(Logging.WriteOption.resource(resource));
            }
            writeOptions.add(Logging.WriteOption.labels((Map<String, String>)ImmutableMap.of((Object)LEVEL_NAME_KEY, (Object)this.baseLevel.getName(), (Object)LEVEL_VALUE_KEY, (Object)String.valueOf(this.baseLevel.intValue()))));
            if (destination != null) {
                writeOptions.add(Logging.WriteOption.destination(destination));
            }
            this.defaultWriteOptions = (Logging.WriteOption[])Iterables.toArray(writeOptions, Logging.WriteOption.class);
            this.logging = (Logging)this.loggingOptions.getService();
            this.logging.setFlushSeverity(LoggingHandler.severityFor(this.flushLevel));
            this.logging.setWriteSynchronicity(config.getSynchronicity());
            this.enhancers = new LinkedList<LoggingEnhancer>();
            List enhancersParam = (List)MoreObjects.firstNonNull(enhancers, (Object)MoreObjects.firstNonNull(config.getEnhancers(), Collections.emptyList()));
            this.enhancers.addAll(enhancersParam);
            List<LoggingEnhancer> loggingEnhancers = MonitoredResourceUtil.getResourceEnhancers();
            this.enhancers.addAll(loggingEnhancers);
        }
        catch (Exception ex) {
            this.reportError(null, ex, 4);
            throw ex;
        }
    }

    @Override
    public void publish(LogRecord record) {
        LogEntry logEntry;
        if (!this.isLoggable(record)) {
            return;
        }
        if ("io.netty.handler.codec.http2.Http2FrameLogger".equals(record.getSourceClassName())) {
            return;
        }
        try {
            logEntry = this.logEntryFor(record).build();
        }
        catch (Exception ex) {
            this.getErrorManager().error(null, ex, 5);
            return;
        }
        if (logEntry != null) {
            try {
                Object logEntries;
                Object object = logEntries = this.redirectToStdout != false ? (Iterable)Instrumentation.populateInstrumentationInfo((Iterable<LogEntry>)ImmutableList.of((Object)logEntry)).y() : ImmutableList.of((Object)logEntry);
                if (this.autoPopulateMetadata.booleanValue()) {
                    logEntries = this.logging.populateMetadata((Iterable<LogEntry>)logEntries, this.getMonitoredResource(), "com.google.cloud.logging", "java");
                }
                if (this.redirectToStdout.booleanValue()) {
                    logEntries.forEach(log -> System.out.println(log.toStructuredJsonString()));
                } else {
                    this.logging.write((Iterable<LogEntry>)logEntries, this.defaultWriteOptions);
                }
            }
            catch (Exception ex) {
                this.getErrorManager().error(null, ex, 1);
            }
        }
    }

    private @Nullable MonitoredResource getMonitoredResource() {
        Optional<Logging.WriteOption> resourceOption = Arrays.stream(this.defaultWriteOptions).filter(o -> o.getOptionType() == Logging.WriteOption.OptionType.RESOURCE).findFirst();
        if (resourceOption.isPresent()) {
            return (MonitoredResource)resourceOption.get().getValue();
        }
        return null;
    }

    protected LogEntry.Builder logEntryFor(LogRecord record) throws Exception {
        String payload = this.getFormatter().format(record);
        Level level = record.getLevel();
        LogEntry.Builder builder = LogEntry.newBuilder(Payload.StringPayload.of(payload)).setTimestamp(Instant.ofEpochMilli(record.getMillis())).setSeverity(LoggingHandler.severityFor(level));
        if (!this.baseLevel.equals(level)) {
            builder.addLabel(LEVEL_NAME_KEY, level.getName()).addLabel(LEVEL_VALUE_KEY, String.valueOf(level.intValue()));
        }
        for (LoggingEnhancer enhancer : this.enhancers) {
            enhancer.enhanceLogEntry(builder);
        }
        return builder;
    }

    @Override
    public void flush() {
        try {
            this.logging.flush();
        }
        catch (Exception ex) {
            this.getErrorManager().error(null, ex, 2);
        }
    }

    @Override
    public synchronized void close() throws SecurityException {
        if (this.logging != null) {
            try {
                this.logging.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.logging = null;
    }

    public Level getFlushLevel() {
        return this.flushLevel;
    }

    public void setFlushLevel(Level flushLevel) {
        this.flushLevel = flushLevel;
        this.logging.setFlushSeverity(LoggingHandler.severityFor(flushLevel));
    }

    public void setSynchronicity(Synchronicity synchronicity) {
        this.logging.setWriteSynchronicity(synchronicity);
    }

    public Synchronicity getSynchronicity() {
        return this.logging.getWriteSynchronicity();
    }

    public void setAutoPopulateMetadata(boolean value) {
        this.autoPopulateMetadata = value;
    }

    public Boolean getAutoPopulateMetadata() {
        return this.autoPopulateMetadata;
    }

    public void setRedirectToStdout(boolean value) {
        this.redirectToStdout = value;
    }

    public Boolean getRedirectToStdout() {
        return this.redirectToStdout;
    }

    public static void addHandler(Logger logger, LoggingHandler handler) {
        logger.addHandler(handler);
    }

    private static Severity severityFor(Level level) {
        if (level instanceof LoggingLevel) {
            return ((LoggingLevel)level).getSeverity();
        }
        switch (level.intValue()) {
            case 300: {
                return Severity.DEBUG;
            }
            case 400: {
                return Severity.DEBUG;
            }
            case 500: {
                return Severity.DEBUG;
            }
            case 700: {
                return Severity.INFO;
            }
            case 800: {
                return Severity.INFO;
            }
            case 900: {
                return Severity.WARNING;
            }
            case 1000: {
                return Severity.ERROR;
            }
        }
        return Severity.DEFAULT;
    }

    private static boolean isTrueOrNull(Boolean b) {
        return b == null || b == Boolean.TRUE;
    }
}

