/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging;

import com.google.cloud.logging.LogEntry;
import com.google.common.collect.Lists;
import com.google.logging.v2.TailLogEntriesResponse;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class LogEntryIterator
implements Iterator<LogEntry> {
    private final Iterator<TailLogEntriesResponse> streamIterator;
    private final LinkedList<LogEntry> buffer = new LinkedList();

    LogEntryIterator(Iterator<TailLogEntriesResponse> streamIterator) {
        this.streamIterator = streamIterator;
    }

    @Override
    public boolean hasNext() {
        return !this.buffer.isEmpty() || this.streamIterator.hasNext();
    }

    @Override
    public LogEntry next() {
        if (this.buffer.isEmpty()) {
            TailLogEntriesResponse response = this.streamIterator.next();
            this.buffer.addAll(Lists.transform((List)response.getEntriesList(), LogEntry.FROM_PB_FUNCTION));
        }
        return this.buffer.pop();
    }
}

