/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging;

import com.google.cloud.MonitoredResource;
import com.google.cloud.logging.LogEntry;
import com.google.cloud.logging.LoggingEnhancer;
import com.google.cloud.logging.MetadataLoader;
import com.google.cloud.logging.ResourceTypeEnvironmentGetter;
import com.google.cloud.logging.ResourceTypeEnvironmentGetterImpl;
import com.google.cloud.logging.TraceLoggingEnhancer;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MonitoredResourceUtil {
    private static final String APPENGINE_LABEL_PREFIX = "appengine.googleapis.com/";
    protected static final String PORJECTID_LABEL = Label.ProjectId.getKey();
    private static final ImmutableMultimap<String, Label> RESOURCE_TYPE_WITH_LABELS = ImmutableMultimap.builder().putAll((Object)Resource.CLOUD_FUNCTION.getKey(), (Object[])new Label[]{Label.FunctionName, Label.Region}).putAll((Object)Resource.CLOUD_RUN.getKey(), (Object[])new Label[]{Label.RevisionName, Label.ServiceName, Label.CloudRunLocation, Label.ConfigurationName}).putAll((Object)Resource.APP_ENGINE.getKey(), (Object[])new Label[]{Label.ModuleId, Label.VersionId, Label.Zone, Label.Env}).putAll((Object)Resource.GCE_INSTANCE.getKey(), (Object[])new Label[]{Label.InstanceId, Label.Zone}).putAll((Object)Resource.K8S_CONTAINER.getKey(), (Object[])new Label[]{Label.GKELocation, Label.ClusterName, Label.NamespaceName, Label.PodName, Label.ContainerName}).build();
    private static final Map<String, MonitoredResource> cachedMonitoredResources = new HashMap<String, MonitoredResource>();
    private static ResourceTypeEnvironmentGetter getter = new ResourceTypeEnvironmentGetterImpl();
    private static MetadataLoader metadataLoader = new MetadataLoader(getter);

    private MonitoredResourceUtil() {
    }

    protected static void setEnvironmentGetter(ResourceTypeEnvironmentGetter getter) {
        MonitoredResourceUtil.getter = getter;
        metadataLoader = new MetadataLoader(getter);
    }

    public static MonitoredResource getResource(String projectId, String resourceType) {
        MonitoredResource result;
        if (projectId == null || projectId.trim().isEmpty()) {
            projectId = metadataLoader.getValue(Label.ProjectId);
        }
        if ((result = cachedMonitoredResources.get(projectId + "/" + resourceType)) != null) {
            return result;
        }
        if (Strings.isNullOrEmpty((String)resourceType)) {
            Resource detectedResourceType = MonitoredResourceUtil.detectResourceType();
            resourceType = detectedResourceType.getKey();
        }
        MonitoredResource.Builder builder = MonitoredResource.newBuilder((String)resourceType).addLabel(Label.ProjectId.getKey(), projectId);
        for (Label label : RESOURCE_TYPE_WITH_LABELS.get((Object)resourceType)) {
            String value = metadataLoader.getValue(label);
            if (value == null) continue;
            builder.addLabel(label.getKey(), value);
        }
        result = builder.build();
        cachedMonitoredResources.put(projectId + "/" + resourceType, result);
        return result;
    }

    private static Resource detectResourceType() {
        if (getter.getAttribute("") == null) {
            return Resource.GLOBAL;
        }
        if (getter.getEnv("FUNCTION_SIGNATURE_TYPE") != null && getter.getEnv("FUNCTION_TARGET") != null) {
            return Resource.CLOUD_FUNCTION;
        }
        if (getter.getEnv("K_SERVICE") != null && getter.getEnv("K_REVISION") != null && getter.getEnv("K_CONFIGURATION") != null) {
            return Resource.CLOUD_RUN;
        }
        if (getter.getEnv("GAE_INSTANCE") != null && getter.getEnv("GAE_SERVICE") != null && getter.getEnv("GAE_VERSION") != null) {
            return Resource.APP_ENGINE;
        }
        if (getter.getAttribute("instance/attributes/cluster-name") != null) {
            return Resource.K8S_CONTAINER;
        }
        if (getter.getAttribute("instance/preempted") != null && getter.getAttribute("instance/cpu-platform") != null && getter.getAttribute("instance/attributes/gae_app_bucket") == null) {
            return Resource.GCE_INSTANCE;
        }
        return Resource.GLOBAL;
    }

    public static List<LoggingEnhancer> getResourceEnhancers() {
        Resource resourceType = MonitoredResourceUtil.detectResourceType();
        return MonitoredResourceUtil.createEnhancers(resourceType);
    }

    private static List<LoggingEnhancer> createEnhancers(Resource resourceType) {
        ArrayList<LoggingEnhancer> enhancers = new ArrayList<LoggingEnhancer>(2);
        if (resourceType == Resource.APP_ENGINE) {
            enhancers.add(new TraceLoggingEnhancer(APPENGINE_LABEL_PREFIX));
            if ("flex".equals(metadataLoader.getValue(Label.Env))) {
                enhancers.add(new LabelLoggingEnhancer(APPENGINE_LABEL_PREFIX, (List<Label>)ImmutableList.of((Object)((Object)Label.InstanceName))));
            }
        }
        return enhancers;
    }

    private static class LabelLoggingEnhancer
    implements LoggingEnhancer {
        private final Map<String, String> labels = new HashMap<String, String>();

        LabelLoggingEnhancer(String prefix, List<Label> labelNames) {
            if (labelNames != null) {
                for (Label labelName : labelNames) {
                    String fullLabelName;
                    String string = fullLabelName = prefix != null ? prefix + labelName.getKey() : labelName.getKey();
                    String labelValue = metadataLoader.getValue(labelName);
                    if (labelValue == null) continue;
                    this.labels.put(fullLabelName, labelValue);
                }
            }
        }

        @Override
        public void enhanceLogEntry(LogEntry.Builder logEntry) {
            for (Map.Entry<String, String> label : this.labels.entrySet()) {
                logEntry.addLabel(label.getKey(), label.getValue());
            }
        }
    }

    private static enum Resource {
        CLOUD_RUN("cloud_run_revision"),
        CLOUD_FUNCTION("cloud_function"),
        APP_ENGINE("gae_app"),
        GCE_INSTANCE("gce_instance"),
        K8S_CONTAINER("k8s_container"),
        GLOBAL("global");

        private final String key;

        private Resource(String key) {
            this.key = key;
        }

        String getKey() {
            return this.key;
        }
    }

    protected static enum Label {
        ClusterName("cluster_name"),
        ConfigurationName("configuration_name"),
        ContainerName("container_name"),
        Env("env"),
        FunctionName("function_name"),
        InstanceId("instance_id"),
        InstanceName("instance_name"),
        CloudRunLocation("location"),
        GKELocation("location"),
        ModuleId("module_id"),
        NamespaceName("namespace_name"),
        PodName("pod_name"),
        ProjectId("project_id"),
        Region("region"),
        RevisionName("revision_name"),
        ServiceName("service_name"),
        VersionId("version_id"),
        Zone("zone");

        private final String key;

        private Label(String key) {
            this.key = key;
        }

        String getKey() {
            return this.key;
        }
    }
}

