/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging;

import com.google.cloud.MonitoredResource;
import com.google.cloud.logging.HttpRequest;
import com.google.cloud.logging.JavaTimeConversions;
import com.google.cloud.logging.Operation;
import com.google.cloud.logging.Payload;
import com.google.cloud.logging.Severity;
import com.google.cloud.logging.SourceLocation;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.logging.v2.LogEntry;
import com.google.logging.v2.LogEntryOperation;
import com.google.logging.v2.LogEntrySourceLocation;
import com.google.logging.v2.LogName;
import java.io.Serializable;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class LogEntry
implements Serializable {
    private static final long serialVersionUID = -944788159728228219L;
    static final Function<com.google.logging.v2.LogEntry, LogEntry> FROM_PB_FUNCTION = new Function<com.google.logging.v2.LogEntry, LogEntry>(){

        public LogEntry apply(com.google.logging.v2.LogEntry pb) {
            return LogEntry.fromPb(pb);
        }
    };
    private final String logName;
    private final MonitoredResource resource;
    private final Instant timestamp;
    private final Instant receiveTimestamp;
    private final Severity severity;
    private final String insertId;
    private final HttpRequest httpRequest;
    private final Map<String, String> labels;
    private final Operation operation;
    private final Object trace;
    private final Object spanId;
    private final boolean traceSampled;
    private final SourceLocation sourceLocation;
    private final Payload<?> payload;

    LogEntry(Builder builder) {
        this.logName = builder.logName;
        this.resource = builder.resource;
        this.timestamp = builder.timestamp;
        this.receiveTimestamp = builder.receiveTimestamp;
        this.severity = builder.severity;
        this.insertId = builder.insertId;
        this.httpRequest = builder.httpRequest;
        this.labels = ImmutableMap.copyOf((Map)builder.labels);
        this.operation = builder.operation;
        this.trace = builder.trace;
        this.spanId = builder.spanId;
        this.traceSampled = builder.traceSampled;
        this.sourceLocation = builder.sourceLocation;
        this.payload = builder.payload;
    }

    public String getLogName() {
        return this.logName;
    }

    public MonitoredResource getResource() {
        return this.resource;
    }

    @Deprecated
    public Long getTimestamp() {
        return this.timestamp != null ? Long.valueOf(this.timestamp.toEpochMilli()) : null;
    }

    public Instant getInstantTimestamp() {
        return this.timestamp;
    }

    @Deprecated
    public Long getReceiveTimestamp() {
        return this.receiveTimestamp != null ? Long.valueOf(this.receiveTimestamp.toEpochMilli()) : null;
    }

    public Instant getInstantReceiveTimestamp() {
        return this.receiveTimestamp;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getInsertId() {
        return this.insertId;
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public String getTrace() {
        return this.trace == null ? null : String.valueOf(this.trace);
    }

    public String getSpanId() {
        return this.spanId == null ? null : String.valueOf(this.spanId);
    }

    public boolean getTraceSampled() {
        return this.traceSampled;
    }

    public SourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    public <T extends Payload> T getPayload() {
        return (T)this.payload;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.logName, this.resource, this.timestamp, this.receiveTimestamp, this.severity, this.insertId, this.httpRequest, this.labels, this.operation, this.getTrace(), this.getSpanId(), this.traceSampled, this.sourceLocation, this.payload});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LogEntry)) {
            return false;
        }
        LogEntry other = (LogEntry)obj;
        return Objects.equals(this.logName, other.logName) && Objects.equals(this.resource, other.resource) && Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.receiveTimestamp, other.receiveTimestamp) && Objects.equals((Object)this.severity, (Object)other.severity) && Objects.equals(this.insertId, other.insertId) && Objects.equals(this.httpRequest, other.httpRequest) && Objects.equals(this.labels, other.labels) && Objects.equals(this.operation, other.operation) && Objects.equals(this.getTrace(), other.getTrace()) && Objects.equals(this.getSpanId(), other.getSpanId()) && Objects.equals(this.traceSampled, other.traceSampled) && Objects.equals(this.sourceLocation, other.sourceLocation) && Objects.equals(this.payload, other.payload);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("logName", (Object)this.logName).add("resource", (Object)this.resource).add("timestamp", (Object)this.timestamp).add("receiveTimestamp", (Object)this.receiveTimestamp).add("severity", (Object)this.severity).add("insertId", (Object)this.insertId).add("httpRequest", (Object)this.httpRequest).add("labels", this.labels).add("operation", (Object)this.operation).add("trace", this.trace).add("spanId", this.spanId).add("traceSampled", this.traceSampled).add("sourceLocation", (Object)this.sourceLocation).add("payload", this.payload).toString();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    com.google.logging.v2.LogEntry toPb(String projectId) {
        LogEntry.Builder builder = this.payload.toPb();
        builder.putAllLabels(this.labels);
        if (this.logName != null) {
            builder.setLogName(LogName.ofProjectLogName((String)projectId, (String)this.logName).toString());
        }
        if (this.resource != null) {
            builder.setResource(this.resource.toPb());
        }
        if (this.timestamp != null) {
            builder.setTimestamp(JavaTimeConversions.toProtoTimestamp(this.timestamp));
        }
        if (this.receiveTimestamp != null) {
            builder.setReceiveTimestamp(JavaTimeConversions.toProtoTimestamp(this.receiveTimestamp));
        }
        if (this.severity != null) {
            builder.setSeverity(this.severity.toPb());
        }
        if (this.insertId != null) {
            builder.setInsertId(this.insertId);
        }
        if (this.httpRequest != null) {
            builder.setHttpRequest(this.httpRequest.toPb());
        }
        if (this.operation != null) {
            builder.setOperation(this.operation.toPb());
        }
        if (this.trace != null) {
            builder.setTrace(this.getTrace());
        }
        if (this.spanId != null) {
            builder.setSpanId(this.getSpanId());
        }
        builder.setTraceSampled(this.traceSampled);
        if (this.sourceLocation != null) {
            builder.setSourceLocation(this.sourceLocation.toPb());
        }
        return builder.build();
    }

    public static Builder newBuilder(Payload<?> payload) {
        return new Builder(payload);
    }

    public static LogEntry of(Payload<?> payload) {
        return LogEntry.newBuilder(payload).build();
    }

    public static LogEntry of(String logName, MonitoredResource resource, Payload<?> payload) {
        return LogEntry.newBuilder(payload).setLogName(logName).setResource(resource).build();
    }

    static LogEntry fromPb(com.google.logging.v2.LogEntry entryPb) {
        Builder builder = LogEntry.newBuilder(Payload.fromPb(entryPb));
        builder.setLabels(entryPb.getLabelsMap());
        builder.setSeverity(Severity.fromPb(entryPb.getSeverity()));
        if (!entryPb.getLogName().equals("")) {
            builder.setLogName(LogName.parse((String)entryPb.getLogName()).getLog());
        }
        if (!entryPb.getResource().equals((Object)com.google.api.MonitoredResource.getDefaultInstance())) {
            builder.setResource(MonitoredResource.fromPb((com.google.api.MonitoredResource)entryPb.getResource()));
        }
        if (entryPb.hasTimestamp()) {
            builder.setTimestamp(JavaTimeConversions.toJavaInstant(entryPb.getTimestamp()));
        }
        if (entryPb.hasReceiveTimestamp()) {
            builder.setReceiveTimestamp(JavaTimeConversions.toJavaInstant(entryPb.getReceiveTimestamp()));
        }
        if (!entryPb.getInsertId().equals("")) {
            builder.setInsertId(entryPb.getInsertId());
        }
        if (!entryPb.getHttpRequest().equals((Object)com.google.logging.type.HttpRequest.getDefaultInstance())) {
            builder.setHttpRequest(HttpRequest.fromPb(entryPb.getHttpRequest()));
        }
        if (!entryPb.getOperation().equals((Object)LogEntryOperation.getDefaultInstance())) {
            builder.setOperation(Operation.fromPb(entryPb.getOperation()));
        }
        if (!entryPb.getTrace().equals("")) {
            builder.setTrace(entryPb.getTrace());
        }
        if (!entryPb.getSpanId().equals("")) {
            builder.setSpanId(entryPb.getSpanId());
        }
        builder.setTraceSampled(entryPb.getTraceSampled());
        if (!entryPb.getSourceLocation().equals((Object)LogEntrySourceLocation.getDefaultInstance())) {
            builder.setSourceLocation(SourceLocation.fromPb(entryPb.getSourceLocation()));
        }
        return builder.build();
    }

    static Function<LogEntry, com.google.logging.v2.LogEntry> toPbFunction(final String projectId) {
        return new Function<LogEntry, com.google.logging.v2.LogEntry>(){

            public com.google.logging.v2.LogEntry apply(LogEntry entry) {
                return entry.toPb(projectId);
            }
        };
    }

    public static class Builder {
        private String logName;
        private MonitoredResource resource;
        private Instant timestamp;
        private Instant receiveTimestamp;
        private Severity severity = Severity.DEFAULT;
        private String insertId;
        private HttpRequest httpRequest;
        private Map<String, String> labels = new HashMap<String, String>();
        private Operation operation;
        private Object trace;
        private Object spanId;
        private boolean traceSampled;
        private SourceLocation sourceLocation;
        private Payload<?> payload;

        Builder(Payload<?> payload) {
            this.payload = payload;
        }

        Builder(LogEntry entry) {
            this.logName = entry.logName;
            this.resource = entry.resource;
            this.timestamp = entry.timestamp;
            this.receiveTimestamp = entry.receiveTimestamp;
            this.severity = entry.severity;
            this.insertId = entry.insertId;
            this.httpRequest = entry.httpRequest;
            this.labels = new HashMap<String, String>(entry.labels);
            this.operation = entry.operation;
            this.trace = entry.trace;
            this.spanId = entry.spanId;
            this.traceSampled = entry.traceSampled;
            this.sourceLocation = entry.sourceLocation;
            this.payload = entry.payload;
        }

        public Builder setLogName(String logName) {
            this.logName = logName;
            return this;
        }

        public Builder setResource(MonitoredResource resource) {
            this.resource = resource;
            return this;
        }

        @Deprecated
        public Builder setTimestamp(long milliseconds) {
            this.timestamp = Instant.ofEpochMilli(milliseconds);
            return this;
        }

        public Builder setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Deprecated
        public Builder setReceiveTimestamp(long milliseconds) {
            this.receiveTimestamp = Instant.ofEpochMilli(milliseconds);
            return this;
        }

        public Builder setReceiveTimestamp(Instant receiveTimestamp) {
            this.receiveTimestamp = receiveTimestamp;
            return this;
        }

        public Builder setSeverity(Severity severity) {
            this.severity = severity;
            return this;
        }

        public Builder setInsertId(String insertId) {
            this.insertId = insertId;
            return this;
        }

        public Builder setHttpRequest(HttpRequest httpRequest) {
            this.httpRequest = httpRequest;
            return this;
        }

        public Builder setLabels(Map<String, String> labels) {
            this.labels = new HashMap<String, String>((Map)Preconditions.checkNotNull(labels));
            return this;
        }

        public Builder addLabel(String key, String value) {
            this.labels.put(key, value);
            return this;
        }

        public Builder clearLabels() {
            this.labels.clear();
            return this;
        }

        public Builder setOperation(Operation operation) {
            this.operation = operation;
            return this;
        }

        public Builder setTrace(String trace) {
            this.trace = trace;
            return this;
        }

        public Builder setTrace(Object trace) {
            this.trace = trace;
            return this;
        }

        public Builder setSpanId(String spanId) {
            this.spanId = spanId;
            return this;
        }

        public Builder setSpanId(Object spanId) {
            this.spanId = spanId;
            return this;
        }

        public Builder setTraceSampled(boolean traceSampled) {
            this.traceSampled = traceSampled;
            return this;
        }

        public Builder setSourceLocation(SourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }

        public Builder setPayload(Payload payload) {
            this.payload = payload;
            return this;
        }

        public LogEntry build() {
            return new LogEntry(this);
        }
    }
}

