/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging;

import com.google.cloud.MetadataConfig;
import com.google.cloud.MonitoredResource;
import com.google.cloud.ServiceOptions;
import com.google.cloud.logging.LogEntry;
import com.google.cloud.logging.LoggingEnhancer;
import com.google.cloud.logging.LoggingException;
import com.google.cloud.logging.TraceLoggingEnhancer;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMultimap;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MonitoredResourceUtil {
    private static final String APPENGINE_LABEL_PREFIX = "appengine.googleapis.com/";
    private static ImmutableMultimap<String, Label> resourceTypeWithLabels = ImmutableMultimap.builder().putAll((Object)Resource.Container.getKey(), (Object[])new Label[]{Label.ClusterName, Label.ContainerName, Label.InstanceId, Label.NamespaceId, Label.PodId, Label.Zone}).putAll((Object)Resource.CloudRun.getKey(), (Object[])new Label[]{Label.RevisionName, Label.ServiceName, Label.Location}).putAll((Object)Resource.GaeAppFlex.getKey(), (Object[])new Label[]{Label.ModuleId, Label.VersionId, Label.Zone}).putAll((Object)Resource.GaeAppStandard.getKey(), (Object[])new Label[]{Label.ModuleId, Label.VersionId}).putAll((Object)Resource.GceInstance.getKey(), (Object[])new Label[]{Label.InstanceId, Label.Zone}).putAll((Object)Resource.K8sContainer.getKey(), (Object[])new Label[]{Label.Location, Label.ClusterName, Label.NamespaceName, Label.PodName, Label.ContainerName}).build();

    private MonitoredResourceUtil() {
    }

    public static MonitoredResource getResource(String projectId, String resourceTypeParam) {
        String resourceType = resourceTypeParam;
        if (Strings.isNullOrEmpty((String)resourceType)) {
            Resource detectedResourceType = MonitoredResourceUtil.getAutoDetectedResourceType();
            resourceType = detectedResourceType.getKey();
        }
        String resourceName = resourceType.startsWith("gae_app") ? "gae_app" : resourceType;
        MonitoredResource.Builder builder = MonitoredResource.newBuilder((String)resourceName).addLabel(Label.ProjectId.getKey(), projectId);
        for (Label label : resourceTypeWithLabels.get((Object)resourceType)) {
            String value = MonitoredResourceUtil.getValue(label, resourceType);
            if (value == null) continue;
            builder.addLabel(label.getKey(), value);
        }
        return builder.build();
    }

    public static List<LoggingEnhancer> getResourceEnhancers() {
        Resource resourceType = MonitoredResourceUtil.getAutoDetectedResourceType();
        return MonitoredResourceUtil.createEnhancers(resourceType);
    }

    private static String getValue(Label label, String resourceType) {
        String value;
        switch (label) {
            case AppId: {
                value = ServiceOptions.getAppEngineAppId();
                break;
            }
            case ClusterName: {
                value = MetadataConfig.getClusterName();
                break;
            }
            case ContainerName: {
                if (resourceType.equals("k8s_container")) {
                    String hostName = System.getenv("HOSTNAME");
                    value = hostName.substring(0, hostName.indexOf("-"));
                    break;
                }
                value = MetadataConfig.getContainerName();
                break;
            }
            case InstanceId: {
                value = MetadataConfig.getInstanceId();
                break;
            }
            case InstanceName: {
                value = MonitoredResourceUtil.getAppEngineInstanceName();
                break;
            }
            case Location: {
                value = MonitoredResourceUtil.getCloudRunLocation();
                break;
            }
            case ModuleId: {
                value = MonitoredResourceUtil.getAppEngineModuleId();
                break;
            }
            case NamespaceId: {
                value = MetadataConfig.getNamespaceId();
                break;
            }
            case NamespaceName: {
                String filePath = System.getenv("KUBERNETES_NAMESPACE_FILE");
                if (filePath == null) {
                    filePath = "/var/run/secrets/kubernetes.io/serviceaccount/namespace";
                }
                try {
                    value = new String(Files.readAllBytes(Paths.get(filePath, new String[0])), StandardCharsets.UTF_8);
                    break;
                }
                catch (IOException e) {
                    throw new LoggingException(e, true);
                }
            }
            case PodName: 
            case PodId: {
                value = System.getenv("HOSTNAME");
                break;
            }
            case RevisionName: {
                value = System.getenv("K_REVISION");
                break;
            }
            case ServiceName: {
                value = System.getenv("K_SERVICE");
                break;
            }
            case VersionId: {
                value = MonitoredResourceUtil.getAppEngineVersionId();
                break;
            }
            case Zone: {
                value = MetadataConfig.getZone();
                break;
            }
            default: {
                value = null;
            }
        }
        return value;
    }

    private static Resource getAutoDetectedResourceType() {
        if (System.getenv("K_SERVICE") != null && System.getenv("K_REVISION") != null && System.getenv("K_CONFIGURATION") != null && System.getenv("KUBERNETES_SERVICE_HOST") == null) {
            return Resource.CloudRun;
        }
        if (System.getenv("GAE_INSTANCE") != null) {
            return Resource.GaeAppFlex;
        }
        if (System.getenv("KUBERNETES_SERVICE_HOST") != null) {
            return Resource.K8sContainer;
        }
        if (ServiceOptions.getAppEngineAppId() != null) {
            return Resource.GaeAppStandard;
        }
        if (MetadataConfig.getInstanceId() != null) {
            return Resource.GceInstance;
        }
        return Resource.Global;
    }

    private static String getAppEngineModuleId() {
        return System.getenv("GAE_SERVICE");
    }

    private static String getAppEngineVersionId() {
        return System.getenv("GAE_VERSION");
    }

    private static String getAppEngineInstanceName() {
        return System.getenv("GAE_INSTANCE");
    }

    private static String getCloudRunLocation() {
        String zone = MetadataConfig.getZone();
        if (zone.endsWith("-1")) {
            return zone.substring(0, zone.length() - 2);
        }
        return zone;
    }

    private static List<LoggingEnhancer> createEnhancers(Resource resourceType) {
        ArrayList<LoggingEnhancer> enhancers = new ArrayList<LoggingEnhancer>(2);
        switch (resourceType) {
            case GaeAppFlex: {
                enhancers.add(new LabelLoggingEnhancer(APPENGINE_LABEL_PREFIX, Collections.singletonList(Label.InstanceName)));
                enhancers.add(new TraceLoggingEnhancer(APPENGINE_LABEL_PREFIX));
                break;
            }
            case GaeAppStandard: {
                enhancers.add(new TraceLoggingEnhancer(APPENGINE_LABEL_PREFIX));
                break;
            }
        }
        return enhancers;
    }

    private static class LabelLoggingEnhancer
    implements LoggingEnhancer {
        private final Map<String, String> labels = new HashMap<String, String>();

        LabelLoggingEnhancer(String prefix, List<Label> labelNames) {
            if (labelNames != null) {
                for (Label labelName : labelNames) {
                    String fullLabelName;
                    String labelValue = MonitoredResourceUtil.getValue(labelName, fullLabelName = prefix != null ? prefix + labelName.getKey() : labelName.getKey());
                    if (labelValue == null) continue;
                    this.labels.put(fullLabelName, labelValue);
                }
            }
        }

        @Override
        public void enhanceLogEntry(LogEntry.Builder logEntry) {
            for (Map.Entry<String, String> label : this.labels.entrySet()) {
                logEntry.addLabel(label.getKey(), label.getValue());
            }
        }
    }

    private static enum Resource {
        CloudRun("cloud_run_revision"),
        Container("container"),
        GaeAppFlex("gae_app_flex"),
        GaeAppStandard("gae_app_standard"),
        GceInstance("gce_instance"),
        K8sContainer("k8s_container"),
        Global("global");

        private final String key;

        private Resource(String key) {
            this.key = key;
        }

        String getKey() {
            return this.key;
        }
    }

    private static enum Label {
        AppId("app_id"),
        ClusterName("cluster_name"),
        ContainerName("container_name"),
        InstanceId("instance_id"),
        InstanceName("instance_name"),
        Location("location"),
        ModuleId("module_id"),
        NamespaceId("namespace_id"),
        NamespaceName("namespace_name"),
        PodId("pod_id"),
        PodName("pod_name"),
        ProjectId("project_id"),
        RevisionName("revision_name"),
        ServiceName("service_name"),
        VersionId("version_id"),
        Zone("zone");

        private final String key;

        private Label(String key) {
            this.key = key;
        }

        String getKey() {
            return this.key;
        }
    }
}

