/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging;

import com.google.cloud.logging.Option;
import com.google.common.base.Preconditions;
import com.google.logging.v2.LogName;
import java.util.Map;

public final class LogDestinationName
extends Option {
    private LogDestinationName(Option.OptionType option, Object value) {
        super(option, value);
        Preconditions.checkArgument((!Preconditions.checkNotNull((Object)value).toString().trim().isEmpty() ? 1 : 0) != 0);
    }

    public static LogDestinationName project(String id) {
        return new LogDestinationName(DestinationType.PROJECT, id);
    }

    public static LogDestinationName folder(String id) {
        return new LogDestinationName(DestinationType.FOLDER, id);
    }

    public static LogDestinationName organization(String id) {
        return new LogDestinationName(DestinationType.ORGANIZATION, id);
    }

    public static LogDestinationName billingAccount(String id) {
        return new LogDestinationName(DestinationType.BILLINGACCOUNT, id);
    }

    public LogName toLogName(String logId) {
        if (logId == null) {
            return null;
        }
        switch ((DestinationType)this.getOptionType()) {
            case PROJECT: {
                return LogName.ofProjectLogName((String)this.getValue().toString(), (String)logId);
            }
            case FOLDER: {
                return LogName.ofFolderLogName((String)this.getValue().toString(), (String)logId);
            }
            case ORGANIZATION: {
                return LogName.ofOrganizationLogName((String)this.getValue().toString(), (String)logId);
            }
            case BILLINGACCOUNT: {
                return LogName.ofBillingAccountLogName((String)this.getValue().toString(), (String)logId);
            }
        }
        return null;
    }

    public static LogDestinationName fromLogName(LogName logName) {
        if (logName == null) {
            return null;
        }
        if (logName.getProject() != null) {
            return LogDestinationName.project(logName.getProject());
        }
        if (logName.getBillingAccount() != null) {
            return LogDestinationName.billingAccount(logName.getBillingAccount());
        }
        if (logName.getFolder() != null) {
            return LogDestinationName.folder(logName.getFolder());
        }
        if (logName.getOrganization() != null) {
            return LogDestinationName.organization(logName.getOrganization());
        }
        return null;
    }

    static enum DestinationType implements Option.OptionType
    {
        PROJECT,
        FOLDER,
        ORGANIZATION,
        BILLINGACCOUNT;


        <T> T get(Map<Option.OptionType, ?> options) {
            return (T)options.get(this);
        }
    }
}

