/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging;

import com.google.cloud.logging.HttpRequest;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import java.util.Objects;

public class Context {
    private final HttpRequest request;
    private final String traceId;
    private final String spanId;

    Context(Builder builder) {
        HttpRequest request = builder.requestBuilder.build();
        this.request = !HttpRequest.EMPTY.equals(request) ? request : null;
        this.traceId = builder.traceId;
        this.spanId = builder.spanId;
    }

    public HttpRequest getHttpRequest() {
        return this.request;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public String getSpanId() {
        return this.spanId;
    }

    public int hashCode() {
        return Objects.hash(this.request, this.traceId, this.spanId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("request", (Object)this.request).add("traceId", (Object)this.traceId).add("spanId", (Object)this.spanId).toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Context)) {
            return false;
        }
        Context other = (Context)obj;
        return Objects.equals(this.request, other.request) && Objects.equals(this.traceId, other.traceId) && Objects.equals(this.spanId, other.spanId);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private HttpRequest.Builder requestBuilder = HttpRequest.newBuilder();
        private String traceId;
        private String spanId;

        Builder() {
        }

        Builder(Context context) {
            this.requestBuilder = context.request.toBuilder();
            this.traceId = context.traceId;
            this.spanId = context.spanId;
        }

        public Builder setRequest(HttpRequest request) {
            this.requestBuilder = request.toBuilder();
            return this;
        }

        public Builder setRequestUrl(String url) {
            this.requestBuilder.setRequestUrl(url);
            return this;
        }

        public Builder setRequestMethod(HttpRequest.RequestMethod method) {
            this.requestBuilder.setRequestMethod(method);
            return this;
        }

        public Builder setReferer(String referer) {
            this.requestBuilder.setReferer(referer);
            return this;
        }

        public Builder setRemoteIp(String remoteIp) {
            this.requestBuilder.setRemoteIp(remoteIp);
            return this;
        }

        public Builder setServerIp(String serverIp) {
            this.requestBuilder.setServerIp(serverIp);
            return this;
        }

        public Builder setTraceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        public Builder setSpanId(String spanId) {
            this.spanId = spanId;
            return this;
        }

        public Builder loadCloudTraceContext(String cloudTrace) {
            if (cloudTrace != null) {
                int split = (cloudTrace = cloudTrace.split(";")[0]).indexOf(47);
                if (split >= 0) {
                    String traceId = cloudTrace.substring(0, split);
                    String spanId = cloudTrace.substring(split + 1);
                    if (!traceId.isEmpty()) {
                        this.setTraceId(traceId);
                        if (!spanId.isEmpty()) {
                            this.setSpanId(spanId);
                        }
                    }
                } else if (!cloudTrace.isEmpty()) {
                    this.setTraceId(cloudTrace);
                }
            }
            return this;
        }

        public Builder loadW3CTraceParentContext(String traceParent) throws IllegalArgumentException {
            if (traceParent != null) {
                String spanId;
                String[] fields = traceParent.split("-");
                if (fields.length > 3) {
                    String versionFormat = fields[0];
                    if (!versionFormat.equals("00")) {
                        throw new IllegalArgumentException("Not supporting versionFormat other than \"00\"");
                    }
                } else {
                    throw new IllegalArgumentException("Invalid format of the header value. Expected \"00-traceid-spanid-arguments\"");
                }
                String traceId = fields[1];
                if (!traceId.isEmpty()) {
                    this.setTraceId(traceId);
                }
                if (!Strings.isNullOrEmpty((String)traceId) && !(spanId = fields[2]).isEmpty()) {
                    this.setSpanId(spanId);
                }
            }
            return this;
        }

        public Context build() {
            return new Context(this);
        }
    }
}

