/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.logging;

import com.google.cloud.logging.HttpRequest;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Context {
    private static final Pattern W3C_TRACE_CONTEXT_FORMAT = Pattern.compile("^00-(?!00000000000000000000000000000000)[0-9a-f]{32}-(?!0000000000000000)[0-9a-f]{16}-[0-9a-f]{2}$");
    private final HttpRequest request;
    private final String traceId;
    private final String spanId;

    Context(Builder builder) {
        HttpRequest request = builder.requestBuilder.build();
        this.request = !HttpRequest.EMPTY.equals(request) ? request : null;
        this.traceId = builder.traceId;
        this.spanId = builder.spanId;
    }

    public HttpRequest getHttpRequest() {
        return this.request;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public String getSpanId() {
        return this.spanId;
    }

    public int hashCode() {
        return Objects.hash(this.request, this.traceId, this.spanId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("request", (Object)this.request).add("traceId", (Object)this.traceId).add("spanId", (Object)this.spanId).toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Context)) {
            return false;
        }
        Context other = (Context)obj;
        return Objects.equals(this.request, other.request) && Objects.equals(this.traceId, other.traceId) && Objects.equals(this.spanId, other.spanId);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private HttpRequest.Builder requestBuilder = HttpRequest.newBuilder();
        private String traceId;
        private String spanId;

        Builder() {
        }

        Builder(Context context) {
            this.requestBuilder = context.request.toBuilder();
            this.traceId = context.traceId;
            this.spanId = context.spanId;
        }

        public Builder setRequest(HttpRequest request) {
            this.requestBuilder = request.toBuilder();
            return this;
        }

        public Builder setRequestUrl(String url) {
            this.requestBuilder.setRequestUrl(url);
            return this;
        }

        public Builder setRequestMethod(HttpRequest.RequestMethod method) {
            this.requestBuilder.setRequestMethod(method);
            return this;
        }

        public Builder setReferer(String referer) {
            this.requestBuilder.setReferer(referer);
            return this;
        }

        public Builder setRemoteIp(String remoteIp) {
            this.requestBuilder.setRemoteIp(remoteIp);
            return this;
        }

        public Builder setServerIp(String serverIp) {
            this.requestBuilder.setServerIp(serverIp);
            return this;
        }

        public Builder setTraceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        public Builder setSpanId(String spanId) {
            this.spanId = spanId;
            return this;
        }

        public Builder loadCloudTraceContext(String cloudTrace) {
            if (cloudTrace != null) {
                int split = (cloudTrace = cloudTrace.split(";")[0]).indexOf(47);
                if (split >= 0) {
                    String traceId = cloudTrace.substring(0, split);
                    String spanId = cloudTrace.substring(split + 1);
                    if (!traceId.isEmpty()) {
                        this.setTraceId(traceId);
                        if (!spanId.isEmpty()) {
                            this.setSpanId(spanId);
                        }
                    }
                } else if (!cloudTrace.isEmpty()) {
                    this.setTraceId(cloudTrace);
                }
            }
            return this;
        }

        public Builder loadW3CTraceParentContext(String traceParent) throws IllegalArgumentException {
            if (traceParent != null) {
                Matcher validator = W3C_TRACE_CONTEXT_FORMAT.matcher(traceParent.toLowerCase());
                if (!validator.matches()) {
                    throw new IllegalArgumentException("Invalid format of the header value. The value does not match W3C Trace Context version \"00\"");
                }
                String[] fields = traceParent.split("-");
                this.setTraceId(fields[1]);
                this.setSpanId(fields[2]);
            }
            return this;
        }

        public Context build() {
            return new Context(this);
        }
    }
}

