/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.monitoring.dashboard.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.monitoring.dashboard.v1.DashboardsServiceClient;
import com.google.cloud.monitoring.dashboard.v1.stub.DashboardsServiceStub;
import com.google.cloud.monitoring.dashboard.v1.stub.DashboardsServiceStubSettings;
import com.google.cloud.monitoring.dashboard.v1.stub.HttpJsonDashboardsServiceCallableFactory;
import com.google.monitoring.dashboard.v1.CreateDashboardRequest;
import com.google.monitoring.dashboard.v1.Dashboard;
import com.google.monitoring.dashboard.v1.DeleteDashboardRequest;
import com.google.monitoring.dashboard.v1.GetDashboardRequest;
import com.google.monitoring.dashboard.v1.ListDashboardsRequest;
import com.google.monitoring.dashboard.v1.ListDashboardsResponse;
import com.google.monitoring.dashboard.v1.UpdateDashboardRequest;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonDashboardsServiceStub
extends DashboardsServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<CreateDashboardRequest, Dashboard> createDashboardMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.monitoring.dashboard.v1.DashboardsService/CreateDashboard").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*}/dashboards", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("dashboard", (Message)request.getDashboard(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Dashboard.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListDashboardsRequest, ListDashboardsResponse> listDashboardsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.monitoring.dashboard.v1.DashboardsService/ListDashboards").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*}/dashboards", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListDashboardsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetDashboardRequest, Dashboard> getDashboardMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.monitoring.dashboard.v1.DashboardsService/GetDashboard").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/dashboards/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Dashboard.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteDashboardRequest, Empty> deleteDashboardMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.monitoring.dashboard.v1.DashboardsService/DeleteDashboard").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/dashboards/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateDashboardRequest, Dashboard> updateDashboardMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.monitoring.dashboard.v1.DashboardsService/UpdateDashboard").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{dashboard.name=projects/*/dashboards/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "dashboard.name", (Object)request.getDashboard().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "validateOnly", (Object)request.getValidateOnly());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("dashboard", (Message)request.getDashboard(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Dashboard.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateDashboardRequest, Dashboard> createDashboardCallable;
    private final UnaryCallable<ListDashboardsRequest, ListDashboardsResponse> listDashboardsCallable;
    private final UnaryCallable<ListDashboardsRequest, DashboardsServiceClient.ListDashboardsPagedResponse> listDashboardsPagedCallable;
    private final UnaryCallable<GetDashboardRequest, Dashboard> getDashboardCallable;
    private final UnaryCallable<DeleteDashboardRequest, Empty> deleteDashboardCallable;
    private final UnaryCallable<UpdateDashboardRequest, Dashboard> updateDashboardCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonDashboardsServiceStub create(DashboardsServiceStubSettings settings) throws IOException {
        return new HttpJsonDashboardsServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonDashboardsServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonDashboardsServiceStub(DashboardsServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonDashboardsServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonDashboardsServiceStub(DashboardsServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonDashboardsServiceStub(DashboardsServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonDashboardsServiceCallableFactory());
    }

    protected HttpJsonDashboardsServiceStub(DashboardsServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings createDashboardTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createDashboardMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listDashboardsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listDashboardsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getDashboardTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getDashboardMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteDashboardTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteDashboardMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateDashboardTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateDashboardMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("dashboard.name", String.valueOf(request.getDashboard().getName()));
            return builder.build();
        }).build();
        this.createDashboardCallable = callableFactory.createUnaryCallable(createDashboardTransportSettings, settings.createDashboardSettings(), clientContext);
        this.listDashboardsCallable = callableFactory.createUnaryCallable(listDashboardsTransportSettings, settings.listDashboardsSettings(), clientContext);
        this.listDashboardsPagedCallable = callableFactory.createPagedCallable(listDashboardsTransportSettings, settings.listDashboardsSettings(), clientContext);
        this.getDashboardCallable = callableFactory.createUnaryCallable(getDashboardTransportSettings, settings.getDashboardSettings(), clientContext);
        this.deleteDashboardCallable = callableFactory.createUnaryCallable(deleteDashboardTransportSettings, settings.deleteDashboardSettings(), clientContext);
        this.updateDashboardCallable = callableFactory.createUnaryCallable(updateDashboardTransportSettings, settings.updateDashboardSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createDashboardMethodDescriptor);
        methodDescriptors.add(listDashboardsMethodDescriptor);
        methodDescriptors.add(getDashboardMethodDescriptor);
        methodDescriptors.add(deleteDashboardMethodDescriptor);
        methodDescriptors.add(updateDashboardMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<CreateDashboardRequest, Dashboard> createDashboardCallable() {
        return this.createDashboardCallable;
    }

    @Override
    public UnaryCallable<ListDashboardsRequest, ListDashboardsResponse> listDashboardsCallable() {
        return this.listDashboardsCallable;
    }

    @Override
    public UnaryCallable<ListDashboardsRequest, DashboardsServiceClient.ListDashboardsPagedResponse> listDashboardsPagedCallable() {
        return this.listDashboardsPagedCallable;
    }

    @Override
    public UnaryCallable<GetDashboardRequest, Dashboard> getDashboardCallable() {
        return this.getDashboardCallable;
    }

    @Override
    public UnaryCallable<DeleteDashboardRequest, Empty> deleteDashboardCallable() {
        return this.deleteDashboardCallable;
    }

    @Override
    public UnaryCallable<UpdateDashboardRequest, Dashboard> updateDashboardCallable() {
        return this.updateDashboardCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

