/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.monitoring.dashboard.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.monitoring.dashboard.v1.DashboardsServiceClient;
import com.google.cloud.monitoring.dashboard.v1.stub.DashboardsServiceStub;
import com.google.cloud.monitoring.dashboard.v1.stub.GrpcDashboardsServiceStub;
import com.google.cloud.monitoring.dashboard.v1.stub.HttpJsonDashboardsServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.monitoring.dashboard.v1.CreateDashboardRequest;
import com.google.monitoring.dashboard.v1.Dashboard;
import com.google.monitoring.dashboard.v1.DeleteDashboardRequest;
import com.google.monitoring.dashboard.v1.GetDashboardRequest;
import com.google.monitoring.dashboard.v1.ListDashboardsRequest;
import com.google.monitoring.dashboard.v1.ListDashboardsResponse;
import com.google.monitoring.dashboard.v1.UpdateDashboardRequest;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class DashboardsServiceStubSettings
extends StubSettings<DashboardsServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/monitoring").add((Object)"https://www.googleapis.com/auth/monitoring.read").add((Object)"https://www.googleapis.com/auth/monitoring.write").build();
    private final UnaryCallSettings<CreateDashboardRequest, Dashboard> createDashboardSettings;
    private final PagedCallSettings<ListDashboardsRequest, ListDashboardsResponse, DashboardsServiceClient.ListDashboardsPagedResponse> listDashboardsSettings;
    private final UnaryCallSettings<GetDashboardRequest, Dashboard> getDashboardSettings;
    private final UnaryCallSettings<DeleteDashboardRequest, Empty> deleteDashboardSettings;
    private final UnaryCallSettings<UpdateDashboardRequest, Dashboard> updateDashboardSettings;
    private static final PagedListDescriptor<ListDashboardsRequest, ListDashboardsResponse, Dashboard> LIST_DASHBOARDS_PAGE_STR_DESC = new PagedListDescriptor<ListDashboardsRequest, ListDashboardsResponse, Dashboard>(){

        public String emptyToken() {
            return "";
        }

        public ListDashboardsRequest injectToken(ListDashboardsRequest payload, String token) {
            return ListDashboardsRequest.newBuilder((ListDashboardsRequest)payload).setPageToken(token).build();
        }

        public ListDashboardsRequest injectPageSize(ListDashboardsRequest payload, int pageSize) {
            return ListDashboardsRequest.newBuilder((ListDashboardsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDashboardsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDashboardsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Dashboard> extractResources(ListDashboardsResponse payload) {
            return payload.getDashboardsList() == null ? ImmutableList.of() : payload.getDashboardsList();
        }
    };
    private static final PagedListResponseFactory<ListDashboardsRequest, ListDashboardsResponse, DashboardsServiceClient.ListDashboardsPagedResponse> LIST_DASHBOARDS_PAGE_STR_FACT = new PagedListResponseFactory<ListDashboardsRequest, ListDashboardsResponse, DashboardsServiceClient.ListDashboardsPagedResponse>(){

        public ApiFuture<DashboardsServiceClient.ListDashboardsPagedResponse> getFuturePagedResponse(UnaryCallable<ListDashboardsRequest, ListDashboardsResponse> callable, ListDashboardsRequest request, ApiCallContext context, ApiFuture<ListDashboardsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DASHBOARDS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DashboardsServiceClient.ListDashboardsPagedResponse.createAsync((PageContext<ListDashboardsRequest, ListDashboardsResponse, Dashboard>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateDashboardRequest, Dashboard> createDashboardSettings() {
        return this.createDashboardSettings;
    }

    public PagedCallSettings<ListDashboardsRequest, ListDashboardsResponse, DashboardsServiceClient.ListDashboardsPagedResponse> listDashboardsSettings() {
        return this.listDashboardsSettings;
    }

    public UnaryCallSettings<GetDashboardRequest, Dashboard> getDashboardSettings() {
        return this.getDashboardSettings;
    }

    public UnaryCallSettings<DeleteDashboardRequest, Empty> deleteDashboardSettings() {
        return this.deleteDashboardSettings;
    }

    public UnaryCallSettings<UpdateDashboardRequest, Dashboard> updateDashboardSettings() {
        return this.updateDashboardSettings;
    }

    public DashboardsServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDashboardsServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonDashboardsServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "monitoring";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "monitoring.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "monitoring.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DashboardsServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DashboardsServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DashboardsServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return DashboardsServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DashboardsServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createDashboardSettings = settingsBuilder.createDashboardSettings().build();
        this.listDashboardsSettings = settingsBuilder.listDashboardsSettings().build();
        this.getDashboardSettings = settingsBuilder.getDashboardSettings().build();
        this.deleteDashboardSettings = settingsBuilder.deleteDashboardSettings().build();
        this.updateDashboardSettings = settingsBuilder.updateDashboardSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DashboardsServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateDashboardRequest, Dashboard> createDashboardSettings;
        private final PagedCallSettings.Builder<ListDashboardsRequest, ListDashboardsResponse, DashboardsServiceClient.ListDashboardsPagedResponse> listDashboardsSettings;
        private final UnaryCallSettings.Builder<GetDashboardRequest, Dashboard> getDashboardSettings;
        private final UnaryCallSettings.Builder<DeleteDashboardRequest, Empty> deleteDashboardSettings;
        private final UnaryCallSettings.Builder<UpdateDashboardRequest, Dashboard> updateDashboardSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createDashboardSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listDashboardsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DASHBOARDS_PAGE_STR_FACT);
            this.getDashboardSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteDashboardSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateDashboardSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createDashboardSettings, this.listDashboardsSettings, this.getDashboardSettings, this.deleteDashboardSettings, this.updateDashboardSettings);
            Builder.initDefaults(this);
        }

        protected Builder(DashboardsServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createDashboardSettings = settings.createDashboardSettings.toBuilder();
            this.listDashboardsSettings = settings.listDashboardsSettings.toBuilder();
            this.getDashboardSettings = settings.getDashboardSettings.toBuilder();
            this.deleteDashboardSettings = settings.deleteDashboardSettings.toBuilder();
            this.updateDashboardSettings = settings.updateDashboardSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createDashboardSettings, this.listDashboardsSettings, this.getDashboardSettings, this.deleteDashboardSettings, this.updateDashboardSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DashboardsServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DashboardsServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DashboardsServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(DashboardsServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(DashboardsServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)DashboardsServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)DashboardsServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DashboardsServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(DashboardsServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(DashboardsServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createDashboardSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listDashboardsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getDashboardSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteDashboardSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateDashboardSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateDashboardRequest, Dashboard> createDashboardSettings() {
            return this.createDashboardSettings;
        }

        public PagedCallSettings.Builder<ListDashboardsRequest, ListDashboardsResponse, DashboardsServiceClient.ListDashboardsPagedResponse> listDashboardsSettings() {
            return this.listDashboardsSettings;
        }

        public UnaryCallSettings.Builder<GetDashboardRequest, Dashboard> getDashboardSettings() {
            return this.getDashboardSettings;
        }

        public UnaryCallSettings.Builder<DeleteDashboardRequest, Empty> deleteDashboardSettings() {
            return this.deleteDashboardSettings;
        }

        public UnaryCallSettings.Builder<UpdateDashboardRequest, Dashboard> updateDashboardSettings() {
            return this.updateDashboardSettings;
        }

        public DashboardsServiceStubSettings build() throws IOException {
            return new DashboardsServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.UNKNOWN})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)30000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)30000L)).setTotalTimeout(Duration.ofMillis((long)30000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)30000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)30000L)).setTotalTimeout(Duration.ofMillis((long)30000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

