/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.monitoring.dashboard.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.monitoring.dashboard.v1.DashboardsServiceSettings;
import com.google.cloud.monitoring.dashboard.v1.stub.DashboardsServiceStub;
import com.google.cloud.monitoring.dashboard.v1.stub.DashboardsServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.monitoring.dashboard.v1.CreateDashboardRequest;
import com.google.monitoring.dashboard.v1.Dashboard;
import com.google.monitoring.dashboard.v1.DashboardName;
import com.google.monitoring.dashboard.v1.DeleteDashboardRequest;
import com.google.monitoring.dashboard.v1.GetDashboardRequest;
import com.google.monitoring.dashboard.v1.ListDashboardsRequest;
import com.google.monitoring.dashboard.v1.ListDashboardsResponse;
import com.google.monitoring.dashboard.v1.ProjectName;
import com.google.monitoring.dashboard.v1.UpdateDashboardRequest;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class DashboardsServiceClient
implements BackgroundResource {
    private final DashboardsServiceSettings settings;
    private final DashboardsServiceStub stub;

    public static final DashboardsServiceClient create() throws IOException {
        return DashboardsServiceClient.create(DashboardsServiceSettings.newBuilder().build());
    }

    public static final DashboardsServiceClient create(DashboardsServiceSettings settings) throws IOException {
        return new DashboardsServiceClient(settings);
    }

    public static final DashboardsServiceClient create(DashboardsServiceStub stub) {
        return new DashboardsServiceClient(stub);
    }

    protected DashboardsServiceClient(DashboardsServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DashboardsServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected DashboardsServiceClient(DashboardsServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final DashboardsServiceSettings getSettings() {
        return this.settings;
    }

    public DashboardsServiceStub getStub() {
        return this.stub;
    }

    public final Dashboard createDashboard(ProjectName parent, Dashboard dashboard) {
        CreateDashboardRequest request = CreateDashboardRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDashboard(dashboard).build();
        return this.createDashboard(request);
    }

    public final Dashboard createDashboard(String parent, Dashboard dashboard) {
        CreateDashboardRequest request = CreateDashboardRequest.newBuilder().setParent(parent).setDashboard(dashboard).build();
        return this.createDashboard(request);
    }

    public final Dashboard createDashboard(CreateDashboardRequest request) {
        return (Dashboard)this.createDashboardCallable().call((Object)request);
    }

    public final UnaryCallable<CreateDashboardRequest, Dashboard> createDashboardCallable() {
        return this.stub.createDashboardCallable();
    }

    public final ListDashboardsPagedResponse listDashboards(ProjectName parent) {
        ListDashboardsRequest request = ListDashboardsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDashboards(request);
    }

    public final ListDashboardsPagedResponse listDashboards(String parent) {
        ListDashboardsRequest request = ListDashboardsRequest.newBuilder().setParent(parent).build();
        return this.listDashboards(request);
    }

    public final ListDashboardsPagedResponse listDashboards(ListDashboardsRequest request) {
        return (ListDashboardsPagedResponse)((Object)this.listDashboardsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDashboardsRequest, ListDashboardsPagedResponse> listDashboardsPagedCallable() {
        return this.stub.listDashboardsPagedCallable();
    }

    public final UnaryCallable<ListDashboardsRequest, ListDashboardsResponse> listDashboardsCallable() {
        return this.stub.listDashboardsCallable();
    }

    public final Dashboard getDashboard(DashboardName name) {
        GetDashboardRequest request = GetDashboardRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDashboard(request);
    }

    public final Dashboard getDashboard(String name) {
        GetDashboardRequest request = GetDashboardRequest.newBuilder().setName(name).build();
        return this.getDashboard(request);
    }

    public final Dashboard getDashboard(GetDashboardRequest request) {
        return (Dashboard)this.getDashboardCallable().call((Object)request);
    }

    public final UnaryCallable<GetDashboardRequest, Dashboard> getDashboardCallable() {
        return this.stub.getDashboardCallable();
    }

    public final void deleteDashboard(DashboardName name) {
        DeleteDashboardRequest request = DeleteDashboardRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteDashboard(request);
    }

    public final void deleteDashboard(String name) {
        DeleteDashboardRequest request = DeleteDashboardRequest.newBuilder().setName(name).build();
        this.deleteDashboard(request);
    }

    public final void deleteDashboard(DeleteDashboardRequest request) {
        this.deleteDashboardCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteDashboardRequest, Empty> deleteDashboardCallable() {
        return this.stub.deleteDashboardCallable();
    }

    public final Dashboard updateDashboard(UpdateDashboardRequest request) {
        return (Dashboard)this.updateDashboardCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateDashboardRequest, Dashboard> updateDashboardCallable() {
        return this.stub.updateDashboardCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListDashboardsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDashboardsRequest, ListDashboardsResponse, Dashboard, ListDashboardsPage, ListDashboardsFixedSizeCollection> {
        private ListDashboardsFixedSizeCollection(List<ListDashboardsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDashboardsFixedSizeCollection createEmptyCollection() {
            return new ListDashboardsFixedSizeCollection(null, 0);
        }

        protected ListDashboardsFixedSizeCollection createCollection(List<ListDashboardsPage> pages, int collectionSize) {
            return new ListDashboardsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDashboardsPage
    extends AbstractPage<ListDashboardsRequest, ListDashboardsResponse, Dashboard, ListDashboardsPage> {
        private ListDashboardsPage(PageContext<ListDashboardsRequest, ListDashboardsResponse, Dashboard> context, ListDashboardsResponse response) {
            super(context, (Object)response);
        }

        private static ListDashboardsPage createEmptyPage() {
            return new ListDashboardsPage(null, null);
        }

        protected ListDashboardsPage createPage(PageContext<ListDashboardsRequest, ListDashboardsResponse, Dashboard> context, ListDashboardsResponse response) {
            return new ListDashboardsPage(context, response);
        }

        public ApiFuture<ListDashboardsPage> createPageAsync(PageContext<ListDashboardsRequest, ListDashboardsResponse, Dashboard> context, ApiFuture<ListDashboardsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDashboardsPagedResponse
    extends AbstractPagedListResponse<ListDashboardsRequest, ListDashboardsResponse, Dashboard, ListDashboardsPage, ListDashboardsFixedSizeCollection> {
        public static ApiFuture<ListDashboardsPagedResponse> createAsync(PageContext<ListDashboardsRequest, ListDashboardsResponse, Dashboard> context, ApiFuture<ListDashboardsResponse> futureResponse) {
            ApiFuture<ListDashboardsPage> futurePage = ListDashboardsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDashboardsPagedResponse((ListDashboardsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDashboardsPagedResponse(ListDashboardsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDashboardsFixedSizeCollection.createEmptyCollection());
        }
    }
}

