/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.metricsscope.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.monitoring.metricsscope.v1.CreateMonitoredProjectRequest;
import com.google.monitoring.metricsscope.v1.DeleteMonitoredProjectRequest;
import com.google.monitoring.metricsscope.v1.GetMetricsScopeRequest;
import com.google.monitoring.metricsscope.v1.ListMetricsScopesByMonitoredProjectRequest;
import com.google.monitoring.metricsscope.v1.ListMetricsScopesByMonitoredProjectResponse;
import com.google.monitoring.metricsscope.v1.MetricsScope;
import com.google.monitoring.metricsscope.v1.MonitoredProject;
import com.google.monitoring.metricsscope.v1.OperationMetadata;
import com.google.monitoring.metricsscope.v1.stub.GrpcMetricsScopesStub;
import com.google.monitoring.metricsscope.v1.stub.MetricsScopesStub;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class MetricsScopesStubSettings
extends StubSettings<MetricsScopesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/monitoring").add((Object)"https://www.googleapis.com/auth/monitoring.read").add((Object)"https://www.googleapis.com/auth/monitoring.write").build();
    private final UnaryCallSettings<GetMetricsScopeRequest, MetricsScope> getMetricsScopeSettings;
    private final UnaryCallSettings<ListMetricsScopesByMonitoredProjectRequest, ListMetricsScopesByMonitoredProjectResponse> listMetricsScopesByMonitoredProjectSettings;
    private final UnaryCallSettings<CreateMonitoredProjectRequest, Operation> createMonitoredProjectSettings;
    private final OperationCallSettings<CreateMonitoredProjectRequest, MonitoredProject, OperationMetadata> createMonitoredProjectOperationSettings;
    private final UnaryCallSettings<DeleteMonitoredProjectRequest, Operation> deleteMonitoredProjectSettings;
    private final OperationCallSettings<DeleteMonitoredProjectRequest, Empty, OperationMetadata> deleteMonitoredProjectOperationSettings;

    public UnaryCallSettings<GetMetricsScopeRequest, MetricsScope> getMetricsScopeSettings() {
        return this.getMetricsScopeSettings;
    }

    public UnaryCallSettings<ListMetricsScopesByMonitoredProjectRequest, ListMetricsScopesByMonitoredProjectResponse> listMetricsScopesByMonitoredProjectSettings() {
        return this.listMetricsScopesByMonitoredProjectSettings;
    }

    public UnaryCallSettings<CreateMonitoredProjectRequest, Operation> createMonitoredProjectSettings() {
        return this.createMonitoredProjectSettings;
    }

    public OperationCallSettings<CreateMonitoredProjectRequest, MonitoredProject, OperationMetadata> createMonitoredProjectOperationSettings() {
        return this.createMonitoredProjectOperationSettings;
    }

    public UnaryCallSettings<DeleteMonitoredProjectRequest, Operation> deleteMonitoredProjectSettings() {
        return this.deleteMonitoredProjectSettings;
    }

    public OperationCallSettings<DeleteMonitoredProjectRequest, Empty, OperationMetadata> deleteMonitoredProjectOperationSettings() {
        return this.deleteMonitoredProjectOperationSettings;
    }

    public MetricsScopesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcMetricsScopesStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "monitoring";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "monitoring.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "monitoring.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return MetricsScopesStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(MetricsScopesStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected MetricsScopesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getMetricsScopeSettings = settingsBuilder.getMetricsScopeSettings().build();
        this.listMetricsScopesByMonitoredProjectSettings = settingsBuilder.listMetricsScopesByMonitoredProjectSettings().build();
        this.createMonitoredProjectSettings = settingsBuilder.createMonitoredProjectSettings().build();
        this.createMonitoredProjectOperationSettings = settingsBuilder.createMonitoredProjectOperationSettings().build();
        this.deleteMonitoredProjectSettings = settingsBuilder.deleteMonitoredProjectSettings().build();
        this.deleteMonitoredProjectOperationSettings = settingsBuilder.deleteMonitoredProjectOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<MetricsScopesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetMetricsScopeRequest, MetricsScope> getMetricsScopeSettings;
        private final UnaryCallSettings.Builder<ListMetricsScopesByMonitoredProjectRequest, ListMetricsScopesByMonitoredProjectResponse> listMetricsScopesByMonitoredProjectSettings;
        private final UnaryCallSettings.Builder<CreateMonitoredProjectRequest, Operation> createMonitoredProjectSettings;
        private final OperationCallSettings.Builder<CreateMonitoredProjectRequest, MonitoredProject, OperationMetadata> createMonitoredProjectOperationSettings;
        private final UnaryCallSettings.Builder<DeleteMonitoredProjectRequest, Operation> deleteMonitoredProjectSettings;
        private final OperationCallSettings.Builder<DeleteMonitoredProjectRequest, Empty, OperationMetadata> deleteMonitoredProjectOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getMetricsScopeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listMetricsScopesByMonitoredProjectSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createMonitoredProjectSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createMonitoredProjectOperationSettings = OperationCallSettings.newBuilder();
            this.deleteMonitoredProjectSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteMonitoredProjectOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getMetricsScopeSettings, this.listMetricsScopesByMonitoredProjectSettings, this.createMonitoredProjectSettings, this.deleteMonitoredProjectSettings);
            Builder.initDefaults(this);
        }

        protected Builder(MetricsScopesStubSettings settings) {
            super((StubSettings)settings);
            this.getMetricsScopeSettings = settings.getMetricsScopeSettings.toBuilder();
            this.listMetricsScopesByMonitoredProjectSettings = settings.listMetricsScopesByMonitoredProjectSettings.toBuilder();
            this.createMonitoredProjectSettings = settings.createMonitoredProjectSettings.toBuilder();
            this.createMonitoredProjectOperationSettings = settings.createMonitoredProjectOperationSettings.toBuilder();
            this.deleteMonitoredProjectSettings = settings.deleteMonitoredProjectSettings.toBuilder();
            this.deleteMonitoredProjectOperationSettings = settings.deleteMonitoredProjectOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getMetricsScopeSettings, this.listMetricsScopesByMonitoredProjectSettings, this.createMonitoredProjectSettings, this.deleteMonitoredProjectSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(MetricsScopesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)MetricsScopesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)MetricsScopesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(MetricsScopesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getMetricsScopeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listMetricsScopesByMonitoredProjectSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createMonitoredProjectSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteMonitoredProjectSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createMonitoredProjectOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(MonitoredProject.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(900000L)).build()));
            builder.deleteMonitoredProjectOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(2.0).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(900000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetMetricsScopeRequest, MetricsScope> getMetricsScopeSettings() {
            return this.getMetricsScopeSettings;
        }

        public UnaryCallSettings.Builder<ListMetricsScopesByMonitoredProjectRequest, ListMetricsScopesByMonitoredProjectResponse> listMetricsScopesByMonitoredProjectSettings() {
            return this.listMetricsScopesByMonitoredProjectSettings;
        }

        public UnaryCallSettings.Builder<CreateMonitoredProjectRequest, Operation> createMonitoredProjectSettings() {
            return this.createMonitoredProjectSettings;
        }

        public OperationCallSettings.Builder<CreateMonitoredProjectRequest, MonitoredProject, OperationMetadata> createMonitoredProjectOperationSettings() {
            return this.createMonitoredProjectOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteMonitoredProjectRequest, Operation> deleteMonitoredProjectSettings() {
            return this.deleteMonitoredProjectSettings;
        }

        public OperationCallSettings.Builder<DeleteMonitoredProjectRequest, Empty, OperationMetadata> deleteMonitoredProjectOperationSettings() {
            return this.deleteMonitoredProjectOperationSettings;
        }

        public MetricsScopesStubSettings build() throws IOException {
            return new MetricsScopesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

