/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.metricsscope.v1;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.monitoring.metricsscope.v1.CreateMonitoredProjectRequest;
import com.google.monitoring.metricsscope.v1.DeleteMonitoredProjectRequest;
import com.google.monitoring.metricsscope.v1.GetMetricsScopeRequest;
import com.google.monitoring.metricsscope.v1.ListMetricsScopesByMonitoredProjectRequest;
import com.google.monitoring.metricsscope.v1.ListMetricsScopesByMonitoredProjectResponse;
import com.google.monitoring.metricsscope.v1.MetricsScope;
import com.google.monitoring.metricsscope.v1.MetricsScopeName;
import com.google.monitoring.metricsscope.v1.MetricsScopesSettings;
import com.google.monitoring.metricsscope.v1.MonitoredProject;
import com.google.monitoring.metricsscope.v1.MonitoredProjectName;
import com.google.monitoring.metricsscope.v1.OperationMetadata;
import com.google.monitoring.metricsscope.v1.stub.MetricsScopesStub;
import com.google.monitoring.metricsscope.v1.stub.MetricsScopesStubSettings;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class MetricsScopesClient
implements BackgroundResource {
    private final MetricsScopesSettings settings;
    private final MetricsScopesStub stub;
    private final OperationsClient operationsClient;

    public static final MetricsScopesClient create() throws IOException {
        return MetricsScopesClient.create(MetricsScopesSettings.newBuilder().build());
    }

    public static final MetricsScopesClient create(MetricsScopesSettings settings) throws IOException {
        return new MetricsScopesClient(settings);
    }

    public static final MetricsScopesClient create(MetricsScopesStub stub) {
        return new MetricsScopesClient(stub);
    }

    protected MetricsScopesClient(MetricsScopesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((MetricsScopesStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected MetricsScopesClient(MetricsScopesStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final MetricsScopesSettings getSettings() {
        return this.settings;
    }

    public MetricsScopesStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final MetricsScope getMetricsScope(MetricsScopeName name) {
        GetMetricsScopeRequest request = GetMetricsScopeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getMetricsScope(request);
    }

    public final MetricsScope getMetricsScope(String name) {
        GetMetricsScopeRequest request = GetMetricsScopeRequest.newBuilder().setName(name).build();
        return this.getMetricsScope(request);
    }

    public final MetricsScope getMetricsScope(GetMetricsScopeRequest request) {
        return (MetricsScope)this.getMetricsScopeCallable().call((Object)request);
    }

    public final UnaryCallable<GetMetricsScopeRequest, MetricsScope> getMetricsScopeCallable() {
        return this.stub.getMetricsScopeCallable();
    }

    public final ListMetricsScopesByMonitoredProjectResponse listMetricsScopesByMonitoredProject(ListMetricsScopesByMonitoredProjectRequest request) {
        return (ListMetricsScopesByMonitoredProjectResponse)this.listMetricsScopesByMonitoredProjectCallable().call((Object)request);
    }

    public final UnaryCallable<ListMetricsScopesByMonitoredProjectRequest, ListMetricsScopesByMonitoredProjectResponse> listMetricsScopesByMonitoredProjectCallable() {
        return this.stub.listMetricsScopesByMonitoredProjectCallable();
    }

    public final OperationFuture<MonitoredProject, OperationMetadata> createMonitoredProjectAsync(MetricsScopeName parent, MonitoredProject monitoredProject) {
        CreateMonitoredProjectRequest request = CreateMonitoredProjectRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setMonitoredProject(monitoredProject).build();
        return this.createMonitoredProjectAsync(request);
    }

    public final OperationFuture<MonitoredProject, OperationMetadata> createMonitoredProjectAsync(String parent, MonitoredProject monitoredProject) {
        CreateMonitoredProjectRequest request = CreateMonitoredProjectRequest.newBuilder().setParent(parent).setMonitoredProject(monitoredProject).build();
        return this.createMonitoredProjectAsync(request);
    }

    public final OperationFuture<MonitoredProject, OperationMetadata> createMonitoredProjectAsync(CreateMonitoredProjectRequest request) {
        return this.createMonitoredProjectOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateMonitoredProjectRequest, MonitoredProject, OperationMetadata> createMonitoredProjectOperationCallable() {
        return this.stub.createMonitoredProjectOperationCallable();
    }

    public final UnaryCallable<CreateMonitoredProjectRequest, Operation> createMonitoredProjectCallable() {
        return this.stub.createMonitoredProjectCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteMonitoredProjectAsync(MonitoredProjectName name) {
        DeleteMonitoredProjectRequest request = DeleteMonitoredProjectRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteMonitoredProjectAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteMonitoredProjectAsync(String name) {
        DeleteMonitoredProjectRequest request = DeleteMonitoredProjectRequest.newBuilder().setName(name).build();
        return this.deleteMonitoredProjectAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteMonitoredProjectAsync(DeleteMonitoredProjectRequest request) {
        return this.deleteMonitoredProjectOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteMonitoredProjectRequest, Empty, OperationMetadata> deleteMonitoredProjectOperationCallable() {
        return this.stub.deleteMonitoredProjectOperationCallable();
    }

    public final UnaryCallable<DeleteMonitoredProjectRequest, Operation> deleteMonitoredProjectCallable() {
        return this.stub.deleteMonitoredProjectCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

