/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.monitoring.spi.v3;

import com.google.api.MonitoredResource;
import com.google.api.core.ApiFuture;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.PropertiesProvider;
import com.google.api.gax.grpc.CallContext;
import com.google.api.gax.grpc.ChannelProvider;
import com.google.api.gax.grpc.ClientSettings;
import com.google.api.gax.grpc.ExecutorProvider;
import com.google.api.gax.grpc.InstantiatingChannelProvider;
import com.google.api.gax.grpc.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.PageContext;
import com.google.api.gax.grpc.PagedCallSettings;
import com.google.api.gax.grpc.PagedListDescriptor;
import com.google.api.gax.grpc.PagedListResponseFactory;
import com.google.api.gax.grpc.SimpleCallSettings;
import com.google.api.gax.grpc.UnaryCallSettings;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.api.gax.retrying.RetrySettings;
import com.google.cloud.monitoring.spi.v3.PagedResponseWrappers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.monitoring.v3.CreateGroupRequest;
import com.google.monitoring.v3.DeleteGroupRequest;
import com.google.monitoring.v3.GetGroupRequest;
import com.google.monitoring.v3.Group;
import com.google.monitoring.v3.ListGroupMembersRequest;
import com.google.monitoring.v3.ListGroupMembersResponse;
import com.google.monitoring.v3.ListGroupsRequest;
import com.google.monitoring.v3.ListGroupsResponse;
import com.google.monitoring.v3.UpdateGroupRequest;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.joda.time.Duration;

public class GroupServiceSettings
extends ClientSettings {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/monitoring").add((Object)"https://www.googleapis.com/auth/monitoring.read").add((Object)"https://www.googleapis.com/auth/monitoring.write").build();
    private static final String DEFAULT_GAPIC_NAME = "gapic";
    private static final String DEFAULT_GAPIC_VERSION = "";
    private static final String PROPERTIES_FILE = "/com/google/cloud/monitoring/project.properties";
    private static final String META_VERSION_KEY = "artifact.version";
    private static String gapicVersion;
    private static final MethodDescriptor<ListGroupsRequest, ListGroupsResponse> METHOD_LIST_GROUPS;
    private static final MethodDescriptor<GetGroupRequest, Group> METHOD_GET_GROUP;
    private static final MethodDescriptor<CreateGroupRequest, Group> METHOD_CREATE_GROUP;
    private static final MethodDescriptor<UpdateGroupRequest, Group> METHOD_UPDATE_GROUP;
    private static final MethodDescriptor<DeleteGroupRequest, Empty> METHOD_DELETE_GROUP;
    private static final MethodDescriptor<ListGroupMembersRequest, ListGroupMembersResponse> METHOD_LIST_GROUP_MEMBERS;
    private final PagedCallSettings<ListGroupsRequest, ListGroupsResponse, PagedResponseWrappers.ListGroupsPagedResponse> listGroupsSettings;
    private final SimpleCallSettings<GetGroupRequest, Group> getGroupSettings;
    private final SimpleCallSettings<CreateGroupRequest, Group> createGroupSettings;
    private final SimpleCallSettings<UpdateGroupRequest, Group> updateGroupSettings;
    private final SimpleCallSettings<DeleteGroupRequest, Empty> deleteGroupSettings;
    private final PagedCallSettings<ListGroupMembersRequest, ListGroupMembersResponse, PagedResponseWrappers.ListGroupMembersPagedResponse> listGroupMembersSettings;
    private static final PagedListDescriptor<ListGroupsRequest, ListGroupsResponse, Group> LIST_GROUPS_PAGE_STR_DESC;
    private static final PagedListDescriptor<ListGroupMembersRequest, ListGroupMembersResponse, MonitoredResource> LIST_GROUP_MEMBERS_PAGE_STR_DESC;
    private static final PagedListResponseFactory<ListGroupsRequest, ListGroupsResponse, PagedResponseWrappers.ListGroupsPagedResponse> LIST_GROUPS_PAGE_STR_FACT;
    private static final PagedListResponseFactory<ListGroupMembersRequest, ListGroupMembersResponse, PagedResponseWrappers.ListGroupMembersPagedResponse> LIST_GROUP_MEMBERS_PAGE_STR_FACT;

    public PagedCallSettings<ListGroupsRequest, ListGroupsResponse, PagedResponseWrappers.ListGroupsPagedResponse> listGroupsSettings() {
        return this.listGroupsSettings;
    }

    public SimpleCallSettings<GetGroupRequest, Group> getGroupSettings() {
        return this.getGroupSettings;
    }

    public SimpleCallSettings<CreateGroupRequest, Group> createGroupSettings() {
        return this.createGroupSettings;
    }

    public SimpleCallSettings<UpdateGroupRequest, Group> updateGroupSettings() {
        return this.updateGroupSettings;
    }

    public SimpleCallSettings<DeleteGroupRequest, Empty> deleteGroupSettings() {
        return this.deleteGroupSettings;
    }

    public PagedCallSettings<ListGroupMembersRequest, ListGroupMembersResponse, PagedResponseWrappers.ListGroupMembersPagedResponse> listGroupMembersSettings() {
        return this.listGroupMembersSettings;
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "monitoring.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingChannelProvider.Builder defaultChannelProviderBuilder() {
        return InstantiatingChannelProvider.newBuilder().setEndpoint(GroupServiceSettings.getDefaultEndpoint()).setGeneratorHeader(DEFAULT_GAPIC_NAME, GroupServiceSettings.getGapicVersion()).setCredentialsProvider((CredentialsProvider)GroupServiceSettings.defaultCredentialsProviderBuilder().build());
    }

    private static String getGapicVersion() {
        if (gapicVersion == null) {
            gapicVersion = PropertiesProvider.loadProperty(GroupServiceSettings.class, (String)PROPERTIES_FILE, (String)META_VERSION_KEY);
            gapicVersion = gapicVersion == null ? DEFAULT_GAPIC_VERSION : gapicVersion;
        }
        return gapicVersion;
    }

    public static Builder defaultBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private GroupServiceSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder.getExecutorProvider(), settingsBuilder.getChannelProvider());
        this.listGroupsSettings = settingsBuilder.listGroupsSettings().build();
        this.getGroupSettings = settingsBuilder.getGroupSettings().build();
        this.createGroupSettings = settingsBuilder.createGroupSettings().build();
        this.updateGroupSettings = settingsBuilder.updateGroupSettings().build();
        this.deleteGroupSettings = settingsBuilder.deleteGroupSettings().build();
        this.listGroupMembersSettings = settingsBuilder.listGroupMembersSettings().build();
    }

    static {
        METHOD_LIST_GROUPS = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.monitoring.v3.GroupService/ListGroups", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)ListGroupsRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)ListGroupsResponse.getDefaultInstance()));
        METHOD_GET_GROUP = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.monitoring.v3.GroupService/GetGroup", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)GetGroupRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Group.getDefaultInstance()));
        METHOD_CREATE_GROUP = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.monitoring.v3.GroupService/CreateGroup", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)CreateGroupRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Group.getDefaultInstance()));
        METHOD_UPDATE_GROUP = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.monitoring.v3.GroupService/UpdateGroup", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)UpdateGroupRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Group.getDefaultInstance()));
        METHOD_DELETE_GROUP = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.monitoring.v3.GroupService/DeleteGroup", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)DeleteGroupRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Empty.getDefaultInstance()));
        METHOD_LIST_GROUP_MEMBERS = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.monitoring.v3.GroupService/ListGroupMembers", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)ListGroupMembersRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)ListGroupMembersResponse.getDefaultInstance()));
        LIST_GROUPS_PAGE_STR_DESC = new PagedListDescriptor<ListGroupsRequest, ListGroupsResponse, Group>(){

            public String emptyToken() {
                return GroupServiceSettings.DEFAULT_GAPIC_VERSION;
            }

            public ListGroupsRequest injectToken(ListGroupsRequest payload, String token) {
                return ListGroupsRequest.newBuilder((ListGroupsRequest)payload).setPageToken(token).build();
            }

            public ListGroupsRequest injectPageSize(ListGroupsRequest payload, int pageSize) {
                return ListGroupsRequest.newBuilder((ListGroupsRequest)payload).setPageSize(pageSize).build();
            }

            public Integer extractPageSize(ListGroupsRequest payload) {
                return payload.getPageSize();
            }

            public String extractNextToken(ListGroupsResponse payload) {
                return payload.getNextPageToken();
            }

            public Iterable<Group> extractResources(ListGroupsResponse payload) {
                return payload.getGroupList();
            }
        };
        LIST_GROUP_MEMBERS_PAGE_STR_DESC = new PagedListDescriptor<ListGroupMembersRequest, ListGroupMembersResponse, MonitoredResource>(){

            public String emptyToken() {
                return GroupServiceSettings.DEFAULT_GAPIC_VERSION;
            }

            public ListGroupMembersRequest injectToken(ListGroupMembersRequest payload, String token) {
                return ListGroupMembersRequest.newBuilder((ListGroupMembersRequest)payload).setPageToken(token).build();
            }

            public ListGroupMembersRequest injectPageSize(ListGroupMembersRequest payload, int pageSize) {
                return ListGroupMembersRequest.newBuilder((ListGroupMembersRequest)payload).setPageSize(pageSize).build();
            }

            public Integer extractPageSize(ListGroupMembersRequest payload) {
                return payload.getPageSize();
            }

            public String extractNextToken(ListGroupMembersResponse payload) {
                return payload.getNextPageToken();
            }

            public Iterable<MonitoredResource> extractResources(ListGroupMembersResponse payload) {
                return payload.getMembersList();
            }
        };
        LIST_GROUPS_PAGE_STR_FACT = new PagedListResponseFactory<ListGroupsRequest, ListGroupsResponse, PagedResponseWrappers.ListGroupsPagedResponse>(){

            public ApiFuture<PagedResponseWrappers.ListGroupsPagedResponse> getFuturePagedResponse(UnaryCallable<ListGroupsRequest, ListGroupsResponse> callable, ListGroupsRequest request, CallContext context, ApiFuture<ListGroupsResponse> futureResponse) {
                PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_GROUPS_PAGE_STR_DESC, (Object)request, (CallContext)context);
                return PagedResponseWrappers.ListGroupsPagedResponse.createAsync((PageContext<ListGroupsRequest, ListGroupsResponse, Group>)pageContext, futureResponse);
            }
        };
        LIST_GROUP_MEMBERS_PAGE_STR_FACT = new PagedListResponseFactory<ListGroupMembersRequest, ListGroupMembersResponse, PagedResponseWrappers.ListGroupMembersPagedResponse>(){

            public ApiFuture<PagedResponseWrappers.ListGroupMembersPagedResponse> getFuturePagedResponse(UnaryCallable<ListGroupMembersRequest, ListGroupMembersResponse> callable, ListGroupMembersRequest request, CallContext context, ApiFuture<ListGroupMembersResponse> futureResponse) {
                PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_GROUP_MEMBERS_PAGE_STR_DESC, (Object)request, (CallContext)context);
                return PagedResponseWrappers.ListGroupMembersPagedResponse.createAsync((PageContext<ListGroupMembersRequest, ListGroupMembersResponse, MonitoredResource>)pageContext, futureResponse);
            }
        };
    }

    public static class Builder
    extends ClientSettings.Builder {
        private final ImmutableList<UnaryCallSettings.Builder> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListGroupsRequest, ListGroupsResponse, PagedResponseWrappers.ListGroupsPagedResponse> listGroupsSettings;
        private final SimpleCallSettings.Builder<GetGroupRequest, Group> getGroupSettings;
        private final SimpleCallSettings.Builder<CreateGroupRequest, Group> createGroupSettings;
        private final SimpleCallSettings.Builder<UpdateGroupRequest, Group> updateGroupSettings;
        private final SimpleCallSettings.Builder<DeleteGroupRequest, Empty> deleteGroupSettings;
        private final PagedCallSettings.Builder<ListGroupMembersRequest, ListGroupMembersResponse, PagedResponseWrappers.ListGroupMembersPagedResponse> listGroupMembersSettings;
        private static final ImmutableMap<String, ImmutableSet<Status.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings.Builder> RETRY_PARAM_DEFINITIONS;

        private Builder() {
            super(GroupServiceSettings.defaultChannelProviderBuilder().build());
            this.listGroupsSettings = PagedCallSettings.newBuilder((MethodDescriptor)METHOD_LIST_GROUPS, (PagedListResponseFactory)LIST_GROUPS_PAGE_STR_FACT);
            this.getGroupSettings = SimpleCallSettings.newBuilder((MethodDescriptor)METHOD_GET_GROUP);
            this.createGroupSettings = SimpleCallSettings.newBuilder((MethodDescriptor)METHOD_CREATE_GROUP);
            this.updateGroupSettings = SimpleCallSettings.newBuilder((MethodDescriptor)METHOD_UPDATE_GROUP);
            this.deleteGroupSettings = SimpleCallSettings.newBuilder((MethodDescriptor)METHOD_DELETE_GROUP);
            this.listGroupMembersSettings = PagedCallSettings.newBuilder((MethodDescriptor)METHOD_LIST_GROUP_MEMBERS, (PagedListResponseFactory)LIST_GROUP_MEMBERS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listGroupsSettings, this.getGroupSettings, this.createGroupSettings, this.updateGroupSettings, this.deleteGroupSettings, this.listGroupMembersSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder();
            builder.listGroupsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listGroupMembersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        private Builder(GroupServiceSettings settings) {
            super((ClientSettings)settings);
            this.listGroupsSettings = settings.listGroupsSettings.toBuilder();
            this.getGroupSettings = settings.getGroupSettings.toBuilder();
            this.createGroupSettings = settings.createGroupSettings.toBuilder();
            this.updateGroupSettings = settings.updateGroupSettings.toBuilder();
            this.deleteGroupSettings = settings.deleteGroupSettings.toBuilder();
            this.listGroupMembersSettings = settings.listGroupMembersSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listGroupsSettings, this.getGroupSettings, this.createGroupSettings, this.updateGroupSettings, this.deleteGroupSettings, this.listGroupMembersSettings);
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            super.setExecutorProvider(executorProvider);
            return this;
        }

        public Builder setChannelProvider(ChannelProvider channelProvider) {
            super.setChannelProvider(channelProvider);
            return this;
        }

        public Builder applyToAllUnaryMethods(UnaryCallSettings.Builder unaryCallSettings) throws Exception {
            super.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, unaryCallSettings);
            return this;
        }

        public PagedCallSettings.Builder<ListGroupsRequest, ListGroupsResponse, PagedResponseWrappers.ListGroupsPagedResponse> listGroupsSettings() {
            return this.listGroupsSettings;
        }

        public SimpleCallSettings.Builder<GetGroupRequest, Group> getGroupSettings() {
            return this.getGroupSettings;
        }

        public SimpleCallSettings.Builder<CreateGroupRequest, Group> createGroupSettings() {
            return this.createGroupSettings;
        }

        public SimpleCallSettings.Builder<UpdateGroupRequest, Group> updateGroupSettings() {
            return this.updateGroupSettings;
        }

        public SimpleCallSettings.Builder<DeleteGroupRequest, Empty> deleteGroupSettings() {
            return this.deleteGroupSettings;
        }

        public PagedCallSettings.Builder<ListGroupMembersRequest, ListGroupMembersResponse, PagedResponseWrappers.ListGroupMembersPagedResponse> listGroupMembersSettings() {
            return this.listGroupMembersSettings;
        }

        public GroupServiceSettings build() throws IOException {
            return new GroupServiceSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList((Object[])new Status.Code[]{Status.Code.DEADLINE_EXCEEDED, Status.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList((Object[])new Status.Code[]{Status.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings.Builder settingsBuilder = null;
            settingsBuilder = RetrySettings.newBuilder().setInitialRetryDelay(Duration.millis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.millis((long)60000L)).setInitialRpcTimeout(Duration.millis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.millis((long)20000L)).setTotalTimeout(Duration.millis((long)600000L));
            definitions.put((Object)"default", (Object)settingsBuilder);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

