/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.monitoring.v3;

import com.google.api.core.BetaApi;
import com.google.api.gax.grpc.ChannelAndExecutor;
import com.google.api.gax.grpc.ClientContext;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.auth.Credentials;
import com.google.cloud.monitoring.v3.GroupServiceSettings;
import com.google.cloud.monitoring.v3.PagedResponseWrappers;
import com.google.monitoring.v3.CreateGroupRequest;
import com.google.monitoring.v3.DeleteGroupRequest;
import com.google.monitoring.v3.GetGroupRequest;
import com.google.monitoring.v3.Group;
import com.google.monitoring.v3.GroupName;
import com.google.monitoring.v3.ListGroupMembersRequest;
import com.google.monitoring.v3.ListGroupMembersResponse;
import com.google.monitoring.v3.ListGroupsRequest;
import com.google.monitoring.v3.ListGroupsResponse;
import com.google.monitoring.v3.ProjectName;
import com.google.monitoring.v3.UpdateGroupRequest;
import com.google.protobuf.Empty;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;

@BetaApi
public class GroupServiceClient
implements AutoCloseable {
    private final GroupServiceSettings settings;
    private final ScheduledExecutorService executor;
    private final ManagedChannel channel;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private final UnaryCallable<ListGroupsRequest, ListGroupsResponse> listGroupsCallable;
    private final UnaryCallable<ListGroupsRequest, PagedResponseWrappers.ListGroupsPagedResponse> listGroupsPagedCallable;
    private final UnaryCallable<GetGroupRequest, Group> getGroupCallable;
    private final UnaryCallable<CreateGroupRequest, Group> createGroupCallable;
    private final UnaryCallable<UpdateGroupRequest, Group> updateGroupCallable;
    private final UnaryCallable<DeleteGroupRequest, Empty> deleteGroupCallable;
    private final UnaryCallable<ListGroupMembersRequest, ListGroupMembersResponse> listGroupMembersCallable;
    private final UnaryCallable<ListGroupMembersRequest, PagedResponseWrappers.ListGroupMembersPagedResponse> listGroupMembersPagedCallable;

    public static final GroupServiceClient create() throws IOException {
        return GroupServiceClient.create(GroupServiceSettings.defaultBuilder().build());
    }

    public static final GroupServiceClient create(GroupServiceSettings settings) throws IOException {
        return new GroupServiceClient(settings);
    }

    protected GroupServiceClient(GroupServiceSettings settings) throws IOException {
        this.settings = settings;
        ChannelAndExecutor channelAndExecutor = settings.getChannelAndExecutor();
        this.executor = channelAndExecutor.getExecutor();
        this.channel = channelAndExecutor.getChannel();
        Credentials credentials = settings.getCredentialsProvider().getCredentials();
        ClientContext clientContext = ClientContext.newBuilder().setExecutor(this.executor).setChannel((Channel)this.channel).setCredentials(credentials).build();
        this.listGroupsCallable = UnaryCallable.create(settings.listGroupsSettings(), (ClientContext)clientContext);
        this.listGroupsPagedCallable = UnaryCallable.createPagedVariant(settings.listGroupsSettings(), (ClientContext)clientContext);
        this.getGroupCallable = UnaryCallable.create(settings.getGroupSettings(), (ClientContext)clientContext);
        this.createGroupCallable = UnaryCallable.create(settings.createGroupSettings(), (ClientContext)clientContext);
        this.updateGroupCallable = UnaryCallable.create(settings.updateGroupSettings(), (ClientContext)clientContext);
        this.deleteGroupCallable = UnaryCallable.create(settings.deleteGroupSettings(), (ClientContext)clientContext);
        this.listGroupMembersCallable = UnaryCallable.create(settings.listGroupMembersSettings(), (ClientContext)clientContext);
        this.listGroupMembersPagedCallable = UnaryCallable.createPagedVariant(settings.listGroupMembersSettings(), (ClientContext)clientContext);
        if (settings.getChannelProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    GroupServiceClient.this.channel.shutdown();
                }
            });
        }
        if (settings.getExecutorProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    GroupServiceClient.this.executor.shutdown();
                }
            });
        }
    }

    public final GroupServiceSettings getSettings() {
        return this.settings;
    }

    public final PagedResponseWrappers.ListGroupsPagedResponse listGroups(ListGroupsRequest request) {
        return (PagedResponseWrappers.ListGroupsPagedResponse)((Object)this.listGroupsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListGroupsRequest, PagedResponseWrappers.ListGroupsPagedResponse> listGroupsPagedCallable() {
        return this.listGroupsPagedCallable;
    }

    public final UnaryCallable<ListGroupsRequest, ListGroupsResponse> listGroupsCallable() {
        return this.listGroupsCallable;
    }

    public final Group getGroup(GroupName name) {
        GetGroupRequest request = GetGroupRequest.newBuilder().setNameWithGroupName(name).build();
        return this.getGroup(request);
    }

    private final Group getGroup(GetGroupRequest request) {
        return (Group)this.getGroupCallable().call((Object)request);
    }

    public final UnaryCallable<GetGroupRequest, Group> getGroupCallable() {
        return this.getGroupCallable;
    }

    public final Group createGroup(ProjectName name, Group group) {
        CreateGroupRequest request = CreateGroupRequest.newBuilder().setNameWithProjectName(name).setGroup(group).build();
        return this.createGroup(request);
    }

    public final Group createGroup(CreateGroupRequest request) {
        return (Group)this.createGroupCallable().call((Object)request);
    }

    public final UnaryCallable<CreateGroupRequest, Group> createGroupCallable() {
        return this.createGroupCallable;
    }

    public final Group updateGroup(Group group) {
        UpdateGroupRequest request = UpdateGroupRequest.newBuilder().setGroup(group).build();
        return this.updateGroup(request);
    }

    public final Group updateGroup(UpdateGroupRequest request) {
        return (Group)this.updateGroupCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateGroupRequest, Group> updateGroupCallable() {
        return this.updateGroupCallable;
    }

    public final void deleteGroup(GroupName name) {
        DeleteGroupRequest request = DeleteGroupRequest.newBuilder().setNameWithGroupName(name).build();
        this.deleteGroup(request);
    }

    private final void deleteGroup(DeleteGroupRequest request) {
        this.deleteGroupCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteGroupRequest, Empty> deleteGroupCallable() {
        return this.deleteGroupCallable;
    }

    public final PagedResponseWrappers.ListGroupMembersPagedResponse listGroupMembers(GroupName name) {
        ListGroupMembersRequest request = ListGroupMembersRequest.newBuilder().setNameWithGroupName(name).build();
        return this.listGroupMembers(request);
    }

    public final PagedResponseWrappers.ListGroupMembersPagedResponse listGroupMembers(ListGroupMembersRequest request) {
        return (PagedResponseWrappers.ListGroupMembersPagedResponse)((Object)this.listGroupMembersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListGroupMembersRequest, PagedResponseWrappers.ListGroupMembersPagedResponse> listGroupMembersPagedCallable() {
        return this.listGroupMembersPagedCallable;
    }

    public final UnaryCallable<ListGroupMembersRequest, ListGroupMembersResponse> listGroupMembersCallable() {
        return this.listGroupMembersCallable;
    }

    @Override
    public final void close() throws Exception {
        for (AutoCloseable closeable : this.closeables) {
            closeable.close();
        }
    }
}

