/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.monitoring.v3;

import com.google.api.MetricDescriptor;
import com.google.api.MonitoredResourceDescriptor;
import com.google.api.core.BetaApi;
import com.google.api.gax.grpc.ChannelAndExecutor;
import com.google.api.gax.grpc.ClientContext;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.auth.Credentials;
import com.google.cloud.monitoring.v3.MetricServiceSettings;
import com.google.cloud.monitoring.v3.PagedResponseWrappers;
import com.google.monitoring.v3.CreateMetricDescriptorRequest;
import com.google.monitoring.v3.CreateTimeSeriesRequest;
import com.google.monitoring.v3.DeleteMetricDescriptorRequest;
import com.google.monitoring.v3.GetMetricDescriptorRequest;
import com.google.monitoring.v3.GetMonitoredResourceDescriptorRequest;
import com.google.monitoring.v3.ListMetricDescriptorsRequest;
import com.google.monitoring.v3.ListMetricDescriptorsResponse;
import com.google.monitoring.v3.ListMonitoredResourceDescriptorsRequest;
import com.google.monitoring.v3.ListMonitoredResourceDescriptorsResponse;
import com.google.monitoring.v3.ListTimeSeriesRequest;
import com.google.monitoring.v3.ListTimeSeriesResponse;
import com.google.monitoring.v3.MetricDescriptorName;
import com.google.monitoring.v3.MonitoredResourceDescriptorName;
import com.google.monitoring.v3.ProjectName;
import com.google.monitoring.v3.TimeInterval;
import com.google.monitoring.v3.TimeSeries;
import com.google.protobuf.Empty;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;

@BetaApi
public class MetricServiceClient
implements AutoCloseable {
    private final MetricServiceSettings settings;
    private final ScheduledExecutorService executor;
    private final ManagedChannel channel;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private final UnaryCallable<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse> listMonitoredResourceDescriptorsCallable;
    private final UnaryCallable<ListMonitoredResourceDescriptorsRequest, PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse> listMonitoredResourceDescriptorsPagedCallable;
    private final UnaryCallable<GetMonitoredResourceDescriptorRequest, MonitoredResourceDescriptor> getMonitoredResourceDescriptorCallable;
    private final UnaryCallable<ListMetricDescriptorsRequest, ListMetricDescriptorsResponse> listMetricDescriptorsCallable;
    private final UnaryCallable<ListMetricDescriptorsRequest, PagedResponseWrappers.ListMetricDescriptorsPagedResponse> listMetricDescriptorsPagedCallable;
    private final UnaryCallable<GetMetricDescriptorRequest, MetricDescriptor> getMetricDescriptorCallable;
    private final UnaryCallable<CreateMetricDescriptorRequest, MetricDescriptor> createMetricDescriptorCallable;
    private final UnaryCallable<DeleteMetricDescriptorRequest, Empty> deleteMetricDescriptorCallable;
    private final UnaryCallable<ListTimeSeriesRequest, ListTimeSeriesResponse> listTimeSeriesCallable;
    private final UnaryCallable<ListTimeSeriesRequest, PagedResponseWrappers.ListTimeSeriesPagedResponse> listTimeSeriesPagedCallable;
    private final UnaryCallable<CreateTimeSeriesRequest, Empty> createTimeSeriesCallable;

    public static final MetricServiceClient create() throws IOException {
        return MetricServiceClient.create(MetricServiceSettings.defaultBuilder().build());
    }

    public static final MetricServiceClient create(MetricServiceSettings settings) throws IOException {
        return new MetricServiceClient(settings);
    }

    protected MetricServiceClient(MetricServiceSettings settings) throws IOException {
        this.settings = settings;
        ChannelAndExecutor channelAndExecutor = settings.getChannelAndExecutor();
        this.executor = channelAndExecutor.getExecutor();
        this.channel = channelAndExecutor.getChannel();
        Credentials credentials = settings.getCredentialsProvider().getCredentials();
        ClientContext clientContext = ClientContext.newBuilder().setExecutor(this.executor).setChannel((Channel)this.channel).setCredentials(credentials).build();
        this.listMonitoredResourceDescriptorsCallable = UnaryCallable.create(settings.listMonitoredResourceDescriptorsSettings(), (ClientContext)clientContext);
        this.listMonitoredResourceDescriptorsPagedCallable = UnaryCallable.createPagedVariant(settings.listMonitoredResourceDescriptorsSettings(), (ClientContext)clientContext);
        this.getMonitoredResourceDescriptorCallable = UnaryCallable.create(settings.getMonitoredResourceDescriptorSettings(), (ClientContext)clientContext);
        this.listMetricDescriptorsCallable = UnaryCallable.create(settings.listMetricDescriptorsSettings(), (ClientContext)clientContext);
        this.listMetricDescriptorsPagedCallable = UnaryCallable.createPagedVariant(settings.listMetricDescriptorsSettings(), (ClientContext)clientContext);
        this.getMetricDescriptorCallable = UnaryCallable.create(settings.getMetricDescriptorSettings(), (ClientContext)clientContext);
        this.createMetricDescriptorCallable = UnaryCallable.create(settings.createMetricDescriptorSettings(), (ClientContext)clientContext);
        this.deleteMetricDescriptorCallable = UnaryCallable.create(settings.deleteMetricDescriptorSettings(), (ClientContext)clientContext);
        this.listTimeSeriesCallable = UnaryCallable.create(settings.listTimeSeriesSettings(), (ClientContext)clientContext);
        this.listTimeSeriesPagedCallable = UnaryCallable.createPagedVariant(settings.listTimeSeriesSettings(), (ClientContext)clientContext);
        this.createTimeSeriesCallable = UnaryCallable.create(settings.createTimeSeriesSettings(), (ClientContext)clientContext);
        if (settings.getChannelProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    MetricServiceClient.this.channel.shutdown();
                }
            });
        }
        if (settings.getExecutorProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    MetricServiceClient.this.executor.shutdown();
                }
            });
        }
    }

    public final MetricServiceSettings getSettings() {
        return this.settings;
    }

    public final PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse listMonitoredResourceDescriptors(ProjectName name) {
        ListMonitoredResourceDescriptorsRequest request = ListMonitoredResourceDescriptorsRequest.newBuilder().setNameWithProjectName(name).build();
        return this.listMonitoredResourceDescriptors(request);
    }

    public final PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse listMonitoredResourceDescriptors(ListMonitoredResourceDescriptorsRequest request) {
        return (PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse)((Object)this.listMonitoredResourceDescriptorsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListMonitoredResourceDescriptorsRequest, PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse> listMonitoredResourceDescriptorsPagedCallable() {
        return this.listMonitoredResourceDescriptorsPagedCallable;
    }

    public final UnaryCallable<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse> listMonitoredResourceDescriptorsCallable() {
        return this.listMonitoredResourceDescriptorsCallable;
    }

    public final MonitoredResourceDescriptor getMonitoredResourceDescriptor(MonitoredResourceDescriptorName name) {
        GetMonitoredResourceDescriptorRequest request = GetMonitoredResourceDescriptorRequest.newBuilder().setNameWithMonitoredResourceDescriptorName(name).build();
        return this.getMonitoredResourceDescriptor(request);
    }

    private final MonitoredResourceDescriptor getMonitoredResourceDescriptor(GetMonitoredResourceDescriptorRequest request) {
        return (MonitoredResourceDescriptor)this.getMonitoredResourceDescriptorCallable().call((Object)request);
    }

    public final UnaryCallable<GetMonitoredResourceDescriptorRequest, MonitoredResourceDescriptor> getMonitoredResourceDescriptorCallable() {
        return this.getMonitoredResourceDescriptorCallable;
    }

    public final PagedResponseWrappers.ListMetricDescriptorsPagedResponse listMetricDescriptors(ProjectName name) {
        ListMetricDescriptorsRequest request = ListMetricDescriptorsRequest.newBuilder().setNameWithProjectName(name).build();
        return this.listMetricDescriptors(request);
    }

    public final PagedResponseWrappers.ListMetricDescriptorsPagedResponse listMetricDescriptors(ListMetricDescriptorsRequest request) {
        return (PagedResponseWrappers.ListMetricDescriptorsPagedResponse)((Object)this.listMetricDescriptorsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListMetricDescriptorsRequest, PagedResponseWrappers.ListMetricDescriptorsPagedResponse> listMetricDescriptorsPagedCallable() {
        return this.listMetricDescriptorsPagedCallable;
    }

    public final UnaryCallable<ListMetricDescriptorsRequest, ListMetricDescriptorsResponse> listMetricDescriptorsCallable() {
        return this.listMetricDescriptorsCallable;
    }

    public final MetricDescriptor getMetricDescriptor(MetricDescriptorName name) {
        GetMetricDescriptorRequest request = GetMetricDescriptorRequest.newBuilder().setNameWithMetricDescriptorName(name).build();
        return this.getMetricDescriptor(request);
    }

    private final MetricDescriptor getMetricDescriptor(GetMetricDescriptorRequest request) {
        return (MetricDescriptor)this.getMetricDescriptorCallable().call((Object)request);
    }

    public final UnaryCallable<GetMetricDescriptorRequest, MetricDescriptor> getMetricDescriptorCallable() {
        return this.getMetricDescriptorCallable;
    }

    public final MetricDescriptor createMetricDescriptor(ProjectName name, MetricDescriptor metricDescriptor) {
        CreateMetricDescriptorRequest request = CreateMetricDescriptorRequest.newBuilder().setNameWithProjectName(name).setMetricDescriptor(metricDescriptor).build();
        return this.createMetricDescriptor(request);
    }

    public final MetricDescriptor createMetricDescriptor(CreateMetricDescriptorRequest request) {
        return (MetricDescriptor)this.createMetricDescriptorCallable().call((Object)request);
    }

    public final UnaryCallable<CreateMetricDescriptorRequest, MetricDescriptor> createMetricDescriptorCallable() {
        return this.createMetricDescriptorCallable;
    }

    public final void deleteMetricDescriptor(MetricDescriptorName name) {
        DeleteMetricDescriptorRequest request = DeleteMetricDescriptorRequest.newBuilder().setNameWithMetricDescriptorName(name).build();
        this.deleteMetricDescriptor(request);
    }

    private final void deleteMetricDescriptor(DeleteMetricDescriptorRequest request) {
        this.deleteMetricDescriptorCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteMetricDescriptorRequest, Empty> deleteMetricDescriptorCallable() {
        return this.deleteMetricDescriptorCallable;
    }

    public final PagedResponseWrappers.ListTimeSeriesPagedResponse listTimeSeries(ProjectName name, String filter, TimeInterval interval, ListTimeSeriesRequest.TimeSeriesView view) {
        ListTimeSeriesRequest request = ListTimeSeriesRequest.newBuilder().setNameWithProjectName(name).setFilter(filter).setInterval(interval).setView(view).build();
        return this.listTimeSeries(request);
    }

    public final PagedResponseWrappers.ListTimeSeriesPagedResponse listTimeSeries(ListTimeSeriesRequest request) {
        return (PagedResponseWrappers.ListTimeSeriesPagedResponse)((Object)this.listTimeSeriesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTimeSeriesRequest, PagedResponseWrappers.ListTimeSeriesPagedResponse> listTimeSeriesPagedCallable() {
        return this.listTimeSeriesPagedCallable;
    }

    public final UnaryCallable<ListTimeSeriesRequest, ListTimeSeriesResponse> listTimeSeriesCallable() {
        return this.listTimeSeriesCallable;
    }

    public final void createTimeSeries(ProjectName name, List<TimeSeries> timeSeries) {
        CreateTimeSeriesRequest request = CreateTimeSeriesRequest.newBuilder().setNameWithProjectName(name).addAllTimeSeries(timeSeries).build();
        this.createTimeSeries(request);
    }

    public final void createTimeSeries(CreateTimeSeriesRequest request) {
        this.createTimeSeriesCallable().call((Object)request);
    }

    public final UnaryCallable<CreateTimeSeriesRequest, Empty> createTimeSeriesCallable() {
        return this.createTimeSeriesCallable;
    }

    @Override
    public final void close() throws Exception {
        for (AutoCloseable closeable : this.closeables) {
            closeable.close();
        }
    }
}

