/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.monitoring.v3.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ClientSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.monitoring.v3.GroupServiceSettings;
import com.google.cloud.monitoring.v3.PagedResponseWrappers;
import com.google.cloud.monitoring.v3.stub.GroupServiceStub;
import com.google.monitoring.v3.CreateGroupRequest;
import com.google.monitoring.v3.DeleteGroupRequest;
import com.google.monitoring.v3.GetGroupRequest;
import com.google.monitoring.v3.Group;
import com.google.monitoring.v3.ListGroupMembersRequest;
import com.google.monitoring.v3.ListGroupMembersResponse;
import com.google.monitoring.v3.ListGroupsRequest;
import com.google.monitoring.v3.ListGroupsResponse;
import com.google.monitoring.v3.UpdateGroupRequest;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcGroupServiceStub
extends GroupServiceStub {
    private static final UnaryCallable<ListGroupsRequest, ListGroupsResponse> directListGroupsCallable = GrpcCallableFactory.createDirectCallable((MethodDescriptor)MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.monitoring.v3.GroupService/ListGroups", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)ListGroupsRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)ListGroupsResponse.getDefaultInstance())));
    private static final UnaryCallable<GetGroupRequest, Group> directGetGroupCallable = GrpcCallableFactory.createDirectCallable((MethodDescriptor)MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.monitoring.v3.GroupService/GetGroup", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)GetGroupRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Group.getDefaultInstance())));
    private static final UnaryCallable<CreateGroupRequest, Group> directCreateGroupCallable = GrpcCallableFactory.createDirectCallable((MethodDescriptor)MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.monitoring.v3.GroupService/CreateGroup", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)CreateGroupRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Group.getDefaultInstance())));
    private static final UnaryCallable<UpdateGroupRequest, Group> directUpdateGroupCallable = GrpcCallableFactory.createDirectCallable((MethodDescriptor)MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.monitoring.v3.GroupService/UpdateGroup", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)UpdateGroupRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Group.getDefaultInstance())));
    private static final UnaryCallable<DeleteGroupRequest, Empty> directDeleteGroupCallable = GrpcCallableFactory.createDirectCallable((MethodDescriptor)MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.monitoring.v3.GroupService/DeleteGroup", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)DeleteGroupRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)Empty.getDefaultInstance())));
    private static final UnaryCallable<ListGroupMembersRequest, ListGroupMembersResponse> directListGroupMembersCallable = GrpcCallableFactory.createDirectCallable((MethodDescriptor)MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)"google.monitoring.v3.GroupService/ListGroupMembers", (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)ListGroupMembersRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((Message)ListGroupMembersResponse.getDefaultInstance())));
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<ListGroupsRequest, ListGroupsResponse> listGroupsCallable;
    private final UnaryCallable<ListGroupsRequest, PagedResponseWrappers.ListGroupsPagedResponse> listGroupsPagedCallable;
    private final UnaryCallable<GetGroupRequest, Group> getGroupCallable;
    private final UnaryCallable<CreateGroupRequest, Group> createGroupCallable;
    private final UnaryCallable<UpdateGroupRequest, Group> updateGroupCallable;
    private final UnaryCallable<DeleteGroupRequest, Empty> deleteGroupCallable;
    private final UnaryCallable<ListGroupMembersRequest, ListGroupMembersResponse> listGroupMembersCallable;
    private final UnaryCallable<ListGroupMembersRequest, PagedResponseWrappers.ListGroupMembersPagedResponse> listGroupMembersPagedCallable;

    public static final GrpcGroupServiceStub create(GroupServiceSettings settings) throws IOException {
        return new GrpcGroupServiceStub(settings, ClientContext.create((ClientSettings)settings));
    }

    public static final GrpcGroupServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcGroupServiceStub(GroupServiceSettings.defaultBuilder().build(), clientContext);
    }

    protected GrpcGroupServiceStub(GroupServiceSettings settings, ClientContext clientContext) throws IOException {
        this.listGroupsCallable = GrpcCallableFactory.create(directListGroupsCallable, settings.listGroupsSettings(), (ClientContext)clientContext);
        this.listGroupsPagedCallable = GrpcCallableFactory.createPagedVariant(directListGroupsCallable, settings.listGroupsSettings(), (ClientContext)clientContext);
        this.getGroupCallable = GrpcCallableFactory.create(directGetGroupCallable, settings.getGroupSettings(), (ClientContext)clientContext);
        this.createGroupCallable = GrpcCallableFactory.create(directCreateGroupCallable, settings.createGroupSettings(), (ClientContext)clientContext);
        this.updateGroupCallable = GrpcCallableFactory.create(directUpdateGroupCallable, settings.updateGroupSettings(), (ClientContext)clientContext);
        this.deleteGroupCallable = GrpcCallableFactory.create(directDeleteGroupCallable, settings.deleteGroupSettings(), (ClientContext)clientContext);
        this.listGroupMembersCallable = GrpcCallableFactory.create(directListGroupMembersCallable, settings.listGroupMembersSettings(), (ClientContext)clientContext);
        this.listGroupMembersPagedCallable = GrpcCallableFactory.createPagedVariant(directListGroupMembersCallable, settings.listGroupMembersSettings(), (ClientContext)clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    public UnaryCallable<ListGroupsRequest, PagedResponseWrappers.ListGroupsPagedResponse> listGroupsPagedCallable() {
        return this.listGroupsPagedCallable;
    }

    @Override
    public UnaryCallable<ListGroupsRequest, ListGroupsResponse> listGroupsCallable() {
        return this.listGroupsCallable;
    }

    @Override
    public UnaryCallable<GetGroupRequest, Group> getGroupCallable() {
        return this.getGroupCallable;
    }

    @Override
    public UnaryCallable<CreateGroupRequest, Group> createGroupCallable() {
        return this.createGroupCallable;
    }

    @Override
    public UnaryCallable<UpdateGroupRequest, Group> updateGroupCallable() {
        return this.updateGroupCallable;
    }

    @Override
    public UnaryCallable<DeleteGroupRequest, Empty> deleteGroupCallable() {
        return this.deleteGroupCallable;
    }

    @Override
    public UnaryCallable<ListGroupMembersRequest, PagedResponseWrappers.ListGroupMembersPagedResponse> listGroupMembersPagedCallable() {
        return this.listGroupMembersPagedCallable;
    }

    @Override
    public UnaryCallable<ListGroupMembersRequest, ListGroupMembersResponse> listGroupMembersCallable() {
        return this.listGroupMembersCallable;
    }

    public final void close() throws Exception {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

