/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.monitoring.v3;

import com.google.api.MetricDescriptor;
import com.google.api.MonitoredResourceDescriptor;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.monitoring.v3.MetricServiceSettings;
import com.google.cloud.monitoring.v3.PagedResponseWrappers;
import com.google.cloud.monitoring.v3.stub.MetricServiceStub;
import com.google.monitoring.v3.CreateMetricDescriptorRequest;
import com.google.monitoring.v3.CreateTimeSeriesRequest;
import com.google.monitoring.v3.DeleteMetricDescriptorRequest;
import com.google.monitoring.v3.GetMetricDescriptorRequest;
import com.google.monitoring.v3.GetMonitoredResourceDescriptorRequest;
import com.google.monitoring.v3.ListMetricDescriptorsRequest;
import com.google.monitoring.v3.ListMetricDescriptorsResponse;
import com.google.monitoring.v3.ListMonitoredResourceDescriptorsRequest;
import com.google.monitoring.v3.ListMonitoredResourceDescriptorsResponse;
import com.google.monitoring.v3.ListTimeSeriesRequest;
import com.google.monitoring.v3.ListTimeSeriesResponse;
import com.google.monitoring.v3.MetricDescriptorName;
import com.google.monitoring.v3.MonitoredResourceDescriptorName;
import com.google.monitoring.v3.ProjectName;
import com.google.monitoring.v3.TimeInterval;
import com.google.monitoring.v3.TimeSeries;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class MetricServiceClient
implements BackgroundResource {
    private final MetricServiceSettings settings;
    private final MetricServiceStub stub;

    public static final MetricServiceClient create() throws IOException {
        return MetricServiceClient.create(MetricServiceSettings.newBuilder().build());
    }

    public static final MetricServiceClient create(MetricServiceSettings settings) throws IOException {
        return new MetricServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final MetricServiceClient create(MetricServiceStub stub) {
        return new MetricServiceClient(stub);
    }

    protected MetricServiceClient(MetricServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = settings.createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected MetricServiceClient(MetricServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final MetricServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public MetricServiceStub getStub() {
        return this.stub;
    }

    public final PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse listMonitoredResourceDescriptors(ProjectName name) {
        ListMonitoredResourceDescriptorsRequest request = ListMonitoredResourceDescriptorsRequest.newBuilder().setNameWithProjectName(name).build();
        return this.listMonitoredResourceDescriptors(request);
    }

    public final PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse listMonitoredResourceDescriptors(ListMonitoredResourceDescriptorsRequest request) {
        return (PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse)((Object)this.listMonitoredResourceDescriptorsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListMonitoredResourceDescriptorsRequest, PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse> listMonitoredResourceDescriptorsPagedCallable() {
        return this.stub.listMonitoredResourceDescriptorsPagedCallable();
    }

    public final UnaryCallable<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse> listMonitoredResourceDescriptorsCallable() {
        return this.stub.listMonitoredResourceDescriptorsCallable();
    }

    public final MonitoredResourceDescriptor getMonitoredResourceDescriptor(MonitoredResourceDescriptorName name) {
        GetMonitoredResourceDescriptorRequest request = GetMonitoredResourceDescriptorRequest.newBuilder().setNameWithMonitoredResourceDescriptorName(name).build();
        return this.getMonitoredResourceDescriptor(request);
    }

    private final MonitoredResourceDescriptor getMonitoredResourceDescriptor(GetMonitoredResourceDescriptorRequest request) {
        return (MonitoredResourceDescriptor)this.getMonitoredResourceDescriptorCallable().call((Object)request);
    }

    public final UnaryCallable<GetMonitoredResourceDescriptorRequest, MonitoredResourceDescriptor> getMonitoredResourceDescriptorCallable() {
        return this.stub.getMonitoredResourceDescriptorCallable();
    }

    public final PagedResponseWrappers.ListMetricDescriptorsPagedResponse listMetricDescriptors(ProjectName name) {
        ListMetricDescriptorsRequest request = ListMetricDescriptorsRequest.newBuilder().setNameWithProjectName(name).build();
        return this.listMetricDescriptors(request);
    }

    public final PagedResponseWrappers.ListMetricDescriptorsPagedResponse listMetricDescriptors(ListMetricDescriptorsRequest request) {
        return (PagedResponseWrappers.ListMetricDescriptorsPagedResponse)((Object)this.listMetricDescriptorsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListMetricDescriptorsRequest, PagedResponseWrappers.ListMetricDescriptorsPagedResponse> listMetricDescriptorsPagedCallable() {
        return this.stub.listMetricDescriptorsPagedCallable();
    }

    public final UnaryCallable<ListMetricDescriptorsRequest, ListMetricDescriptorsResponse> listMetricDescriptorsCallable() {
        return this.stub.listMetricDescriptorsCallable();
    }

    public final MetricDescriptor getMetricDescriptor(MetricDescriptorName name) {
        GetMetricDescriptorRequest request = GetMetricDescriptorRequest.newBuilder().setNameWithMetricDescriptorName(name).build();
        return this.getMetricDescriptor(request);
    }

    private final MetricDescriptor getMetricDescriptor(GetMetricDescriptorRequest request) {
        return (MetricDescriptor)this.getMetricDescriptorCallable().call((Object)request);
    }

    public final UnaryCallable<GetMetricDescriptorRequest, MetricDescriptor> getMetricDescriptorCallable() {
        return this.stub.getMetricDescriptorCallable();
    }

    public final MetricDescriptor createMetricDescriptor(ProjectName name, MetricDescriptor metricDescriptor) {
        CreateMetricDescriptorRequest request = CreateMetricDescriptorRequest.newBuilder().setNameWithProjectName(name).setMetricDescriptor(metricDescriptor).build();
        return this.createMetricDescriptor(request);
    }

    public final MetricDescriptor createMetricDescriptor(CreateMetricDescriptorRequest request) {
        return (MetricDescriptor)this.createMetricDescriptorCallable().call((Object)request);
    }

    public final UnaryCallable<CreateMetricDescriptorRequest, MetricDescriptor> createMetricDescriptorCallable() {
        return this.stub.createMetricDescriptorCallable();
    }

    public final void deleteMetricDescriptor(MetricDescriptorName name) {
        DeleteMetricDescriptorRequest request = DeleteMetricDescriptorRequest.newBuilder().setNameWithMetricDescriptorName(name).build();
        this.deleteMetricDescriptor(request);
    }

    private final void deleteMetricDescriptor(DeleteMetricDescriptorRequest request) {
        this.deleteMetricDescriptorCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteMetricDescriptorRequest, Empty> deleteMetricDescriptorCallable() {
        return this.stub.deleteMetricDescriptorCallable();
    }

    public final PagedResponseWrappers.ListTimeSeriesPagedResponse listTimeSeries(ProjectName name, String filter, TimeInterval interval, ListTimeSeriesRequest.TimeSeriesView view) {
        ListTimeSeriesRequest request = ListTimeSeriesRequest.newBuilder().setNameWithProjectName(name).setFilter(filter).setInterval(interval).setView(view).build();
        return this.listTimeSeries(request);
    }

    public final PagedResponseWrappers.ListTimeSeriesPagedResponse listTimeSeries(ListTimeSeriesRequest request) {
        return (PagedResponseWrappers.ListTimeSeriesPagedResponse)((Object)this.listTimeSeriesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTimeSeriesRequest, PagedResponseWrappers.ListTimeSeriesPagedResponse> listTimeSeriesPagedCallable() {
        return this.stub.listTimeSeriesPagedCallable();
    }

    public final UnaryCallable<ListTimeSeriesRequest, ListTimeSeriesResponse> listTimeSeriesCallable() {
        return this.stub.listTimeSeriesCallable();
    }

    public final void createTimeSeries(ProjectName name, List<TimeSeries> timeSeries) {
        CreateTimeSeriesRequest request = CreateTimeSeriesRequest.newBuilder().setNameWithProjectName(name).addAllTimeSeries(timeSeries).build();
        this.createTimeSeries(request);
    }

    public final void createTimeSeries(CreateTimeSeriesRequest request) {
        this.createTimeSeriesCallable().call((Object)request);
    }

    public final UnaryCallable<CreateTimeSeriesRequest, Empty> createTimeSeriesCallable() {
        return this.stub.createTimeSeriesCallable();
    }

    public final void close() throws Exception {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

