/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.monitoring.v3;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.monitoring.v3.GroupServiceSettings;
import com.google.cloud.monitoring.v3.PagedResponseWrappers;
import com.google.cloud.monitoring.v3.stub.GroupServiceStub;
import com.google.monitoring.v3.CreateGroupRequest;
import com.google.monitoring.v3.DeleteGroupRequest;
import com.google.monitoring.v3.GetGroupRequest;
import com.google.monitoring.v3.Group;
import com.google.monitoring.v3.GroupName;
import com.google.monitoring.v3.ListGroupMembersRequest;
import com.google.monitoring.v3.ListGroupMembersResponse;
import com.google.monitoring.v3.ListGroupsRequest;
import com.google.monitoring.v3.ListGroupsResponse;
import com.google.monitoring.v3.ProjectName;
import com.google.monitoring.v3.UpdateGroupRequest;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GroupServiceClient
implements BackgroundResource {
    private final GroupServiceSettings settings;
    private final GroupServiceStub stub;

    public static final GroupServiceClient create() throws IOException {
        return GroupServiceClient.create(GroupServiceSettings.newBuilder().build());
    }

    public static final GroupServiceClient create(GroupServiceSettings settings) throws IOException {
        return new GroupServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final GroupServiceClient create(GroupServiceStub stub) {
        return new GroupServiceClient(stub);
    }

    protected GroupServiceClient(GroupServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = settings.createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected GroupServiceClient(GroupServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final GroupServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public GroupServiceStub getStub() {
        return this.stub;
    }

    public final PagedResponseWrappers.ListGroupsPagedResponse listGroups(ListGroupsRequest request) {
        return (PagedResponseWrappers.ListGroupsPagedResponse)((Object)this.listGroupsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListGroupsRequest, PagedResponseWrappers.ListGroupsPagedResponse> listGroupsPagedCallable() {
        return this.stub.listGroupsPagedCallable();
    }

    public final UnaryCallable<ListGroupsRequest, ListGroupsResponse> listGroupsCallable() {
        return this.stub.listGroupsCallable();
    }

    public final Group getGroup(GroupName name) {
        GetGroupRequest request = GetGroupRequest.newBuilder().setNameWithGroupName(name).build();
        return this.getGroup(request);
    }

    private final Group getGroup(GetGroupRequest request) {
        return (Group)this.getGroupCallable().call((Object)request);
    }

    public final UnaryCallable<GetGroupRequest, Group> getGroupCallable() {
        return this.stub.getGroupCallable();
    }

    public final Group createGroup(ProjectName name, Group group) {
        CreateGroupRequest request = CreateGroupRequest.newBuilder().setNameWithProjectName(name).setGroup(group).build();
        return this.createGroup(request);
    }

    public final Group createGroup(CreateGroupRequest request) {
        return (Group)this.createGroupCallable().call((Object)request);
    }

    public final UnaryCallable<CreateGroupRequest, Group> createGroupCallable() {
        return this.stub.createGroupCallable();
    }

    public final Group updateGroup(Group group) {
        UpdateGroupRequest request = UpdateGroupRequest.newBuilder().setGroup(group).build();
        return this.updateGroup(request);
    }

    public final Group updateGroup(UpdateGroupRequest request) {
        return (Group)this.updateGroupCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateGroupRequest, Group> updateGroupCallable() {
        return this.stub.updateGroupCallable();
    }

    public final void deleteGroup(GroupName name) {
        DeleteGroupRequest request = DeleteGroupRequest.newBuilder().setNameWithGroupName(name).build();
        this.deleteGroup(request);
    }

    private final void deleteGroup(DeleteGroupRequest request) {
        this.deleteGroupCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteGroupRequest, Empty> deleteGroupCallable() {
        return this.stub.deleteGroupCallable();
    }

    public final PagedResponseWrappers.ListGroupMembersPagedResponse listGroupMembers(GroupName name) {
        ListGroupMembersRequest request = ListGroupMembersRequest.newBuilder().setNameWithGroupName(name).build();
        return this.listGroupMembers(request);
    }

    public final PagedResponseWrappers.ListGroupMembersPagedResponse listGroupMembers(ListGroupMembersRequest request) {
        return (PagedResponseWrappers.ListGroupMembersPagedResponse)((Object)this.listGroupMembersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListGroupMembersRequest, PagedResponseWrappers.ListGroupMembersPagedResponse> listGroupMembersPagedCallable() {
        return this.stub.listGroupMembersPagedCallable();
    }

    public final UnaryCallable<ListGroupMembersRequest, ListGroupMembersResponse> listGroupMembersCallable() {
        return this.stub.listGroupMembersCallable();
    }

    public final void close() throws Exception {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

