/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.monitoring.v3;

import com.google.api.MetricDescriptor;
import com.google.api.MonitoredResourceDescriptor;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ClientSettings;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.monitoring.v3.PagedResponseWrappers;
import com.google.cloud.monitoring.v3.stub.GrpcMetricServiceStub;
import com.google.cloud.monitoring.v3.stub.MetricServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.monitoring.v3.CreateMetricDescriptorRequest;
import com.google.monitoring.v3.CreateTimeSeriesRequest;
import com.google.monitoring.v3.DeleteMetricDescriptorRequest;
import com.google.monitoring.v3.GetMetricDescriptorRequest;
import com.google.monitoring.v3.GetMonitoredResourceDescriptorRequest;
import com.google.monitoring.v3.ListMetricDescriptorsRequest;
import com.google.monitoring.v3.ListMetricDescriptorsResponse;
import com.google.monitoring.v3.ListMonitoredResourceDescriptorsRequest;
import com.google.monitoring.v3.ListMonitoredResourceDescriptorsResponse;
import com.google.monitoring.v3.ListTimeSeriesRequest;
import com.google.monitoring.v3.ListTimeSeriesResponse;
import com.google.monitoring.v3.TimeSeries;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class MetricServiceSettings
extends ClientSettings<MetricServiceSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/monitoring").add((Object)"https://www.googleapis.com/auth/monitoring.read").add((Object)"https://www.googleapis.com/auth/monitoring.write").build();
    private final PagedCallSettings<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse> listMonitoredResourceDescriptorsSettings;
    private final UnaryCallSettings<GetMonitoredResourceDescriptorRequest, MonitoredResourceDescriptor> getMonitoredResourceDescriptorSettings;
    private final PagedCallSettings<ListMetricDescriptorsRequest, ListMetricDescriptorsResponse, PagedResponseWrappers.ListMetricDescriptorsPagedResponse> listMetricDescriptorsSettings;
    private final UnaryCallSettings<GetMetricDescriptorRequest, MetricDescriptor> getMetricDescriptorSettings;
    private final UnaryCallSettings<CreateMetricDescriptorRequest, MetricDescriptor> createMetricDescriptorSettings;
    private final UnaryCallSettings<DeleteMetricDescriptorRequest, Empty> deleteMetricDescriptorSettings;
    private final PagedCallSettings<ListTimeSeriesRequest, ListTimeSeriesResponse, PagedResponseWrappers.ListTimeSeriesPagedResponse> listTimeSeriesSettings;
    private final UnaryCallSettings<CreateTimeSeriesRequest, Empty> createTimeSeriesSettings;
    private static final PagedListDescriptor<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, MonitoredResourceDescriptor> LIST_MONITORED_RESOURCE_DESCRIPTORS_PAGE_STR_DESC = new PagedListDescriptor<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, MonitoredResourceDescriptor>(){

        public String emptyToken() {
            return "";
        }

        public ListMonitoredResourceDescriptorsRequest injectToken(ListMonitoredResourceDescriptorsRequest payload, String token) {
            return ListMonitoredResourceDescriptorsRequest.newBuilder((ListMonitoredResourceDescriptorsRequest)payload).setPageToken(token).build();
        }

        public ListMonitoredResourceDescriptorsRequest injectPageSize(ListMonitoredResourceDescriptorsRequest payload, int pageSize) {
            return ListMonitoredResourceDescriptorsRequest.newBuilder((ListMonitoredResourceDescriptorsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListMonitoredResourceDescriptorsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListMonitoredResourceDescriptorsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<MonitoredResourceDescriptor> extractResources(ListMonitoredResourceDescriptorsResponse payload) {
            return payload.getResourceDescriptorsList();
        }
    };
    private static final PagedListDescriptor<ListMetricDescriptorsRequest, ListMetricDescriptorsResponse, MetricDescriptor> LIST_METRIC_DESCRIPTORS_PAGE_STR_DESC = new PagedListDescriptor<ListMetricDescriptorsRequest, ListMetricDescriptorsResponse, MetricDescriptor>(){

        public String emptyToken() {
            return "";
        }

        public ListMetricDescriptorsRequest injectToken(ListMetricDescriptorsRequest payload, String token) {
            return ListMetricDescriptorsRequest.newBuilder((ListMetricDescriptorsRequest)payload).setPageToken(token).build();
        }

        public ListMetricDescriptorsRequest injectPageSize(ListMetricDescriptorsRequest payload, int pageSize) {
            return ListMetricDescriptorsRequest.newBuilder((ListMetricDescriptorsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListMetricDescriptorsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListMetricDescriptorsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<MetricDescriptor> extractResources(ListMetricDescriptorsResponse payload) {
            return payload.getMetricDescriptorsList();
        }
    };
    private static final PagedListDescriptor<ListTimeSeriesRequest, ListTimeSeriesResponse, TimeSeries> LIST_TIME_SERIES_PAGE_STR_DESC = new PagedListDescriptor<ListTimeSeriesRequest, ListTimeSeriesResponse, TimeSeries>(){

        public String emptyToken() {
            return "";
        }

        public ListTimeSeriesRequest injectToken(ListTimeSeriesRequest payload, String token) {
            return ListTimeSeriesRequest.newBuilder((ListTimeSeriesRequest)payload).setPageToken(token).build();
        }

        public ListTimeSeriesRequest injectPageSize(ListTimeSeriesRequest payload, int pageSize) {
            return ListTimeSeriesRequest.newBuilder((ListTimeSeriesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTimeSeriesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTimeSeriesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TimeSeries> extractResources(ListTimeSeriesResponse payload) {
            return payload.getTimeSeriesList();
        }
    };
    private static final PagedListResponseFactory<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse> LIST_MONITORED_RESOURCE_DESCRIPTORS_PAGE_STR_FACT = new PagedListResponseFactory<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse>(){

        public ApiFuture<PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse> getFuturePagedResponse(UnaryCallable<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse> callable, ListMonitoredResourceDescriptorsRequest request, ApiCallContext context, ApiFuture<ListMonitoredResourceDescriptorsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_MONITORED_RESOURCE_DESCRIPTORS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse.createAsync((PageContext<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, MonitoredResourceDescriptor>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListMetricDescriptorsRequest, ListMetricDescriptorsResponse, PagedResponseWrappers.ListMetricDescriptorsPagedResponse> LIST_METRIC_DESCRIPTORS_PAGE_STR_FACT = new PagedListResponseFactory<ListMetricDescriptorsRequest, ListMetricDescriptorsResponse, PagedResponseWrappers.ListMetricDescriptorsPagedResponse>(){

        public ApiFuture<PagedResponseWrappers.ListMetricDescriptorsPagedResponse> getFuturePagedResponse(UnaryCallable<ListMetricDescriptorsRequest, ListMetricDescriptorsResponse> callable, ListMetricDescriptorsRequest request, ApiCallContext context, ApiFuture<ListMetricDescriptorsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_METRIC_DESCRIPTORS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return PagedResponseWrappers.ListMetricDescriptorsPagedResponse.createAsync((PageContext<ListMetricDescriptorsRequest, ListMetricDescriptorsResponse, MetricDescriptor>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListTimeSeriesRequest, ListTimeSeriesResponse, PagedResponseWrappers.ListTimeSeriesPagedResponse> LIST_TIME_SERIES_PAGE_STR_FACT = new PagedListResponseFactory<ListTimeSeriesRequest, ListTimeSeriesResponse, PagedResponseWrappers.ListTimeSeriesPagedResponse>(){

        public ApiFuture<PagedResponseWrappers.ListTimeSeriesPagedResponse> getFuturePagedResponse(UnaryCallable<ListTimeSeriesRequest, ListTimeSeriesResponse> callable, ListTimeSeriesRequest request, ApiCallContext context, ApiFuture<ListTimeSeriesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TIME_SERIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return PagedResponseWrappers.ListTimeSeriesPagedResponse.createAsync((PageContext<ListTimeSeriesRequest, ListTimeSeriesResponse, TimeSeries>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse> listMonitoredResourceDescriptorsSettings() {
        return this.listMonitoredResourceDescriptorsSettings;
    }

    public UnaryCallSettings<GetMonitoredResourceDescriptorRequest, MonitoredResourceDescriptor> getMonitoredResourceDescriptorSettings() {
        return this.getMonitoredResourceDescriptorSettings;
    }

    public PagedCallSettings<ListMetricDescriptorsRequest, ListMetricDescriptorsResponse, PagedResponseWrappers.ListMetricDescriptorsPagedResponse> listMetricDescriptorsSettings() {
        return this.listMetricDescriptorsSettings;
    }

    public UnaryCallSettings<GetMetricDescriptorRequest, MetricDescriptor> getMetricDescriptorSettings() {
        return this.getMetricDescriptorSettings;
    }

    public UnaryCallSettings<CreateMetricDescriptorRequest, MetricDescriptor> createMetricDescriptorSettings() {
        return this.createMetricDescriptorSettings;
    }

    public UnaryCallSettings<DeleteMetricDescriptorRequest, Empty> deleteMetricDescriptorSettings() {
        return this.deleteMetricDescriptorSettings;
    }

    public PagedCallSettings<ListTimeSeriesRequest, ListTimeSeriesResponse, PagedResponseWrappers.ListTimeSeriesPagedResponse> listTimeSeriesSettings() {
        return this.listTimeSeriesSettings;
    }

    public UnaryCallSettings<CreateTimeSeriesRequest, Empty> createTimeSeriesSettings() {
        return this.createTimeSeriesSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public MetricServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcMetricServiceStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "monitoring.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return MetricServiceSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(MetricServiceSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected MetricServiceSettings(Builder settingsBuilder) throws IOException {
        super((ClientSettings.Builder)settingsBuilder);
        this.listMonitoredResourceDescriptorsSettings = settingsBuilder.listMonitoredResourceDescriptorsSettings().build();
        this.getMonitoredResourceDescriptorSettings = settingsBuilder.getMonitoredResourceDescriptorSettings().build();
        this.listMetricDescriptorsSettings = settingsBuilder.listMetricDescriptorsSettings().build();
        this.getMetricDescriptorSettings = settingsBuilder.getMetricDescriptorSettings().build();
        this.createMetricDescriptorSettings = settingsBuilder.createMetricDescriptorSettings().build();
        this.deleteMetricDescriptorSettings = settingsBuilder.deleteMetricDescriptorSettings().build();
        this.listTimeSeriesSettings = settingsBuilder.listTimeSeriesSettings().build();
        this.createTimeSeriesSettings = settingsBuilder.createTimeSeriesSettings().build();
    }

    public static class Builder
    extends ClientSettings.Builder<MetricServiceSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse> listMonitoredResourceDescriptorsSettings;
        private final UnaryCallSettings.Builder<GetMonitoredResourceDescriptorRequest, MonitoredResourceDescriptor> getMonitoredResourceDescriptorSettings;
        private final PagedCallSettings.Builder<ListMetricDescriptorsRequest, ListMetricDescriptorsResponse, PagedResponseWrappers.ListMetricDescriptorsPagedResponse> listMetricDescriptorsSettings;
        private final UnaryCallSettings.Builder<GetMetricDescriptorRequest, MetricDescriptor> getMetricDescriptorSettings;
        private final UnaryCallSettings.Builder<CreateMetricDescriptorRequest, MetricDescriptor> createMetricDescriptorSettings;
        private final UnaryCallSettings.Builder<DeleteMetricDescriptorRequest, Empty> deleteMetricDescriptorSettings;
        private final PagedCallSettings.Builder<ListTimeSeriesRequest, ListTimeSeriesResponse, PagedResponseWrappers.ListTimeSeriesPagedResponse> listTimeSeriesSettings;
        private final UnaryCallSettings.Builder<CreateTimeSeriesRequest, Empty> createTimeSeriesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listMonitoredResourceDescriptorsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_MONITORED_RESOURCE_DESCRIPTORS_PAGE_STR_FACT);
            this.getMonitoredResourceDescriptorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listMetricDescriptorsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_METRIC_DESCRIPTORS_PAGE_STR_FACT);
            this.getMetricDescriptorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createMetricDescriptorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteMetricDescriptorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listTimeSeriesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TIME_SERIES_PAGE_STR_FACT);
            this.createTimeSeriesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listMonitoredResourceDescriptorsSettings, this.getMonitoredResourceDescriptorSettings, this.listMetricDescriptorsSettings, this.getMetricDescriptorSettings, this.createMetricDescriptorSettings, this.deleteMetricDescriptorSettings, this.listTimeSeriesSettings, this.createTimeSeriesSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(MetricServiceSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)MetricServiceSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)MetricServiceSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(MetricServiceSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listMonitoredResourceDescriptorsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getMonitoredResourceDescriptorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listMetricDescriptorsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getMetricDescriptorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createMetricDescriptorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteMetricDescriptorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listTimeSeriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createTimeSeriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(MetricServiceSettings settings) {
            super((ClientSettings)settings);
            this.listMonitoredResourceDescriptorsSettings = settings.listMonitoredResourceDescriptorsSettings.toBuilder();
            this.getMonitoredResourceDescriptorSettings = settings.getMonitoredResourceDescriptorSettings.toBuilder();
            this.listMetricDescriptorsSettings = settings.listMetricDescriptorsSettings.toBuilder();
            this.getMetricDescriptorSettings = settings.getMetricDescriptorSettings.toBuilder();
            this.createMetricDescriptorSettings = settings.createMetricDescriptorSettings.toBuilder();
            this.deleteMetricDescriptorSettings = settings.deleteMetricDescriptorSettings.toBuilder();
            this.listTimeSeriesSettings = settings.listTimeSeriesSettings.toBuilder();
            this.createTimeSeriesSettings = settings.createTimeSeriesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listMonitoredResourceDescriptorsSettings, this.getMonitoredResourceDescriptorSettings, this.listMetricDescriptorsSettings, this.getMetricDescriptorSettings, this.createMetricDescriptorSettings, this.deleteMetricDescriptorSettings, this.listTimeSeriesSettings, this.createTimeSeriesSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            ClientSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public PagedCallSettings.Builder<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse> listMonitoredResourceDescriptorsSettings() {
            return this.listMonitoredResourceDescriptorsSettings;
        }

        public UnaryCallSettings.Builder<GetMonitoredResourceDescriptorRequest, MonitoredResourceDescriptor> getMonitoredResourceDescriptorSettings() {
            return this.getMonitoredResourceDescriptorSettings;
        }

        public PagedCallSettings.Builder<ListMetricDescriptorsRequest, ListMetricDescriptorsResponse, PagedResponseWrappers.ListMetricDescriptorsPagedResponse> listMetricDescriptorsSettings() {
            return this.listMetricDescriptorsSettings;
        }

        public UnaryCallSettings.Builder<GetMetricDescriptorRequest, MetricDescriptor> getMetricDescriptorSettings() {
            return this.getMetricDescriptorSettings;
        }

        public UnaryCallSettings.Builder<CreateMetricDescriptorRequest, MetricDescriptor> createMetricDescriptorSettings() {
            return this.createMetricDescriptorSettings;
        }

        public UnaryCallSettings.Builder<DeleteMetricDescriptorRequest, Empty> deleteMetricDescriptorSettings() {
            return this.deleteMetricDescriptorSettings;
        }

        public PagedCallSettings.Builder<ListTimeSeriesRequest, ListTimeSeriesResponse, PagedResponseWrappers.ListTimeSeriesPagedResponse> listTimeSeriesSettings() {
            return this.listTimeSeriesSettings;
        }

        public UnaryCallSettings.Builder<CreateTimeSeriesRequest, Empty> createTimeSeriesSettings() {
            return this.createTimeSeriesSettings;
        }

        public MetricServiceSettings build() throws IOException {
            return new MetricServiceSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

