/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.monitoring.v3;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.monitoring.v3.PagedResponseWrappers;
import com.google.cloud.monitoring.v3.UptimeCheckServiceSettings;
import com.google.cloud.monitoring.v3.stub.UptimeCheckServiceStub;
import com.google.monitoring.v3.CreateUptimeCheckConfigRequest;
import com.google.monitoring.v3.DeleteUptimeCheckConfigRequest;
import com.google.monitoring.v3.GetUptimeCheckConfigRequest;
import com.google.monitoring.v3.ListUptimeCheckConfigsRequest;
import com.google.monitoring.v3.ListUptimeCheckConfigsResponse;
import com.google.monitoring.v3.ListUptimeCheckIpsRequest;
import com.google.monitoring.v3.ListUptimeCheckIpsResponse;
import com.google.monitoring.v3.UpdateUptimeCheckConfigRequest;
import com.google.monitoring.v3.UptimeCheckConfig;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class UptimeCheckServiceClient
implements BackgroundResource {
    private final UptimeCheckServiceSettings settings;
    private final UptimeCheckServiceStub stub;

    public static final UptimeCheckServiceClient create() throws IOException {
        return UptimeCheckServiceClient.create(UptimeCheckServiceSettings.newBuilder().build());
    }

    public static final UptimeCheckServiceClient create(UptimeCheckServiceSettings settings) throws IOException {
        return new UptimeCheckServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final UptimeCheckServiceClient create(UptimeCheckServiceStub stub) {
        return new UptimeCheckServiceClient(stub);
    }

    protected UptimeCheckServiceClient(UptimeCheckServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = settings.createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected UptimeCheckServiceClient(UptimeCheckServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final UptimeCheckServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public UptimeCheckServiceStub getStub() {
        return this.stub;
    }

    public final PagedResponseWrappers.ListUptimeCheckConfigsPagedResponse listUptimeCheckConfigs(String parent) {
        ListUptimeCheckConfigsRequest request = ListUptimeCheckConfigsRequest.newBuilder().setParent(parent).build();
        return this.listUptimeCheckConfigs(request);
    }

    public final PagedResponseWrappers.ListUptimeCheckConfigsPagedResponse listUptimeCheckConfigs(ListUptimeCheckConfigsRequest request) {
        return (PagedResponseWrappers.ListUptimeCheckConfigsPagedResponse)((Object)this.listUptimeCheckConfigsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListUptimeCheckConfigsRequest, PagedResponseWrappers.ListUptimeCheckConfigsPagedResponse> listUptimeCheckConfigsPagedCallable() {
        return this.stub.listUptimeCheckConfigsPagedCallable();
    }

    public final UnaryCallable<ListUptimeCheckConfigsRequest, ListUptimeCheckConfigsResponse> listUptimeCheckConfigsCallable() {
        return this.stub.listUptimeCheckConfigsCallable();
    }

    public final UptimeCheckConfig getUptimeCheckConfig(String name) {
        GetUptimeCheckConfigRequest request = GetUptimeCheckConfigRequest.newBuilder().setName(name).build();
        return this.getUptimeCheckConfig(request);
    }

    private final UptimeCheckConfig getUptimeCheckConfig(GetUptimeCheckConfigRequest request) {
        return (UptimeCheckConfig)this.getUptimeCheckConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetUptimeCheckConfigRequest, UptimeCheckConfig> getUptimeCheckConfigCallable() {
        return this.stub.getUptimeCheckConfigCallable();
    }

    public final UptimeCheckConfig createUptimeCheckConfig(String parent, UptimeCheckConfig uptimeCheckConfig) {
        CreateUptimeCheckConfigRequest request = CreateUptimeCheckConfigRequest.newBuilder().setParent(parent).setUptimeCheckConfig(uptimeCheckConfig).build();
        return this.createUptimeCheckConfig(request);
    }

    public final UptimeCheckConfig createUptimeCheckConfig(CreateUptimeCheckConfigRequest request) {
        return (UptimeCheckConfig)this.createUptimeCheckConfigCallable().call((Object)request);
    }

    public final UnaryCallable<CreateUptimeCheckConfigRequest, UptimeCheckConfig> createUptimeCheckConfigCallable() {
        return this.stub.createUptimeCheckConfigCallable();
    }

    public final UptimeCheckConfig updateUptimeCheckConfig(UptimeCheckConfig uptimeCheckConfig) {
        UpdateUptimeCheckConfigRequest request = UpdateUptimeCheckConfigRequest.newBuilder().setUptimeCheckConfig(uptimeCheckConfig).build();
        return this.updateUptimeCheckConfig(request);
    }

    public final UptimeCheckConfig updateUptimeCheckConfig(UpdateUptimeCheckConfigRequest request) {
        return (UptimeCheckConfig)this.updateUptimeCheckConfigCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateUptimeCheckConfigRequest, UptimeCheckConfig> updateUptimeCheckConfigCallable() {
        return this.stub.updateUptimeCheckConfigCallable();
    }

    public final void deleteUptimeCheckConfig(String name) {
        DeleteUptimeCheckConfigRequest request = DeleteUptimeCheckConfigRequest.newBuilder().setName(name).build();
        this.deleteUptimeCheckConfig(request);
    }

    private final void deleteUptimeCheckConfig(DeleteUptimeCheckConfigRequest request) {
        this.deleteUptimeCheckConfigCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteUptimeCheckConfigRequest, Empty> deleteUptimeCheckConfigCallable() {
        return this.stub.deleteUptimeCheckConfigCallable();
    }

    public final PagedResponseWrappers.ListUptimeCheckIpsPagedResponse listUptimeCheckIps(ListUptimeCheckIpsRequest request) {
        return (PagedResponseWrappers.ListUptimeCheckIpsPagedResponse)((Object)this.listUptimeCheckIpsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListUptimeCheckIpsRequest, PagedResponseWrappers.ListUptimeCheckIpsPagedResponse> listUptimeCheckIpsPagedCallable() {
        return this.stub.listUptimeCheckIpsPagedCallable();
    }

    public final UnaryCallable<ListUptimeCheckIpsRequest, ListUptimeCheckIpsResponse> listUptimeCheckIpsCallable() {
        return this.stub.listUptimeCheckIpsCallable();
    }

    public final void close() throws Exception {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

