/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.monitoring.spi.v3;

import com.google.api.MonitoredResource;
import com.google.api.gax.grpc.ApiCallable;
import com.google.api.gax.protobuf.PathTemplate;
import com.google.cloud.monitoring.spi.v3.AgentTranslationServiceSettings;
import com.google.monitoring.v3.CollectdPayload;
import com.google.monitoring.v3.CreateCollectdTimeSeriesRequest;
import com.google.protobuf.Empty;
import io.grpc.ManagedChannel;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

public class AgentTranslationServiceApi
implements AutoCloseable {
    private final AgentTranslationServiceSettings settings;
    private final ManagedChannel channel;
    private final ScheduledExecutorService executor;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private final ApiCallable<CreateCollectdTimeSeriesRequest, Empty> createCollectdTimeSeriesCallable;
    private static final PathTemplate PROJECT_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}");

    public final AgentTranslationServiceSettings getSettings() {
        return this.settings;
    }

    public static final String formatProjectName(String project) {
        return PROJECT_PATH_TEMPLATE.instantiate(new String[]{"project", project});
    }

    public static final String parseProjectFromProjectName(String projectName) {
        return PROJECT_PATH_TEMPLATE.parse(projectName).get((Object)"project");
    }

    public static final AgentTranslationServiceApi create() throws IOException {
        return AgentTranslationServiceApi.create(AgentTranslationServiceSettings.defaultBuilder().build());
    }

    public static final AgentTranslationServiceApi create(AgentTranslationServiceSettings settings) throws IOException {
        return new AgentTranslationServiceApi(settings);
    }

    protected AgentTranslationServiceApi(AgentTranslationServiceSettings settings) throws IOException {
        this.settings = settings;
        this.executor = settings.getExecutorProvider().getOrBuildExecutor();
        this.channel = settings.getChannelProvider().getOrBuildChannel((Executor)this.executor);
        this.createCollectdTimeSeriesCallable = ApiCallable.create(settings.createCollectdTimeSeriesSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        if (settings.getChannelProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    AgentTranslationServiceApi.this.channel.shutdown();
                }
            });
        }
        if (settings.getExecutorProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    AgentTranslationServiceApi.this.executor.shutdown();
                }
            });
        }
    }

    public final void createCollectdTimeSeries(String name, MonitoredResource resource, String collectdVersion, List<CollectdPayload> collectdPayloads) {
        PROJECT_PATH_TEMPLATE.validate(name, "createCollectdTimeSeries");
        CreateCollectdTimeSeriesRequest request = CreateCollectdTimeSeriesRequest.newBuilder().setName(name).setResource(resource).setCollectdVersion(collectdVersion).addAllCollectdPayloads(collectdPayloads).build();
        this.createCollectdTimeSeries(request);
    }

    public final void createCollectdTimeSeries(CreateCollectdTimeSeriesRequest request) {
        this.createCollectdTimeSeriesCallable().call((Object)request);
    }

    public final ApiCallable<CreateCollectdTimeSeriesRequest, Empty> createCollectdTimeSeriesCallable() {
        return this.createCollectdTimeSeriesCallable;
    }

    @Override
    public final void close() throws Exception {
        for (AutoCloseable closeable : this.closeables) {
            closeable.close();
        }
    }
}

