/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.monitoring.spi.v3;

import com.google.api.MonitoredResource;
import com.google.api.gax.core.PagedListResponse;
import com.google.api.gax.grpc.ApiCallable;
import com.google.api.gax.protobuf.PathTemplate;
import com.google.cloud.monitoring.spi.v3.GroupServiceSettings;
import com.google.monitoring.v3.CreateGroupRequest;
import com.google.monitoring.v3.DeleteGroupRequest;
import com.google.monitoring.v3.GetGroupRequest;
import com.google.monitoring.v3.Group;
import com.google.monitoring.v3.ListGroupMembersRequest;
import com.google.monitoring.v3.ListGroupMembersResponse;
import com.google.monitoring.v3.ListGroupsRequest;
import com.google.monitoring.v3.ListGroupsResponse;
import com.google.monitoring.v3.TimeInterval;
import com.google.monitoring.v3.UpdateGroupRequest;
import com.google.protobuf.Empty;
import io.grpc.ManagedChannel;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

public class GroupServiceApi
implements AutoCloseable {
    private final GroupServiceSettings settings;
    private final ManagedChannel channel;
    private final ScheduledExecutorService executor;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private final ApiCallable<ListGroupsRequest, ListGroupsResponse> listGroupsCallable;
    private final ApiCallable<ListGroupsRequest, PagedListResponse<ListGroupsRequest, ListGroupsResponse, Group>> listGroupsPagedCallable;
    private final ApiCallable<GetGroupRequest, Group> getGroupCallable;
    private final ApiCallable<CreateGroupRequest, Group> createGroupCallable;
    private final ApiCallable<UpdateGroupRequest, Group> updateGroupCallable;
    private final ApiCallable<DeleteGroupRequest, Empty> deleteGroupCallable;
    private final ApiCallable<ListGroupMembersRequest, ListGroupMembersResponse> listGroupMembersCallable;
    private final ApiCallable<ListGroupMembersRequest, PagedListResponse<ListGroupMembersRequest, ListGroupMembersResponse, MonitoredResource>> listGroupMembersPagedCallable;
    private static final PathTemplate PROJECT_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}");
    private static final PathTemplate GROUP_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/groups/{group}");

    public final GroupServiceSettings getSettings() {
        return this.settings;
    }

    public static final String formatProjectName(String project) {
        return PROJECT_PATH_TEMPLATE.instantiate(new String[]{"project", project});
    }

    public static final String formatGroupName(String project, String group) {
        return GROUP_PATH_TEMPLATE.instantiate(new String[]{"project", project, "group", group});
    }

    public static final String parseProjectFromProjectName(String projectName) {
        return PROJECT_PATH_TEMPLATE.parse(projectName).get((Object)"project");
    }

    public static final String parseProjectFromGroupName(String groupName) {
        return GROUP_PATH_TEMPLATE.parse(groupName).get((Object)"project");
    }

    public static final String parseGroupFromGroupName(String groupName) {
        return GROUP_PATH_TEMPLATE.parse(groupName).get((Object)"group");
    }

    public static final GroupServiceApi create() throws IOException {
        return GroupServiceApi.create(GroupServiceSettings.defaultBuilder().build());
    }

    public static final GroupServiceApi create(GroupServiceSettings settings) throws IOException {
        return new GroupServiceApi(settings);
    }

    protected GroupServiceApi(GroupServiceSettings settings) throws IOException {
        this.settings = settings;
        this.executor = settings.getExecutorProvider().getOrBuildExecutor();
        this.channel = settings.getChannelProvider().getOrBuildChannel((Executor)this.executor);
        this.listGroupsCallable = ApiCallable.create(settings.listGroupsSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.listGroupsPagedCallable = ApiCallable.createPagedVariant(settings.listGroupsSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.getGroupCallable = ApiCallable.create(settings.getGroupSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.createGroupCallable = ApiCallable.create(settings.createGroupSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.updateGroupCallable = ApiCallable.create(settings.updateGroupSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.deleteGroupCallable = ApiCallable.create(settings.deleteGroupSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.listGroupMembersCallable = ApiCallable.create(settings.listGroupMembersSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.listGroupMembersPagedCallable = ApiCallable.createPagedVariant(settings.listGroupMembersSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        if (settings.getChannelProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    GroupServiceApi.this.channel.shutdown();
                }
            });
        }
        if (settings.getExecutorProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    GroupServiceApi.this.executor.shutdown();
                }
            });
        }
    }

    public final PagedListResponse<ListGroupsRequest, ListGroupsResponse, Group> listGroups(ListGroupsRequest request) {
        return (PagedListResponse)this.listGroupsPagedCallable().call((Object)request);
    }

    public final ApiCallable<ListGroupsRequest, PagedListResponse<ListGroupsRequest, ListGroupsResponse, Group>> listGroupsPagedCallable() {
        return this.listGroupsPagedCallable;
    }

    public final ApiCallable<ListGroupsRequest, ListGroupsResponse> listGroupsCallable() {
        return this.listGroupsCallable;
    }

    public final Group getGroup(String name) {
        GROUP_PATH_TEMPLATE.validate(name, "getGroup");
        GetGroupRequest request = GetGroupRequest.newBuilder().setName(name).build();
        return this.getGroup(request);
    }

    private final Group getGroup(GetGroupRequest request) {
        return (Group)this.getGroupCallable().call((Object)request);
    }

    public final ApiCallable<GetGroupRequest, Group> getGroupCallable() {
        return this.getGroupCallable;
    }

    public final Group createGroup(String name, Group group, boolean validateOnly) {
        PROJECT_PATH_TEMPLATE.validate(name, "createGroup");
        CreateGroupRequest request = CreateGroupRequest.newBuilder().setName(name).setGroup(group).setValidateOnly(validateOnly).build();
        return this.createGroup(request);
    }

    public final Group createGroup(CreateGroupRequest request) {
        return (Group)this.createGroupCallable().call((Object)request);
    }

    public final ApiCallable<CreateGroupRequest, Group> createGroupCallable() {
        return this.createGroupCallable;
    }

    public final Group updateGroup(Group group, boolean validateOnly) {
        UpdateGroupRequest request = UpdateGroupRequest.newBuilder().setGroup(group).setValidateOnly(validateOnly).build();
        return this.updateGroup(request);
    }

    public final Group updateGroup(UpdateGroupRequest request) {
        return (Group)this.updateGroupCallable().call((Object)request);
    }

    public final ApiCallable<UpdateGroupRequest, Group> updateGroupCallable() {
        return this.updateGroupCallable;
    }

    public final void deleteGroup(String name) {
        GROUP_PATH_TEMPLATE.validate(name, "deleteGroup");
        DeleteGroupRequest request = DeleteGroupRequest.newBuilder().setName(name).build();
        this.deleteGroup(request);
    }

    private final void deleteGroup(DeleteGroupRequest request) {
        this.deleteGroupCallable().call((Object)request);
    }

    public final ApiCallable<DeleteGroupRequest, Empty> deleteGroupCallable() {
        return this.deleteGroupCallable;
    }

    public final PagedListResponse<ListGroupMembersRequest, ListGroupMembersResponse, MonitoredResource> listGroupMembers(String name, String filter, TimeInterval interval) {
        GROUP_PATH_TEMPLATE.validate(name, "listGroupMembers");
        ListGroupMembersRequest request = ListGroupMembersRequest.newBuilder().setName(name).setFilter(filter).setInterval(interval).build();
        return this.listGroupMembers(request);
    }

    public final PagedListResponse<ListGroupMembersRequest, ListGroupMembersResponse, MonitoredResource> listGroupMembers(ListGroupMembersRequest request) {
        return (PagedListResponse)this.listGroupMembersPagedCallable().call((Object)request);
    }

    public final ApiCallable<ListGroupMembersRequest, PagedListResponse<ListGroupMembersRequest, ListGroupMembersResponse, MonitoredResource>> listGroupMembersPagedCallable() {
        return this.listGroupMembersPagedCallable;
    }

    public final ApiCallable<ListGroupMembersRequest, ListGroupMembersResponse> listGroupMembersCallable() {
        return this.listGroupMembersCallable;
    }

    @Override
    public final void close() throws Exception {
        for (AutoCloseable closeable : this.closeables) {
            closeable.close();
        }
    }
}

