/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.monitoring.spi.v3;

import com.google.api.MetricDescriptor;
import com.google.api.MonitoredResourceDescriptor;
import com.google.api.gax.core.PagedListResponse;
import com.google.api.gax.grpc.ApiCallable;
import com.google.api.gax.protobuf.PathTemplate;
import com.google.cloud.monitoring.spi.v3.MetricServiceSettings;
import com.google.monitoring.v3.CreateMetricDescriptorRequest;
import com.google.monitoring.v3.CreateTimeSeriesRequest;
import com.google.monitoring.v3.DeleteMetricDescriptorRequest;
import com.google.monitoring.v3.GetMetricDescriptorRequest;
import com.google.monitoring.v3.GetMonitoredResourceDescriptorRequest;
import com.google.monitoring.v3.ListMetricDescriptorsRequest;
import com.google.monitoring.v3.ListMetricDescriptorsResponse;
import com.google.monitoring.v3.ListMonitoredResourceDescriptorsRequest;
import com.google.monitoring.v3.ListMonitoredResourceDescriptorsResponse;
import com.google.monitoring.v3.ListTimeSeriesRequest;
import com.google.monitoring.v3.ListTimeSeriesResponse;
import com.google.monitoring.v3.TimeSeries;
import com.google.protobuf.Empty;
import io.grpc.ManagedChannel;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

public class MetricServiceApi
implements AutoCloseable {
    private final MetricServiceSettings settings;
    private final ManagedChannel channel;
    private final ScheduledExecutorService executor;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private final ApiCallable<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse> listMonitoredResourceDescriptorsCallable;
    private final ApiCallable<ListMonitoredResourceDescriptorsRequest, PagedListResponse<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, MonitoredResourceDescriptor>> listMonitoredResourceDescriptorsPagedCallable;
    private final ApiCallable<GetMonitoredResourceDescriptorRequest, MonitoredResourceDescriptor> getMonitoredResourceDescriptorCallable;
    private final ApiCallable<ListMetricDescriptorsRequest, ListMetricDescriptorsResponse> listMetricDescriptorsCallable;
    private final ApiCallable<ListMetricDescriptorsRequest, PagedListResponse<ListMetricDescriptorsRequest, ListMetricDescriptorsResponse, MetricDescriptor>> listMetricDescriptorsPagedCallable;
    private final ApiCallable<GetMetricDescriptorRequest, MetricDescriptor> getMetricDescriptorCallable;
    private final ApiCallable<CreateMetricDescriptorRequest, MetricDescriptor> createMetricDescriptorCallable;
    private final ApiCallable<DeleteMetricDescriptorRequest, Empty> deleteMetricDescriptorCallable;
    private final ApiCallable<ListTimeSeriesRequest, ListTimeSeriesResponse> listTimeSeriesCallable;
    private final ApiCallable<ListTimeSeriesRequest, PagedListResponse<ListTimeSeriesRequest, ListTimeSeriesResponse, TimeSeries>> listTimeSeriesPagedCallable;
    private final ApiCallable<CreateTimeSeriesRequest, Empty> createTimeSeriesCallable;
    private static final PathTemplate PROJECT_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}");
    private static final PathTemplate METRIC_DESCRIPTOR_PATH_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/metricDescriptors/{metric_descriptor_path=**}");
    private static final PathTemplate MONITORED_RESOURCE_DESCRIPTOR_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/monitoredResourceDescriptors/{monitored_resource_descriptor}");

    public final MetricServiceSettings getSettings() {
        return this.settings;
    }

    public static final String formatProjectName(String project) {
        return PROJECT_PATH_TEMPLATE.instantiate(new String[]{"project", project});
    }

    public static final String formatMetricDescriptorPathName(String project, String metricDescriptorPath) {
        return METRIC_DESCRIPTOR_PATH_PATH_TEMPLATE.instantiate(new String[]{"project", project, "metric_descriptor_path", metricDescriptorPath});
    }

    public static final String formatMonitoredResourceDescriptorName(String project, String monitoredResourceDescriptor) {
        return MONITORED_RESOURCE_DESCRIPTOR_PATH_TEMPLATE.instantiate(new String[]{"project", project, "monitored_resource_descriptor", monitoredResourceDescriptor});
    }

    public static final String parseProjectFromProjectName(String projectName) {
        return PROJECT_PATH_TEMPLATE.parse(projectName).get((Object)"project");
    }

    public static final String parseProjectFromMetricDescriptorPathName(String metricDescriptorPathName) {
        return METRIC_DESCRIPTOR_PATH_PATH_TEMPLATE.parse(metricDescriptorPathName).get((Object)"project");
    }

    public static final String parseMetricDescriptorPathFromMetricDescriptorPathName(String metricDescriptorPathName) {
        return METRIC_DESCRIPTOR_PATH_PATH_TEMPLATE.parse(metricDescriptorPathName).get((Object)"metric_descriptor_path");
    }

    public static final String parseProjectFromMonitoredResourceDescriptorName(String monitoredResourceDescriptorName) {
        return MONITORED_RESOURCE_DESCRIPTOR_PATH_TEMPLATE.parse(monitoredResourceDescriptorName).get((Object)"project");
    }

    public static final String parseMonitoredResourceDescriptorFromMonitoredResourceDescriptorName(String monitoredResourceDescriptorName) {
        return MONITORED_RESOURCE_DESCRIPTOR_PATH_TEMPLATE.parse(monitoredResourceDescriptorName).get((Object)"monitored_resource_descriptor");
    }

    public static final MetricServiceApi create() throws IOException {
        return MetricServiceApi.create(MetricServiceSettings.defaultBuilder().build());
    }

    public static final MetricServiceApi create(MetricServiceSettings settings) throws IOException {
        return new MetricServiceApi(settings);
    }

    protected MetricServiceApi(MetricServiceSettings settings) throws IOException {
        this.settings = settings;
        this.executor = settings.getExecutorProvider().getOrBuildExecutor();
        this.channel = settings.getChannelProvider().getOrBuildChannel((Executor)this.executor);
        this.listMonitoredResourceDescriptorsCallable = ApiCallable.create(settings.listMonitoredResourceDescriptorsSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.listMonitoredResourceDescriptorsPagedCallable = ApiCallable.createPagedVariant(settings.listMonitoredResourceDescriptorsSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.getMonitoredResourceDescriptorCallable = ApiCallable.create(settings.getMonitoredResourceDescriptorSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.listMetricDescriptorsCallable = ApiCallable.create(settings.listMetricDescriptorsSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.listMetricDescriptorsPagedCallable = ApiCallable.createPagedVariant(settings.listMetricDescriptorsSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.getMetricDescriptorCallable = ApiCallable.create(settings.getMetricDescriptorSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.createMetricDescriptorCallable = ApiCallable.create(settings.createMetricDescriptorSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.deleteMetricDescriptorCallable = ApiCallable.create(settings.deleteMetricDescriptorSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.listTimeSeriesCallable = ApiCallable.create(settings.listTimeSeriesSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.listTimeSeriesPagedCallable = ApiCallable.createPagedVariant(settings.listTimeSeriesSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.createTimeSeriesCallable = ApiCallable.create(settings.createTimeSeriesSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        if (settings.getChannelProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    MetricServiceApi.this.channel.shutdown();
                }
            });
        }
        if (settings.getExecutorProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    MetricServiceApi.this.executor.shutdown();
                }
            });
        }
    }

    public final PagedListResponse<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, MonitoredResourceDescriptor> listMonitoredResourceDescriptors(String name, String filter) {
        PROJECT_PATH_TEMPLATE.validate(name, "listMonitoredResourceDescriptors");
        ListMonitoredResourceDescriptorsRequest request = ListMonitoredResourceDescriptorsRequest.newBuilder().setName(name).setFilter(filter).build();
        return this.listMonitoredResourceDescriptors(request);
    }

    public final PagedListResponse<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, MonitoredResourceDescriptor> listMonitoredResourceDescriptors(ListMonitoredResourceDescriptorsRequest request) {
        return (PagedListResponse)this.listMonitoredResourceDescriptorsPagedCallable().call((Object)request);
    }

    public final ApiCallable<ListMonitoredResourceDescriptorsRequest, PagedListResponse<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, MonitoredResourceDescriptor>> listMonitoredResourceDescriptorsPagedCallable() {
        return this.listMonitoredResourceDescriptorsPagedCallable;
    }

    public final ApiCallable<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse> listMonitoredResourceDescriptorsCallable() {
        return this.listMonitoredResourceDescriptorsCallable;
    }

    public final MonitoredResourceDescriptor getMonitoredResourceDescriptor(String name) {
        MONITORED_RESOURCE_DESCRIPTOR_PATH_TEMPLATE.validate(name, "getMonitoredResourceDescriptor");
        GetMonitoredResourceDescriptorRequest request = GetMonitoredResourceDescriptorRequest.newBuilder().setName(name).build();
        return this.getMonitoredResourceDescriptor(request);
    }

    private final MonitoredResourceDescriptor getMonitoredResourceDescriptor(GetMonitoredResourceDescriptorRequest request) {
        return (MonitoredResourceDescriptor)this.getMonitoredResourceDescriptorCallable().call((Object)request);
    }

    public final ApiCallable<GetMonitoredResourceDescriptorRequest, MonitoredResourceDescriptor> getMonitoredResourceDescriptorCallable() {
        return this.getMonitoredResourceDescriptorCallable;
    }

    public final PagedListResponse<ListMetricDescriptorsRequest, ListMetricDescriptorsResponse, MetricDescriptor> listMetricDescriptors(String name, String filter) {
        PROJECT_PATH_TEMPLATE.validate(name, "listMetricDescriptors");
        ListMetricDescriptorsRequest request = ListMetricDescriptorsRequest.newBuilder().setName(name).setFilter(filter).build();
        return this.listMetricDescriptors(request);
    }

    public final PagedListResponse<ListMetricDescriptorsRequest, ListMetricDescriptorsResponse, MetricDescriptor> listMetricDescriptors(ListMetricDescriptorsRequest request) {
        return (PagedListResponse)this.listMetricDescriptorsPagedCallable().call((Object)request);
    }

    public final ApiCallable<ListMetricDescriptorsRequest, PagedListResponse<ListMetricDescriptorsRequest, ListMetricDescriptorsResponse, MetricDescriptor>> listMetricDescriptorsPagedCallable() {
        return this.listMetricDescriptorsPagedCallable;
    }

    public final ApiCallable<ListMetricDescriptorsRequest, ListMetricDescriptorsResponse> listMetricDescriptorsCallable() {
        return this.listMetricDescriptorsCallable;
    }

    public final MetricDescriptor getMetricDescriptor(String name) {
        METRIC_DESCRIPTOR_PATH_PATH_TEMPLATE.validate(name, "getMetricDescriptor");
        GetMetricDescriptorRequest request = GetMetricDescriptorRequest.newBuilder().setName(name).build();
        return this.getMetricDescriptor(request);
    }

    private final MetricDescriptor getMetricDescriptor(GetMetricDescriptorRequest request) {
        return (MetricDescriptor)this.getMetricDescriptorCallable().call((Object)request);
    }

    public final ApiCallable<GetMetricDescriptorRequest, MetricDescriptor> getMetricDescriptorCallable() {
        return this.getMetricDescriptorCallable;
    }

    public final MetricDescriptor createMetricDescriptor(String name, MetricDescriptor metricDescriptor) {
        PROJECT_PATH_TEMPLATE.validate(name, "createMetricDescriptor");
        CreateMetricDescriptorRequest request = CreateMetricDescriptorRequest.newBuilder().setName(name).setMetricDescriptor(metricDescriptor).build();
        return this.createMetricDescriptor(request);
    }

    public final MetricDescriptor createMetricDescriptor(CreateMetricDescriptorRequest request) {
        return (MetricDescriptor)this.createMetricDescriptorCallable().call((Object)request);
    }

    public final ApiCallable<CreateMetricDescriptorRequest, MetricDescriptor> createMetricDescriptorCallable() {
        return this.createMetricDescriptorCallable;
    }

    public final void deleteMetricDescriptor(String name) {
        METRIC_DESCRIPTOR_PATH_PATH_TEMPLATE.validate(name, "deleteMetricDescriptor");
        DeleteMetricDescriptorRequest request = DeleteMetricDescriptorRequest.newBuilder().setName(name).build();
        this.deleteMetricDescriptor(request);
    }

    private final void deleteMetricDescriptor(DeleteMetricDescriptorRequest request) {
        this.deleteMetricDescriptorCallable().call((Object)request);
    }

    public final ApiCallable<DeleteMetricDescriptorRequest, Empty> deleteMetricDescriptorCallable() {
        return this.deleteMetricDescriptorCallable;
    }

    public final PagedListResponse<ListTimeSeriesRequest, ListTimeSeriesResponse, TimeSeries> listTimeSeries(ListTimeSeriesRequest request) {
        return (PagedListResponse)this.listTimeSeriesPagedCallable().call((Object)request);
    }

    public final ApiCallable<ListTimeSeriesRequest, PagedListResponse<ListTimeSeriesRequest, ListTimeSeriesResponse, TimeSeries>> listTimeSeriesPagedCallable() {
        return this.listTimeSeriesPagedCallable;
    }

    public final ApiCallable<ListTimeSeriesRequest, ListTimeSeriesResponse> listTimeSeriesCallable() {
        return this.listTimeSeriesCallable;
    }

    public final void createTimeSeries(String name, List<TimeSeries> timeSeries) {
        PROJECT_PATH_TEMPLATE.validate(name, "createTimeSeries");
        CreateTimeSeriesRequest request = CreateTimeSeriesRequest.newBuilder().setName(name).addAllTimeSeries(timeSeries).build();
        this.createTimeSeries(request);
    }

    public final void createTimeSeries(CreateTimeSeriesRequest request) {
        this.createTimeSeriesCallable().call((Object)request);
    }

    public final ApiCallable<CreateTimeSeriesRequest, Empty> createTimeSeriesCallable() {
        return this.createTimeSeriesCallable;
    }

    @Override
    public final void close() throws Exception {
        for (AutoCloseable closeable : this.closeables) {
            closeable.close();
        }
    }
}

