/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.monitoring.spi.v3;

import com.google.api.MetricDescriptor;
import com.google.api.MonitoredResourceDescriptor;
import com.google.api.gax.core.ConnectionSettings;
import com.google.api.gax.core.RetrySettings;
import com.google.api.gax.grpc.ApiCallSettings;
import com.google.api.gax.grpc.PageStreamingCallSettings;
import com.google.api.gax.grpc.PageStreamingDescriptor;
import com.google.api.gax.grpc.ServiceApiSettings;
import com.google.api.gax.grpc.SimpleCallSettings;
import com.google.auth.Credentials;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.monitoring.v3.CreateMetricDescriptorRequest;
import com.google.monitoring.v3.CreateTimeSeriesRequest;
import com.google.monitoring.v3.DeleteMetricDescriptorRequest;
import com.google.monitoring.v3.GetMetricDescriptorRequest;
import com.google.monitoring.v3.GetMonitoredResourceDescriptorRequest;
import com.google.monitoring.v3.ListMetricDescriptorsRequest;
import com.google.monitoring.v3.ListMetricDescriptorsResponse;
import com.google.monitoring.v3.ListMonitoredResourceDescriptorsRequest;
import com.google.monitoring.v3.ListMonitoredResourceDescriptorsResponse;
import com.google.monitoring.v3.ListTimeSeriesRequest;
import com.google.monitoring.v3.ListTimeSeriesResponse;
import com.google.monitoring.v3.MetricServiceGrpc;
import com.google.monitoring.v3.TimeSeries;
import com.google.protobuf.Empty;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.joda.time.Duration;

public class MetricServiceSettings
extends ServiceApiSettings {
    private static final String DEFAULT_SERVICE_ADDRESS = "monitoring.googleapis.com";
    private static final int DEFAULT_SERVICE_PORT = 443;
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().build();
    public static final ConnectionSettings DEFAULT_CONNECTION_SETTINGS = ConnectionSettings.newBuilder().setServiceAddress("monitoring.googleapis.com").setPort(443).provideCredentialsWith(DEFAULT_SERVICE_SCOPES).build();
    private final PageStreamingCallSettings<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, MonitoredResourceDescriptor> listMonitoredResourceDescriptorsSettings;
    private final SimpleCallSettings<GetMonitoredResourceDescriptorRequest, MonitoredResourceDescriptor> getMonitoredResourceDescriptorSettings;
    private final PageStreamingCallSettings<ListMetricDescriptorsRequest, ListMetricDescriptorsResponse, MetricDescriptor> listMetricDescriptorsSettings;
    private final SimpleCallSettings<GetMetricDescriptorRequest, MetricDescriptor> getMetricDescriptorSettings;
    private final SimpleCallSettings<CreateMetricDescriptorRequest, MetricDescriptor> createMetricDescriptorSettings;
    private final SimpleCallSettings<DeleteMetricDescriptorRequest, Empty> deleteMetricDescriptorSettings;
    private final PageStreamingCallSettings<ListTimeSeriesRequest, ListTimeSeriesResponse, TimeSeries> listTimeSeriesSettings;
    private final SimpleCallSettings<CreateTimeSeriesRequest, Empty> createTimeSeriesSettings;
    private static PageStreamingDescriptor<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, MonitoredResourceDescriptor> LIST_MONITORED_RESOURCE_DESCRIPTORS_PAGE_STR_DESC = new PageStreamingDescriptor<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, MonitoredResourceDescriptor>(){

        public Object emptyToken() {
            return "";
        }

        public ListMonitoredResourceDescriptorsRequest injectToken(ListMonitoredResourceDescriptorsRequest payload, Object token) {
            return ListMonitoredResourceDescriptorsRequest.newBuilder((ListMonitoredResourceDescriptorsRequest)payload).setPageToken((String)token).build();
        }

        public ListMonitoredResourceDescriptorsRequest injectPageSize(ListMonitoredResourceDescriptorsRequest payload, int pageSize) {
            return ListMonitoredResourceDescriptorsRequest.newBuilder((ListMonitoredResourceDescriptorsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListMonitoredResourceDescriptorsRequest payload) {
            return payload.getPageSize();
        }

        public Object extractNextToken(ListMonitoredResourceDescriptorsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<MonitoredResourceDescriptor> extractResources(ListMonitoredResourceDescriptorsResponse payload) {
            return payload.getResourceDescriptorsList();
        }
    };
    private static PageStreamingDescriptor<ListMetricDescriptorsRequest, ListMetricDescriptorsResponse, MetricDescriptor> LIST_METRIC_DESCRIPTORS_PAGE_STR_DESC = new PageStreamingDescriptor<ListMetricDescriptorsRequest, ListMetricDescriptorsResponse, MetricDescriptor>(){

        public Object emptyToken() {
            return "";
        }

        public ListMetricDescriptorsRequest injectToken(ListMetricDescriptorsRequest payload, Object token) {
            return ListMetricDescriptorsRequest.newBuilder((ListMetricDescriptorsRequest)payload).setPageToken((String)token).build();
        }

        public ListMetricDescriptorsRequest injectPageSize(ListMetricDescriptorsRequest payload, int pageSize) {
            return ListMetricDescriptorsRequest.newBuilder((ListMetricDescriptorsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListMetricDescriptorsRequest payload) {
            return payload.getPageSize();
        }

        public Object extractNextToken(ListMetricDescriptorsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<MetricDescriptor> extractResources(ListMetricDescriptorsResponse payload) {
            return payload.getMetricDescriptorsList();
        }
    };
    private static PageStreamingDescriptor<ListTimeSeriesRequest, ListTimeSeriesResponse, TimeSeries> LIST_TIME_SERIES_PAGE_STR_DESC = new PageStreamingDescriptor<ListTimeSeriesRequest, ListTimeSeriesResponse, TimeSeries>(){

        public Object emptyToken() {
            return "";
        }

        public ListTimeSeriesRequest injectToken(ListTimeSeriesRequest payload, Object token) {
            return ListTimeSeriesRequest.newBuilder((ListTimeSeriesRequest)payload).setPageToken((String)token).build();
        }

        public ListTimeSeriesRequest injectPageSize(ListTimeSeriesRequest payload, int pageSize) {
            return ListTimeSeriesRequest.newBuilder((ListTimeSeriesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTimeSeriesRequest payload) {
            return payload.getPageSize();
        }

        public Object extractNextToken(ListTimeSeriesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TimeSeries> extractResources(ListTimeSeriesResponse payload) {
            return payload.getTimeSeriesList();
        }
    };

    public PageStreamingCallSettings<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, MonitoredResourceDescriptor> listMonitoredResourceDescriptorsSettings() {
        return this.listMonitoredResourceDescriptorsSettings;
    }

    public SimpleCallSettings<GetMonitoredResourceDescriptorRequest, MonitoredResourceDescriptor> getMonitoredResourceDescriptorSettings() {
        return this.getMonitoredResourceDescriptorSettings;
    }

    public PageStreamingCallSettings<ListMetricDescriptorsRequest, ListMetricDescriptorsResponse, MetricDescriptor> listMetricDescriptorsSettings() {
        return this.listMetricDescriptorsSettings;
    }

    public SimpleCallSettings<GetMetricDescriptorRequest, MetricDescriptor> getMetricDescriptorSettings() {
        return this.getMetricDescriptorSettings;
    }

    public SimpleCallSettings<CreateMetricDescriptorRequest, MetricDescriptor> createMetricDescriptorSettings() {
        return this.createMetricDescriptorSettings;
    }

    public SimpleCallSettings<DeleteMetricDescriptorRequest, Empty> deleteMetricDescriptorSettings() {
        return this.deleteMetricDescriptorSettings;
    }

    public PageStreamingCallSettings<ListTimeSeriesRequest, ListTimeSeriesResponse, TimeSeries> listTimeSeriesSettings() {
        return this.listTimeSeriesSettings;
    }

    public SimpleCallSettings<CreateTimeSeriesRequest, Empty> createTimeSeriesSettings() {
        return this.createTimeSeriesSettings;
    }

    public static String getDefaultServiceAddress() {
        return DEFAULT_SERVICE_ADDRESS;
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static ImmutableList<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static Builder defaultBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private MetricServiceSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder.getChannelProvider(), settingsBuilder.getExecutorProvider(), settingsBuilder.getGeneratorName(), settingsBuilder.getGeneratorVersion(), settingsBuilder.getClientLibName(), settingsBuilder.getClientLibVersion());
        this.listMonitoredResourceDescriptorsSettings = settingsBuilder.listMonitoredResourceDescriptorsSettings().build();
        this.getMonitoredResourceDescriptorSettings = settingsBuilder.getMonitoredResourceDescriptorSettings().build();
        this.listMetricDescriptorsSettings = settingsBuilder.listMetricDescriptorsSettings().build();
        this.getMetricDescriptorSettings = settingsBuilder.getMetricDescriptorSettings().build();
        this.createMetricDescriptorSettings = settingsBuilder.createMetricDescriptorSettings().build();
        this.deleteMetricDescriptorSettings = settingsBuilder.deleteMetricDescriptorSettings().build();
        this.listTimeSeriesSettings = settingsBuilder.listTimeSeriesSettings().build();
        this.createTimeSeriesSettings = settingsBuilder.createTimeSeriesSettings().build();
    }

    public static class Builder
    extends ServiceApiSettings.Builder {
        private final ImmutableList<ApiCallSettings.Builder> methodSettingsBuilders;
        private PageStreamingCallSettings.Builder<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, MonitoredResourceDescriptor> listMonitoredResourceDescriptorsSettings;
        private SimpleCallSettings.Builder<GetMonitoredResourceDescriptorRequest, MonitoredResourceDescriptor> getMonitoredResourceDescriptorSettings;
        private PageStreamingCallSettings.Builder<ListMetricDescriptorsRequest, ListMetricDescriptorsResponse, MetricDescriptor> listMetricDescriptorsSettings;
        private SimpleCallSettings.Builder<GetMetricDescriptorRequest, MetricDescriptor> getMetricDescriptorSettings;
        private SimpleCallSettings.Builder<CreateMetricDescriptorRequest, MetricDescriptor> createMetricDescriptorSettings;
        private SimpleCallSettings.Builder<DeleteMetricDescriptorRequest, Empty> deleteMetricDescriptorSettings;
        private PageStreamingCallSettings.Builder<ListTimeSeriesRequest, ListTimeSeriesResponse, TimeSeries> listTimeSeriesSettings;
        private SimpleCallSettings.Builder<CreateTimeSeriesRequest, Empty> createTimeSeriesSettings;
        private static final ImmutableMap<String, ImmutableSet<Status.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings.Builder> RETRY_PARAM_DEFINITIONS;

        private Builder() {
            super(DEFAULT_CONNECTION_SETTINGS);
            this.listMonitoredResourceDescriptorsSettings = PageStreamingCallSettings.newBuilder((MethodDescriptor)MetricServiceGrpc.METHOD_LIST_MONITORED_RESOURCE_DESCRIPTORS, (PageStreamingDescriptor)LIST_MONITORED_RESOURCE_DESCRIPTORS_PAGE_STR_DESC);
            this.getMonitoredResourceDescriptorSettings = SimpleCallSettings.newBuilder((MethodDescriptor)MetricServiceGrpc.METHOD_GET_MONITORED_RESOURCE_DESCRIPTOR);
            this.listMetricDescriptorsSettings = PageStreamingCallSettings.newBuilder((MethodDescriptor)MetricServiceGrpc.METHOD_LIST_METRIC_DESCRIPTORS, (PageStreamingDescriptor)LIST_METRIC_DESCRIPTORS_PAGE_STR_DESC);
            this.getMetricDescriptorSettings = SimpleCallSettings.newBuilder((MethodDescriptor)MetricServiceGrpc.METHOD_GET_METRIC_DESCRIPTOR);
            this.createMetricDescriptorSettings = SimpleCallSettings.newBuilder((MethodDescriptor)MetricServiceGrpc.METHOD_CREATE_METRIC_DESCRIPTOR);
            this.deleteMetricDescriptorSettings = SimpleCallSettings.newBuilder((MethodDescriptor)MetricServiceGrpc.METHOD_DELETE_METRIC_DESCRIPTOR);
            this.listTimeSeriesSettings = PageStreamingCallSettings.newBuilder((MethodDescriptor)MetricServiceGrpc.METHOD_LIST_TIME_SERIES, (PageStreamingDescriptor)LIST_TIME_SERIES_PAGE_STR_DESC);
            this.createTimeSeriesSettings = SimpleCallSettings.newBuilder((MethodDescriptor)MetricServiceGrpc.METHOD_CREATE_TIME_SERIES);
            this.methodSettingsBuilders = ImmutableList.of(this.listMonitoredResourceDescriptorsSettings, this.getMonitoredResourceDescriptorSettings, this.listMetricDescriptorsSettings, this.getMetricDescriptorSettings, this.createMetricDescriptorSettings, this.deleteMetricDescriptorSettings, this.listTimeSeriesSettings, this.createTimeSeriesSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder();
            builder.listMonitoredResourceDescriptorsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getMonitoredResourceDescriptorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listMetricDescriptorsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getMetricDescriptorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createMetricDescriptorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteMetricDescriptorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listTimeSeriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createTimeSeriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        private Builder(MetricServiceSettings settings) {
            super((ServiceApiSettings)settings);
            this.listMonitoredResourceDescriptorsSettings = settings.listMonitoredResourceDescriptorsSettings.toBuilder();
            this.getMonitoredResourceDescriptorSettings = settings.getMonitoredResourceDescriptorSettings.toBuilder();
            this.listMetricDescriptorsSettings = settings.listMetricDescriptorsSettings.toBuilder();
            this.getMetricDescriptorSettings = settings.getMetricDescriptorSettings.toBuilder();
            this.createMetricDescriptorSettings = settings.createMetricDescriptorSettings.toBuilder();
            this.deleteMetricDescriptorSettings = settings.deleteMetricDescriptorSettings.toBuilder();
            this.listTimeSeriesSettings = settings.listTimeSeriesSettings.toBuilder();
            this.createTimeSeriesSettings = settings.createTimeSeriesSettings.toBuilder();
            this.methodSettingsBuilders = ImmutableList.of(this.listMonitoredResourceDescriptorsSettings, this.getMonitoredResourceDescriptorSettings, this.listMetricDescriptorsSettings, this.getMetricDescriptorSettings, this.createMetricDescriptorSettings, this.deleteMetricDescriptorSettings, this.listTimeSeriesSettings, this.createTimeSeriesSettings);
        }

        protected ConnectionSettings getDefaultConnectionSettings() {
            return DEFAULT_CONNECTION_SETTINGS;
        }

        public Builder provideExecutorWith(ScheduledExecutorService executor, boolean shouldAutoClose) {
            super.provideExecutorWith(executor, shouldAutoClose);
            return this;
        }

        public Builder provideChannelWith(ManagedChannel channel, boolean shouldAutoClose) {
            super.provideChannelWith(channel, shouldAutoClose);
            return this;
        }

        public Builder provideChannelWith(ConnectionSettings settings) {
            super.provideChannelWith(settings);
            return this;
        }

        public Builder provideChannelWith(Credentials credentials) {
            super.provideChannelWith(credentials);
            return this;
        }

        public Builder provideChannelWith(List<String> scopes) {
            super.provideChannelWith(scopes);
            return this;
        }

        public Builder setGeneratorHeader(String name, String version) {
            super.setGeneratorHeader(name, version);
            return this;
        }

        public Builder setClientLibHeader(String name, String version) {
            super.setClientLibHeader(name, version);
            return this;
        }

        public Builder applyToAllApiMethods(ApiCallSettings.Builder apiCallSettings) throws Exception {
            super.applyToAllApiMethods(this.methodSettingsBuilders, apiCallSettings);
            return this;
        }

        public PageStreamingCallSettings.Builder<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse, MonitoredResourceDescriptor> listMonitoredResourceDescriptorsSettings() {
            return this.listMonitoredResourceDescriptorsSettings;
        }

        public SimpleCallSettings.Builder<GetMonitoredResourceDescriptorRequest, MonitoredResourceDescriptor> getMonitoredResourceDescriptorSettings() {
            return this.getMonitoredResourceDescriptorSettings;
        }

        public PageStreamingCallSettings.Builder<ListMetricDescriptorsRequest, ListMetricDescriptorsResponse, MetricDescriptor> listMetricDescriptorsSettings() {
            return this.listMetricDescriptorsSettings;
        }

        public SimpleCallSettings.Builder<GetMetricDescriptorRequest, MetricDescriptor> getMetricDescriptorSettings() {
            return this.getMetricDescriptorSettings;
        }

        public SimpleCallSettings.Builder<CreateMetricDescriptorRequest, MetricDescriptor> createMetricDescriptorSettings() {
            return this.createMetricDescriptorSettings;
        }

        public SimpleCallSettings.Builder<DeleteMetricDescriptorRequest, Empty> deleteMetricDescriptorSettings() {
            return this.deleteMetricDescriptorSettings;
        }

        public PageStreamingCallSettings.Builder<ListTimeSeriesRequest, ListTimeSeriesResponse, TimeSeries> listTimeSeriesSettings() {
            return this.listTimeSeriesSettings;
        }

        public SimpleCallSettings.Builder<CreateTimeSeriesRequest, Empty> createTimeSeriesSettings() {
            return this.createTimeSeriesSettings;
        }

        public MetricServiceSettings build() throws IOException {
            return new MetricServiceSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList((Object[])new Status.Code[]{Status.Code.DEADLINE_EXCEEDED, Status.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings.Builder settingsBuilder = null;
            settingsBuilder = RetrySettings.newBuilder().setInitialRetryDelay(Duration.millis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.millis((long)60000L)).setInitialRpcTimeout(Duration.millis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.millis((long)20000L)).setTotalTimeout(Duration.millis((long)600000L));
            definitions.put((Object)"default", (Object)settingsBuilder);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

