/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.monitoring.spi.v3;

import com.google.api.MonitoredResource;
import com.google.api.gax.core.ConnectionSettings;
import com.google.api.gax.core.RetrySettings;
import com.google.api.gax.grpc.CallContext;
import com.google.api.gax.grpc.PagedCallSettings;
import com.google.api.gax.grpc.PagedListDescriptor;
import com.google.api.gax.grpc.PagedListResponseFactory;
import com.google.api.gax.grpc.ServiceApiSettings;
import com.google.api.gax.grpc.SimpleCallSettings;
import com.google.api.gax.grpc.UnaryCallSettings;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.auth.Credentials;
import com.google.cloud.monitoring.spi.v3.PagedResponseWrappers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.monitoring.v3.CreateGroupRequest;
import com.google.monitoring.v3.DeleteGroupRequest;
import com.google.monitoring.v3.GetGroupRequest;
import com.google.monitoring.v3.Group;
import com.google.monitoring.v3.GroupServiceGrpc;
import com.google.monitoring.v3.ListGroupMembersRequest;
import com.google.monitoring.v3.ListGroupMembersResponse;
import com.google.monitoring.v3.ListGroupsRequest;
import com.google.monitoring.v3.ListGroupsResponse;
import com.google.monitoring.v3.UpdateGroupRequest;
import com.google.protobuf.Empty;
import io.grpc.ManagedChannel;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.joda.time.Duration;

public class GroupServiceSettings
extends ServiceApiSettings {
    private static final String DEFAULT_SERVICE_ADDRESS = "monitoring.googleapis.com";
    private static final int DEFAULT_SERVICE_PORT = 443;
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().build();
    private final PagedCallSettings<ListGroupsRequest, ListGroupsResponse, PagedResponseWrappers.ListGroupsPagedResponse> listGroupsSettings;
    private final SimpleCallSettings<GetGroupRequest, Group> getGroupSettings;
    private final SimpleCallSettings<CreateGroupRequest, Group> createGroupSettings;
    private final SimpleCallSettings<UpdateGroupRequest, Group> updateGroupSettings;
    private final SimpleCallSettings<DeleteGroupRequest, Empty> deleteGroupSettings;
    private final PagedCallSettings<ListGroupMembersRequest, ListGroupMembersResponse, PagedResponseWrappers.ListGroupMembersPagedResponse> listGroupMembersSettings;
    private static final PagedListDescriptor<ListGroupsRequest, ListGroupsResponse, Group> LIST_GROUPS_PAGE_STR_DESC = new PagedListDescriptor<ListGroupsRequest, ListGroupsResponse, Group>(){

        public Object emptyToken() {
            return "";
        }

        public ListGroupsRequest injectToken(ListGroupsRequest payload, Object token) {
            return ListGroupsRequest.newBuilder((ListGroupsRequest)payload).setPageToken((String)token).build();
        }

        public ListGroupsRequest injectPageSize(ListGroupsRequest payload, int pageSize) {
            return ListGroupsRequest.newBuilder((ListGroupsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListGroupsRequest payload) {
            return payload.getPageSize();
        }

        public Object extractNextToken(ListGroupsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Group> extractResources(ListGroupsResponse payload) {
            return payload.getGroupList();
        }
    };
    private static final PagedListDescriptor<ListGroupMembersRequest, ListGroupMembersResponse, MonitoredResource> LIST_GROUP_MEMBERS_PAGE_STR_DESC = new PagedListDescriptor<ListGroupMembersRequest, ListGroupMembersResponse, MonitoredResource>(){

        public Object emptyToken() {
            return "";
        }

        public ListGroupMembersRequest injectToken(ListGroupMembersRequest payload, Object token) {
            return ListGroupMembersRequest.newBuilder((ListGroupMembersRequest)payload).setPageToken((String)token).build();
        }

        public ListGroupMembersRequest injectPageSize(ListGroupMembersRequest payload, int pageSize) {
            return ListGroupMembersRequest.newBuilder((ListGroupMembersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListGroupMembersRequest payload) {
            return payload.getPageSize();
        }

        public Object extractNextToken(ListGroupMembersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<MonitoredResource> extractResources(ListGroupMembersResponse payload) {
            return payload.getMembersList();
        }
    };
    private static final PagedListResponseFactory<ListGroupsRequest, ListGroupsResponse, PagedResponseWrappers.ListGroupsPagedResponse> LIST_GROUPS_PAGE_STR_FACT = new PagedListResponseFactory<ListGroupsRequest, ListGroupsResponse, PagedResponseWrappers.ListGroupsPagedResponse>(){

        public PagedResponseWrappers.ListGroupsPagedResponse createPagedListResponse(UnaryCallable<ListGroupsRequest, ListGroupsResponse> callable, ListGroupsRequest request, CallContext context) {
            return new PagedResponseWrappers.ListGroupsPagedResponse(callable, (PagedListDescriptor<ListGroupsRequest, ListGroupsResponse, Group>)LIST_GROUPS_PAGE_STR_DESC, request, context);
        }
    };
    private static final PagedListResponseFactory<ListGroupMembersRequest, ListGroupMembersResponse, PagedResponseWrappers.ListGroupMembersPagedResponse> LIST_GROUP_MEMBERS_PAGE_STR_FACT = new PagedListResponseFactory<ListGroupMembersRequest, ListGroupMembersResponse, PagedResponseWrappers.ListGroupMembersPagedResponse>(){

        public PagedResponseWrappers.ListGroupMembersPagedResponse createPagedListResponse(UnaryCallable<ListGroupMembersRequest, ListGroupMembersResponse> callable, ListGroupMembersRequest request, CallContext context) {
            return new PagedResponseWrappers.ListGroupMembersPagedResponse(callable, (PagedListDescriptor<ListGroupMembersRequest, ListGroupMembersResponse, MonitoredResource>)LIST_GROUP_MEMBERS_PAGE_STR_DESC, request, context);
        }
    };

    public PagedCallSettings<ListGroupsRequest, ListGroupsResponse, PagedResponseWrappers.ListGroupsPagedResponse> listGroupsSettings() {
        return this.listGroupsSettings;
    }

    public SimpleCallSettings<GetGroupRequest, Group> getGroupSettings() {
        return this.getGroupSettings;
    }

    public SimpleCallSettings<CreateGroupRequest, Group> createGroupSettings() {
        return this.createGroupSettings;
    }

    public SimpleCallSettings<UpdateGroupRequest, Group> updateGroupSettings() {
        return this.updateGroupSettings;
    }

    public SimpleCallSettings<DeleteGroupRequest, Empty> deleteGroupSettings() {
        return this.deleteGroupSettings;
    }

    public PagedCallSettings<ListGroupMembersRequest, ListGroupMembersResponse, PagedResponseWrappers.ListGroupMembersPagedResponse> listGroupMembersSettings() {
        return this.listGroupMembersSettings;
    }

    public static String getDefaultServiceAddress() {
        return DEFAULT_SERVICE_ADDRESS;
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static ImmutableList<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static Builder defaultBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private GroupServiceSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder.getChannelProvider(), settingsBuilder.getExecutorProvider(), settingsBuilder.getGeneratorName(), settingsBuilder.getGeneratorVersion(), settingsBuilder.getClientLibName(), settingsBuilder.getClientLibVersion());
        this.listGroupsSettings = settingsBuilder.listGroupsSettings().build();
        this.getGroupSettings = settingsBuilder.getGroupSettings().build();
        this.createGroupSettings = settingsBuilder.createGroupSettings().build();
        this.updateGroupSettings = settingsBuilder.updateGroupSettings().build();
        this.deleteGroupSettings = settingsBuilder.deleteGroupSettings().build();
        this.listGroupMembersSettings = settingsBuilder.listGroupMembersSettings().build();
    }

    public static class Builder
    extends ServiceApiSettings.Builder {
        private final ImmutableList<UnaryCallSettings.Builder> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListGroupsRequest, ListGroupsResponse, PagedResponseWrappers.ListGroupsPagedResponse> listGroupsSettings;
        private final SimpleCallSettings.Builder<GetGroupRequest, Group> getGroupSettings;
        private final SimpleCallSettings.Builder<CreateGroupRequest, Group> createGroupSettings;
        private final SimpleCallSettings.Builder<UpdateGroupRequest, Group> updateGroupSettings;
        private final SimpleCallSettings.Builder<DeleteGroupRequest, Empty> deleteGroupSettings;
        private final PagedCallSettings.Builder<ListGroupMembersRequest, ListGroupMembersResponse, PagedResponseWrappers.ListGroupMembersPagedResponse> listGroupMembersSettings;
        private static final ImmutableMap<String, ImmutableSet<Status.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings.Builder> RETRY_PARAM_DEFINITIONS;

        private Builder() {
            super(Builder.s_getDefaultConnectionSettingsBuilder().build());
            this.listGroupsSettings = PagedCallSettings.newBuilder((MethodDescriptor)GroupServiceGrpc.METHOD_LIST_GROUPS, (PagedListResponseFactory)LIST_GROUPS_PAGE_STR_FACT);
            this.getGroupSettings = SimpleCallSettings.newBuilder((MethodDescriptor)GroupServiceGrpc.METHOD_GET_GROUP);
            this.createGroupSettings = SimpleCallSettings.newBuilder((MethodDescriptor)GroupServiceGrpc.METHOD_CREATE_GROUP);
            this.updateGroupSettings = SimpleCallSettings.newBuilder((MethodDescriptor)GroupServiceGrpc.METHOD_UPDATE_GROUP);
            this.deleteGroupSettings = SimpleCallSettings.newBuilder((MethodDescriptor)GroupServiceGrpc.METHOD_DELETE_GROUP);
            this.listGroupMembersSettings = PagedCallSettings.newBuilder((MethodDescriptor)GroupServiceGrpc.METHOD_LIST_GROUP_MEMBERS, (PagedListResponseFactory)LIST_GROUP_MEMBERS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listGroupsSettings, this.getGroupSettings, this.createGroupSettings, this.updateGroupSettings, this.deleteGroupSettings, this.listGroupMembersSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder();
            builder.listGroupsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteGroupSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listGroupMembersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettingsBuilder((RetrySettings.Builder)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        private Builder(GroupServiceSettings settings) {
            super((ServiceApiSettings)settings);
            this.listGroupsSettings = settings.listGroupsSettings.toBuilder();
            this.getGroupSettings = settings.getGroupSettings.toBuilder();
            this.createGroupSettings = settings.createGroupSettings.toBuilder();
            this.updateGroupSettings = settings.updateGroupSettings.toBuilder();
            this.deleteGroupSettings = settings.deleteGroupSettings.toBuilder();
            this.listGroupMembersSettings = settings.listGroupMembersSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listGroupsSettings, this.getGroupSettings, this.createGroupSettings, this.updateGroupSettings, this.deleteGroupSettings, this.listGroupMembersSettings);
        }

        private static ConnectionSettings.Builder s_getDefaultConnectionSettingsBuilder() {
            return ConnectionSettings.newBuilder().setServiceAddress(GroupServiceSettings.DEFAULT_SERVICE_ADDRESS).setPort(443).provideCredentialsWith((List)DEFAULT_SERVICE_SCOPES);
        }

        protected ConnectionSettings.Builder getDefaultConnectionSettingsBuilder() {
            return Builder.s_getDefaultConnectionSettingsBuilder();
        }

        public Builder provideExecutorWith(ScheduledExecutorService executor, boolean shouldAutoClose) {
            super.provideExecutorWith(executor, shouldAutoClose);
            return this;
        }

        public Builder provideChannelWith(ManagedChannel channel, boolean shouldAutoClose) {
            super.provideChannelWith(channel, shouldAutoClose);
            return this;
        }

        public Builder provideChannelWith(ConnectionSettings settings) {
            super.provideChannelWith(settings);
            return this;
        }

        public Builder provideChannelWith(Credentials credentials) {
            super.provideChannelWith(credentials);
            return this;
        }

        public Builder provideChannelWith(List<String> scopes) {
            super.provideChannelWith(scopes);
            return this;
        }

        public Builder setGeneratorHeader(String name, String version) {
            super.setGeneratorHeader(name, version);
            return this;
        }

        public Builder setClientLibHeader(String name, String version) {
            super.setClientLibHeader(name, version);
            return this;
        }

        public Builder applyToAllApiMethods(UnaryCallSettings.Builder apiCallSettings) throws Exception {
            super.applyToAllApiMethods(this.unaryMethodSettingsBuilders, apiCallSettings);
            return this;
        }

        public PagedCallSettings.Builder<ListGroupsRequest, ListGroupsResponse, PagedResponseWrappers.ListGroupsPagedResponse> listGroupsSettings() {
            return this.listGroupsSettings;
        }

        public SimpleCallSettings.Builder<GetGroupRequest, Group> getGroupSettings() {
            return this.getGroupSettings;
        }

        public SimpleCallSettings.Builder<CreateGroupRequest, Group> createGroupSettings() {
            return this.createGroupSettings;
        }

        public SimpleCallSettings.Builder<UpdateGroupRequest, Group> updateGroupSettings() {
            return this.updateGroupSettings;
        }

        public SimpleCallSettings.Builder<DeleteGroupRequest, Empty> deleteGroupSettings() {
            return this.deleteGroupSettings;
        }

        public PagedCallSettings.Builder<ListGroupMembersRequest, ListGroupMembersResponse, PagedResponseWrappers.ListGroupMembersPagedResponse> listGroupMembersSettings() {
            return this.listGroupMembersSettings;
        }

        public GroupServiceSettings build() throws IOException {
            return new GroupServiceSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList((Object[])new Status.Code[]{Status.Code.DEADLINE_EXCEEDED, Status.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)Sets.immutableEnumSet((Iterable)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings.Builder settingsBuilder = null;
            settingsBuilder = RetrySettings.newBuilder().setInitialRetryDelay(Duration.millis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.millis((long)60000L)).setInitialRpcTimeout(Duration.millis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.millis((long)20000L)).setTotalTimeout(Duration.millis((long)600000L));
            definitions.put((Object)"default", (Object)settingsBuilder);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

