/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.monitoring.spi.v3;

import com.google.api.MetricDescriptor;
import com.google.api.MonitoredResourceDescriptor;
import com.google.api.gax.grpc.ChannelAndExecutor;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.api.gax.protobuf.PathTemplate;
import com.google.cloud.monitoring.spi.v3.MetricServiceSettings;
import com.google.cloud.monitoring.spi.v3.PagedResponseWrappers;
import com.google.monitoring.v3.CreateMetricDescriptorRequest;
import com.google.monitoring.v3.CreateTimeSeriesRequest;
import com.google.monitoring.v3.DeleteMetricDescriptorRequest;
import com.google.monitoring.v3.GetMetricDescriptorRequest;
import com.google.monitoring.v3.GetMonitoredResourceDescriptorRequest;
import com.google.monitoring.v3.ListMetricDescriptorsRequest;
import com.google.monitoring.v3.ListMetricDescriptorsResponse;
import com.google.monitoring.v3.ListMonitoredResourceDescriptorsRequest;
import com.google.monitoring.v3.ListMonitoredResourceDescriptorsResponse;
import com.google.monitoring.v3.ListTimeSeriesRequest;
import com.google.monitoring.v3.ListTimeSeriesResponse;
import com.google.monitoring.v3.TimeInterval;
import com.google.monitoring.v3.TimeSeries;
import com.google.protobuf.Empty;
import io.grpc.ManagedChannel;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;

public class MetricServiceApi
implements AutoCloseable {
    private final MetricServiceSettings settings;
    private final ScheduledExecutorService executor;
    private final ManagedChannel channel;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private final UnaryCallable<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse> listMonitoredResourceDescriptorsCallable;
    private final UnaryCallable<ListMonitoredResourceDescriptorsRequest, PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse> listMonitoredResourceDescriptorsPagedCallable;
    private final UnaryCallable<GetMonitoredResourceDescriptorRequest, MonitoredResourceDescriptor> getMonitoredResourceDescriptorCallable;
    private final UnaryCallable<ListMetricDescriptorsRequest, ListMetricDescriptorsResponse> listMetricDescriptorsCallable;
    private final UnaryCallable<ListMetricDescriptorsRequest, PagedResponseWrappers.ListMetricDescriptorsPagedResponse> listMetricDescriptorsPagedCallable;
    private final UnaryCallable<GetMetricDescriptorRequest, MetricDescriptor> getMetricDescriptorCallable;
    private final UnaryCallable<CreateMetricDescriptorRequest, MetricDescriptor> createMetricDescriptorCallable;
    private final UnaryCallable<DeleteMetricDescriptorRequest, Empty> deleteMetricDescriptorCallable;
    private final UnaryCallable<ListTimeSeriesRequest, ListTimeSeriesResponse> listTimeSeriesCallable;
    private final UnaryCallable<ListTimeSeriesRequest, PagedResponseWrappers.ListTimeSeriesPagedResponse> listTimeSeriesPagedCallable;
    private final UnaryCallable<CreateTimeSeriesRequest, Empty> createTimeSeriesCallable;
    private static final PathTemplate PROJECT_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}");
    private static final PathTemplate GROUP_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/groups/{group}");
    private static final PathTemplate METRIC_DESCRIPTOR_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/metricDescriptors/{metric_descriptor=**}");
    private static final PathTemplate MONITORED_RESOURCE_DESCRIPTOR_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/monitoredResourceDescriptors/{monitored_resource_descriptor}");

    public static final String formatProjectName(String project) {
        return PROJECT_PATH_TEMPLATE.instantiate(new String[]{"project", project});
    }

    public static final String formatGroupName(String project, String group) {
        return GROUP_PATH_TEMPLATE.instantiate(new String[]{"project", project, "group", group});
    }

    public static final String formatMetricDescriptorName(String project, String metricDescriptor) {
        return METRIC_DESCRIPTOR_PATH_TEMPLATE.instantiate(new String[]{"project", project, "metric_descriptor", metricDescriptor});
    }

    public static final String formatMonitoredResourceDescriptorName(String project, String monitoredResourceDescriptor) {
        return MONITORED_RESOURCE_DESCRIPTOR_PATH_TEMPLATE.instantiate(new String[]{"project", project, "monitored_resource_descriptor", monitoredResourceDescriptor});
    }

    public static final String parseProjectFromProjectName(String projectName) {
        return PROJECT_PATH_TEMPLATE.parse(projectName).get((Object)"project");
    }

    public static final String parseProjectFromGroupName(String groupName) {
        return GROUP_PATH_TEMPLATE.parse(groupName).get((Object)"project");
    }

    public static final String parseGroupFromGroupName(String groupName) {
        return GROUP_PATH_TEMPLATE.parse(groupName).get((Object)"group");
    }

    public static final String parseProjectFromMetricDescriptorName(String metricDescriptorName) {
        return METRIC_DESCRIPTOR_PATH_TEMPLATE.parse(metricDescriptorName).get((Object)"project");
    }

    public static final String parseMetricDescriptorFromMetricDescriptorName(String metricDescriptorName) {
        return METRIC_DESCRIPTOR_PATH_TEMPLATE.parse(metricDescriptorName).get((Object)"metric_descriptor");
    }

    public static final String parseProjectFromMonitoredResourceDescriptorName(String monitoredResourceDescriptorName) {
        return MONITORED_RESOURCE_DESCRIPTOR_PATH_TEMPLATE.parse(monitoredResourceDescriptorName).get((Object)"project");
    }

    public static final String parseMonitoredResourceDescriptorFromMonitoredResourceDescriptorName(String monitoredResourceDescriptorName) {
        return MONITORED_RESOURCE_DESCRIPTOR_PATH_TEMPLATE.parse(monitoredResourceDescriptorName).get((Object)"monitored_resource_descriptor");
    }

    public static final MetricServiceApi create() throws IOException {
        return MetricServiceApi.create(MetricServiceSettings.defaultBuilder().build());
    }

    public static final MetricServiceApi create(MetricServiceSettings settings) throws IOException {
        return new MetricServiceApi(settings);
    }

    protected MetricServiceApi(MetricServiceSettings settings) throws IOException {
        this.settings = settings;
        ChannelAndExecutor channelAndExecutor = settings.getChannelAndExecutor();
        this.executor = channelAndExecutor.getExecutor();
        this.channel = channelAndExecutor.getChannel();
        this.listMonitoredResourceDescriptorsCallable = UnaryCallable.create(settings.listMonitoredResourceDescriptorsSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.listMonitoredResourceDescriptorsPagedCallable = UnaryCallable.createPagedVariant(settings.listMonitoredResourceDescriptorsSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.getMonitoredResourceDescriptorCallable = UnaryCallable.create(settings.getMonitoredResourceDescriptorSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.listMetricDescriptorsCallable = UnaryCallable.create(settings.listMetricDescriptorsSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.listMetricDescriptorsPagedCallable = UnaryCallable.createPagedVariant(settings.listMetricDescriptorsSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.getMetricDescriptorCallable = UnaryCallable.create(settings.getMetricDescriptorSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.createMetricDescriptorCallable = UnaryCallable.create(settings.createMetricDescriptorSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.deleteMetricDescriptorCallable = UnaryCallable.create(settings.deleteMetricDescriptorSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.listTimeSeriesCallable = UnaryCallable.create(settings.listTimeSeriesSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.listTimeSeriesPagedCallable = UnaryCallable.createPagedVariant(settings.listTimeSeriesSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        this.createTimeSeriesCallable = UnaryCallable.create(settings.createTimeSeriesSettings(), (ManagedChannel)this.channel, (ScheduledExecutorService)this.executor);
        if (settings.getChannelProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    MetricServiceApi.this.channel.shutdown();
                }
            });
        }
        if (settings.getExecutorProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    MetricServiceApi.this.executor.shutdown();
                }
            });
        }
    }

    public final MetricServiceSettings getSettings() {
        return this.settings;
    }

    public final PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse listMonitoredResourceDescriptors(String name) {
        PROJECT_PATH_TEMPLATE.validate(name, "listMonitoredResourceDescriptors");
        ListMonitoredResourceDescriptorsRequest request = ListMonitoredResourceDescriptorsRequest.newBuilder().setName(name).build();
        return this.listMonitoredResourceDescriptors(request);
    }

    public final PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse listMonitoredResourceDescriptors(ListMonitoredResourceDescriptorsRequest request) {
        return (PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse)((Object)this.listMonitoredResourceDescriptorsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListMonitoredResourceDescriptorsRequest, PagedResponseWrappers.ListMonitoredResourceDescriptorsPagedResponse> listMonitoredResourceDescriptorsPagedCallable() {
        return this.listMonitoredResourceDescriptorsPagedCallable;
    }

    public final UnaryCallable<ListMonitoredResourceDescriptorsRequest, ListMonitoredResourceDescriptorsResponse> listMonitoredResourceDescriptorsCallable() {
        return this.listMonitoredResourceDescriptorsCallable;
    }

    public final MonitoredResourceDescriptor getMonitoredResourceDescriptor(String name) {
        MONITORED_RESOURCE_DESCRIPTOR_PATH_TEMPLATE.validate(name, "getMonitoredResourceDescriptor");
        GetMonitoredResourceDescriptorRequest request = GetMonitoredResourceDescriptorRequest.newBuilder().setName(name).build();
        return this.getMonitoredResourceDescriptor(request);
    }

    private final MonitoredResourceDescriptor getMonitoredResourceDescriptor(GetMonitoredResourceDescriptorRequest request) {
        return (MonitoredResourceDescriptor)this.getMonitoredResourceDescriptorCallable().call((Object)request);
    }

    public final UnaryCallable<GetMonitoredResourceDescriptorRequest, MonitoredResourceDescriptor> getMonitoredResourceDescriptorCallable() {
        return this.getMonitoredResourceDescriptorCallable;
    }

    public final PagedResponseWrappers.ListMetricDescriptorsPagedResponse listMetricDescriptors(String name) {
        PROJECT_PATH_TEMPLATE.validate(name, "listMetricDescriptors");
        ListMetricDescriptorsRequest request = ListMetricDescriptorsRequest.newBuilder().setName(name).build();
        return this.listMetricDescriptors(request);
    }

    public final PagedResponseWrappers.ListMetricDescriptorsPagedResponse listMetricDescriptors(ListMetricDescriptorsRequest request) {
        return (PagedResponseWrappers.ListMetricDescriptorsPagedResponse)((Object)this.listMetricDescriptorsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListMetricDescriptorsRequest, PagedResponseWrappers.ListMetricDescriptorsPagedResponse> listMetricDescriptorsPagedCallable() {
        return this.listMetricDescriptorsPagedCallable;
    }

    public final UnaryCallable<ListMetricDescriptorsRequest, ListMetricDescriptorsResponse> listMetricDescriptorsCallable() {
        return this.listMetricDescriptorsCallable;
    }

    public final MetricDescriptor getMetricDescriptor(String name) {
        METRIC_DESCRIPTOR_PATH_TEMPLATE.validate(name, "getMetricDescriptor");
        GetMetricDescriptorRequest request = GetMetricDescriptorRequest.newBuilder().setName(name).build();
        return this.getMetricDescriptor(request);
    }

    private final MetricDescriptor getMetricDescriptor(GetMetricDescriptorRequest request) {
        return (MetricDescriptor)this.getMetricDescriptorCallable().call((Object)request);
    }

    public final UnaryCallable<GetMetricDescriptorRequest, MetricDescriptor> getMetricDescriptorCallable() {
        return this.getMetricDescriptorCallable;
    }

    public final MetricDescriptor createMetricDescriptor(String name, MetricDescriptor metricDescriptor) {
        PROJECT_PATH_TEMPLATE.validate(name, "createMetricDescriptor");
        CreateMetricDescriptorRequest request = CreateMetricDescriptorRequest.newBuilder().setName(name).setMetricDescriptor(metricDescriptor).build();
        return this.createMetricDescriptor(request);
    }

    public final MetricDescriptor createMetricDescriptor(CreateMetricDescriptorRequest request) {
        return (MetricDescriptor)this.createMetricDescriptorCallable().call((Object)request);
    }

    public final UnaryCallable<CreateMetricDescriptorRequest, MetricDescriptor> createMetricDescriptorCallable() {
        return this.createMetricDescriptorCallable;
    }

    public final void deleteMetricDescriptor(String name) {
        METRIC_DESCRIPTOR_PATH_TEMPLATE.validate(name, "deleteMetricDescriptor");
        DeleteMetricDescriptorRequest request = DeleteMetricDescriptorRequest.newBuilder().setName(name).build();
        this.deleteMetricDescriptor(request);
    }

    private final void deleteMetricDescriptor(DeleteMetricDescriptorRequest request) {
        this.deleteMetricDescriptorCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteMetricDescriptorRequest, Empty> deleteMetricDescriptorCallable() {
        return this.deleteMetricDescriptorCallable;
    }

    public final PagedResponseWrappers.ListTimeSeriesPagedResponse listTimeSeries(String name, String filter, TimeInterval interval, ListTimeSeriesRequest.TimeSeriesView view) {
        PROJECT_PATH_TEMPLATE.validate(name, "listTimeSeries");
        ListTimeSeriesRequest request = ListTimeSeriesRequest.newBuilder().setName(name).setFilter(filter).setInterval(interval).setView(view).build();
        return this.listTimeSeries(request);
    }

    public final PagedResponseWrappers.ListTimeSeriesPagedResponse listTimeSeries(ListTimeSeriesRequest request) {
        return (PagedResponseWrappers.ListTimeSeriesPagedResponse)((Object)this.listTimeSeriesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTimeSeriesRequest, PagedResponseWrappers.ListTimeSeriesPagedResponse> listTimeSeriesPagedCallable() {
        return this.listTimeSeriesPagedCallable;
    }

    public final UnaryCallable<ListTimeSeriesRequest, ListTimeSeriesResponse> listTimeSeriesCallable() {
        return this.listTimeSeriesCallable;
    }

    public final void createTimeSeries(String name, List<TimeSeries> timeSeries) {
        PROJECT_PATH_TEMPLATE.validate(name, "createTimeSeries");
        CreateTimeSeriesRequest request = CreateTimeSeriesRequest.newBuilder().setName(name).addAllTimeSeries(timeSeries).build();
        this.createTimeSeries(request);
    }

    public final void createTimeSeries(CreateTimeSeriesRequest request) {
        this.createTimeSeriesCallable().call((Object)request);
    }

    public final UnaryCallable<CreateTimeSeriesRequest, Empty> createTimeSeriesCallable() {
        return this.createTimeSeriesCallable;
    }

    @Override
    public final void close() throws Exception {
        for (AutoCloseable closeable : this.closeables) {
            closeable.close();
        }
    }
}

