/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.monitoring.v3.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.monitoring.v3.AlertPolicyServiceClient;
import com.google.cloud.monitoring.v3.stub.AlertPolicyServiceStub;
import com.google.cloud.monitoring.v3.stub.GrpcAlertPolicyServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.monitoring.v3.AlertPolicy;
import com.google.monitoring.v3.CreateAlertPolicyRequest;
import com.google.monitoring.v3.DeleteAlertPolicyRequest;
import com.google.monitoring.v3.GetAlertPolicyRequest;
import com.google.monitoring.v3.ListAlertPoliciesRequest;
import com.google.monitoring.v3.ListAlertPoliciesResponse;
import com.google.monitoring.v3.UpdateAlertPolicyRequest;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class AlertPolicyServiceStubSettings
extends StubSettings<AlertPolicyServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/monitoring").add((Object)"https://www.googleapis.com/auth/monitoring.read").build();
    private final PagedCallSettings<ListAlertPoliciesRequest, ListAlertPoliciesResponse, AlertPolicyServiceClient.ListAlertPoliciesPagedResponse> listAlertPoliciesSettings;
    private final UnaryCallSettings<GetAlertPolicyRequest, AlertPolicy> getAlertPolicySettings;
    private final UnaryCallSettings<CreateAlertPolicyRequest, AlertPolicy> createAlertPolicySettings;
    private final UnaryCallSettings<DeleteAlertPolicyRequest, Empty> deleteAlertPolicySettings;
    private final UnaryCallSettings<UpdateAlertPolicyRequest, AlertPolicy> updateAlertPolicySettings;
    private static final PagedListDescriptor<ListAlertPoliciesRequest, ListAlertPoliciesResponse, AlertPolicy> LIST_ALERT_POLICIES_PAGE_STR_DESC = new PagedListDescriptor<ListAlertPoliciesRequest, ListAlertPoliciesResponse, AlertPolicy>(){

        public String emptyToken() {
            return "";
        }

        public ListAlertPoliciesRequest injectToken(ListAlertPoliciesRequest payload, String token) {
            return ListAlertPoliciesRequest.newBuilder((ListAlertPoliciesRequest)payload).setPageToken(token).build();
        }

        public ListAlertPoliciesRequest injectPageSize(ListAlertPoliciesRequest payload, int pageSize) {
            return ListAlertPoliciesRequest.newBuilder((ListAlertPoliciesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAlertPoliciesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAlertPoliciesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AlertPolicy> extractResources(ListAlertPoliciesResponse payload) {
            return payload.getAlertPoliciesList() == null ? ImmutableList.of() : payload.getAlertPoliciesList();
        }
    };
    private static final PagedListResponseFactory<ListAlertPoliciesRequest, ListAlertPoliciesResponse, AlertPolicyServiceClient.ListAlertPoliciesPagedResponse> LIST_ALERT_POLICIES_PAGE_STR_FACT = new PagedListResponseFactory<ListAlertPoliciesRequest, ListAlertPoliciesResponse, AlertPolicyServiceClient.ListAlertPoliciesPagedResponse>(){

        public ApiFuture<AlertPolicyServiceClient.ListAlertPoliciesPagedResponse> getFuturePagedResponse(UnaryCallable<ListAlertPoliciesRequest, ListAlertPoliciesResponse> callable, ListAlertPoliciesRequest request, ApiCallContext context, ApiFuture<ListAlertPoliciesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ALERT_POLICIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AlertPolicyServiceClient.ListAlertPoliciesPagedResponse.createAsync((PageContext<ListAlertPoliciesRequest, ListAlertPoliciesResponse, AlertPolicy>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListAlertPoliciesRequest, ListAlertPoliciesResponse, AlertPolicyServiceClient.ListAlertPoliciesPagedResponse> listAlertPoliciesSettings() {
        return this.listAlertPoliciesSettings;
    }

    public UnaryCallSettings<GetAlertPolicyRequest, AlertPolicy> getAlertPolicySettings() {
        return this.getAlertPolicySettings;
    }

    public UnaryCallSettings<CreateAlertPolicyRequest, AlertPolicy> createAlertPolicySettings() {
        return this.createAlertPolicySettings;
    }

    public UnaryCallSettings<DeleteAlertPolicyRequest, Empty> deleteAlertPolicySettings() {
        return this.deleteAlertPolicySettings;
    }

    public UnaryCallSettings<UpdateAlertPolicyRequest, AlertPolicy> updateAlertPolicySettings() {
        return this.updateAlertPolicySettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public AlertPolicyServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcAlertPolicyServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "monitoring.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "monitoring.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AlertPolicyServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AlertPolicyServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AlertPolicyServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listAlertPoliciesSettings = settingsBuilder.listAlertPoliciesSettings().build();
        this.getAlertPolicySettings = settingsBuilder.getAlertPolicySettings().build();
        this.createAlertPolicySettings = settingsBuilder.createAlertPolicySettings().build();
        this.deleteAlertPolicySettings = settingsBuilder.deleteAlertPolicySettings().build();
        this.updateAlertPolicySettings = settingsBuilder.updateAlertPolicySettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AlertPolicyServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListAlertPoliciesRequest, ListAlertPoliciesResponse, AlertPolicyServiceClient.ListAlertPoliciesPagedResponse> listAlertPoliciesSettings;
        private final UnaryCallSettings.Builder<GetAlertPolicyRequest, AlertPolicy> getAlertPolicySettings;
        private final UnaryCallSettings.Builder<CreateAlertPolicyRequest, AlertPolicy> createAlertPolicySettings;
        private final UnaryCallSettings.Builder<DeleteAlertPolicyRequest, Empty> deleteAlertPolicySettings;
        private final UnaryCallSettings.Builder<UpdateAlertPolicyRequest, AlertPolicy> updateAlertPolicySettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listAlertPoliciesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ALERT_POLICIES_PAGE_STR_FACT);
            this.getAlertPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createAlertPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteAlertPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateAlertPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listAlertPoliciesSettings, this.getAlertPolicySettings, this.createAlertPolicySettings, this.deleteAlertPolicySettings, this.updateAlertPolicySettings);
            Builder.initDefaults(this);
        }

        protected Builder(AlertPolicyServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listAlertPoliciesSettings = settings.listAlertPoliciesSettings.toBuilder();
            this.getAlertPolicySettings = settings.getAlertPolicySettings.toBuilder();
            this.createAlertPolicySettings = settings.createAlertPolicySettings.toBuilder();
            this.deleteAlertPolicySettings = settings.deleteAlertPolicySettings.toBuilder();
            this.updateAlertPolicySettings = settings.updateAlertPolicySettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listAlertPoliciesSettings, this.getAlertPolicySettings, this.createAlertPolicySettings, this.deleteAlertPolicySettings, this.updateAlertPolicySettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AlertPolicyServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AlertPolicyServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AlertPolicyServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(AlertPolicyServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(AlertPolicyServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listAlertPoliciesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_8_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_8_params"));
            builder.getAlertPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_8_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_8_params"));
            builder.createAlertPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteAlertPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_8_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_8_params"));
            builder.updateAlertPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListAlertPoliciesRequest, ListAlertPoliciesResponse, AlertPolicyServiceClient.ListAlertPoliciesPagedResponse> listAlertPoliciesSettings() {
            return this.listAlertPoliciesSettings;
        }

        public UnaryCallSettings.Builder<GetAlertPolicyRequest, AlertPolicy> getAlertPolicySettings() {
            return this.getAlertPolicySettings;
        }

        public UnaryCallSettings.Builder<CreateAlertPolicyRequest, AlertPolicy> createAlertPolicySettings() {
            return this.createAlertPolicySettings;
        }

        public UnaryCallSettings.Builder<DeleteAlertPolicyRequest, Empty> deleteAlertPolicySettings() {
            return this.deleteAlertPolicySettings;
        }

        public UnaryCallSettings.Builder<UpdateAlertPolicyRequest, AlertPolicy> updateAlertPolicySettings() {
            return this.updateAlertPolicySettings;
        }

        public AlertPolicyServiceStubSettings build() throws IOException {
            return new AlertPolicyServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_8_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)30000L)).setInitialRpcTimeout(Duration.ofMillis((long)30000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)30000L)).setTotalTimeout(Duration.ofMillis((long)30000L)).build();
            definitions.put((Object)"retry_policy_8_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)30000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)30000L)).setTotalTimeout(Duration.ofMillis((long)30000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

